/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.BuiltInsProviderKt;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.AllCandidatesResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CandidateWithDiagnostics;
import org.jetbrains.kotlin.resolve.calls.model.CompletedCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ErrorCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ManyCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.NoneCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.PartialCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.model.SingleCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u001f\u001a\u00020\u0014*\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010!\u001a\u00020\u0014*\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\"\u001a\u00020\b*\u00020\u000b2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020$J \u0010%\u001a\u00020\u0018*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010&\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010'\u001a\u00020\r*\u00020\u000b2\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010(\u001a\u00020\u001e*\u00020\u000b2\u0006\u0010#\u001a\u00020\rH\u0002J\u0014\u0010)\u001a\u00020\u001e*\u00020\u000b2\u0006\u0010*\u001a\u00020\rH\u0002J\f\u0010+\u001a\u00020\u001e*\u00020\u000bH\u0002J\u0016\u0010,\u001a\u0004\u0018\u00010\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0013\u001a\u00020\b*\u00020\u000b2\u0006\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "(Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;)V", "createAllCandidatesResult", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "prepareCandidateForCompletion", "factory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "runCompletion", "", "resolvedCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "collectAllCandidatesMode", "", "addExpectedTypeConstraint", "returnType", "addExpectedTypeFromCastConstraint", "asCallResolutionResult", "type", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder$SimpleHolder;", "computeCompletionMode", "currentReturnType", "computeReturnTypeWithSmartCastInfo", "containsTypeVariablesWithProperEqualConstraints", "hasProperNonTrivialLowerConstraints", "typeVariable", "isErrorCandidate", "returnTypeWithSmartCastInfo", "completionType", "diagnosticHolder", "resolution"})
public final class KotlinCallCompleter {
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;

    @NotNull
    public final CallResolutionResult runCompletion(@NotNull SimpleCandidateFactory factory2, @NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        if (candidates2.isEmpty()) {
            diagnosticHolder.addDiagnostic(new NoneCandidatesCallDiagnostic(factory2.getKotlinCall()));
        } else if (candidates2.size() > 1) {
            diagnosticHolder.addDiagnostic(new ManyCandidatesCallDiagnostic(factory2.getKotlinCall(), candidates2));
        }
        KotlinResolutionCandidate candidate2 = this.prepareCandidateForCompletion(factory2, candidates2, resolutionCallbacks);
        UnwrappedType returnType2 = this.returnTypeWithSmartCastInfo(candidate2, resolutionCallbacks);
        this.addExpectedTypeConstraint(candidate2, returnType2, expectedType, resolutionCallbacks);
        this.addExpectedTypeFromCastConstraint(candidate2, returnType2, resolutionCallbacks);
        return resolutionCallbacks.getInferenceSession().shouldRunCompletion(candidate2) ? this.runCompletion(candidate2, this.computeCompletionMode(candidate2, expectedType, returnType2), diagnosticHolder, resolutionCallbacks) : this.asCallResolutionResult(candidate2, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL, diagnosticHolder);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallResolutionResult createAllCandidatesResult(@NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Iterable $this$map$iv = candidates2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void candidate2;
            KotlinResolutionCandidate kotlinResolutionCandidate = (KotlinResolutionCandidate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder = new KotlinDiagnosticsHolder.SimpleHolder();
            this.addExpectedTypeConstraint((KotlinResolutionCandidate)candidate2, this.returnTypeWithSmartCastInfo((KotlinResolutionCandidate)candidate2, resolutionCallbacks), expectedType, resolutionCallbacks);
            this.runCompletion(candidate2.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticsHolder, candidate2.getSystem(), resolutionCallbacks, true);
            CandidateWithDiagnostics candidateWithDiagnostics = new CandidateWithDiagnostics((KotlinResolutionCandidate)candidate2, CollectionsKt.plus((Collection)diagnosticsHolder.getDiagnostics(), (Iterable)candidate2.getDiagnosticsFromResolutionParts()));
            collection.add(candidateWithDiagnostics);
        }
        List completedCandidates = (List)destination$iv$iv;
        return new AllCandidatesResolutionResult(completedCandidates);
    }

    private final CallResolutionResult runCompletion(@NotNull KotlinResolutionCandidate $this$runCompletion, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionType, KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder, KotlinResolutionCallbacks resolutionCallbacks) {
        if (this.isErrorCandidate($this$runCompletion)) {
            KotlinCallCompleter.runCompletion$default(this, $this$runCompletion.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticHolder, $this$runCompletion.getSystem(), resolutionCallbacks, false, 32, null);
            return this.asCallResolutionResult($this$runCompletion, completionType, diagnosticHolder);
        }
        KotlinCallCompleter.runCompletion$default(this, $this$runCompletion.getResolvedCall(), completionType, diagnosticHolder, $this$runCompletion.getSystem(), resolutionCallbacks, false, 32, null);
        return this.asCallResolutionResult($this$runCompletion, completionType, diagnosticHolder);
    }

    private final void runCompletion(ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionMode, KotlinDiagnosticsHolder diagnosticsHolder, NewConstraintSystem constraintSystem, KotlinResolutionCallbacks resolutionCallbacks, boolean collectAllCandidatesMode) {
        UnwrappedType unwrappedType = ResolutionAtomsKt.getFreshReturnType(resolvedCallAtom);
        if (unwrappedType == null) {
            SimpleType simpleType2 = BuiltInsProviderKt.getBuiltIns(constraintSystem).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"constraintSystem.builtIns.unitType");
            unwrappedType = simpleType2;
        }
        UnwrappedType returnType2 = unwrappedType;
        this.kotlinConstraintSystemCompleter.runCompletion(constraintSystem.asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf((Object)resolvedCallAtom), returnType2, (Function1<? super PostponedResolvedAtom, Unit>)((Function1)new Function1<PostponedResolvedAtom, Unit>(this, collectAllCandidatesMode, constraintSystem, resolutionCallbacks, diagnosticsHolder){
            final /* synthetic */ KotlinCallCompleter this$0;
            final /* synthetic */ boolean $collectAllCandidatesMode;
            final /* synthetic */ NewConstraintSystem $constraintSystem;
            final /* synthetic */ KotlinResolutionCallbacks $resolutionCallbacks;
            final /* synthetic */ KotlinDiagnosticsHolder $diagnosticsHolder;

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$collectAllCandidatesMode) {
                    it.setEmptyAnalyzedResults();
                } else {
                    KotlinCallCompleter.access$getPostponedArgumentsAnalyzer$p(this.this$0).analyze(this.$constraintSystem.asPostponedArgumentsAnalyzerContext(), this.$resolutionCallbacks, it, this.$diagnosticsHolder);
                }
            }
            {
                this.this$0 = kotlinCallCompleter;
                this.$collectAllCandidatesMode = bl;
                this.$constraintSystem = newConstraintSystem;
                this.$resolutionCallbacks = kotlinResolutionCallbacks;
                this.$diagnosticsHolder = kotlinDiagnosticsHolder;
                super(1);
            }
        }));
        Iterable $this$forEach$iv = constraintSystem.getDiagnostics();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallDiagnostic p1 = (KotlinCallDiagnostic)element$iv;
            boolean bl = false;
            diagnosticsHolder.addDiagnostic(p1);
        }
    }

    static /* synthetic */ void runCompletion$default(KotlinCallCompleter kotlinCallCompleter, ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode constraintSystemCompletionMode, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, NewConstraintSystem newConstraintSystem, KotlinResolutionCallbacks kotlinResolutionCallbacks, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinCallCompleter.runCompletion(resolvedCallAtom, constraintSystemCompletionMode, kotlinDiagnosticsHolder, newConstraintSystem, kotlinResolutionCallbacks, bl);
    }

    private final KotlinResolutionCandidate prepareCandidateForCompletion(SimpleCandidateFactory factory2, Collection<KotlinResolutionCandidate> candidates2, KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinResolutionCandidate kotlinResolutionCandidate;
        KotlinResolutionCandidate candidate2 = (KotlinResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates2);
        Object object = candidate2;
        if (object != null && (object = ((KotlinResolutionCandidate)object).getResolvedCall()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            resolutionCallbacks.bindStubResolvedCallForCandidate((ResolvedCallAtom)it);
            resolutionCallbacks.disableContractsIfNecessary((ResolvedCallAtom)it);
        }
        if ((kotlinResolutionCandidate = candidate2) == null) {
            kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)factory2.createErrorCandidate());
        }
        return kotlinResolutionCandidate;
    }

    private final UnwrappedType returnTypeWithSmartCastInfo(@NotNull KotlinResolutionCandidate $this$returnTypeWithSmartCastInfo, KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinType kotlinType2 = $this$returnTypeWithSmartCastInfo.getResolvedCall().getCandidateDescriptor().getReturnType();
        if (kotlinType2 == null || (kotlinType2 = kotlinType2.unwrap()) == null) {
            return null;
        }
        KotlinType returnType2 = kotlinType2;
        UnwrappedType returnTypeWithSmartCastInfo = this.computeReturnTypeWithSmartCastInfo($this$returnTypeWithSmartCastInfo, (UnwrappedType)returnType2, resolutionCallbacks);
        return $this$returnTypeWithSmartCastInfo.getResolvedCall().getSubstitutor().safeSubstitute(returnTypeWithSmartCastInfo);
    }

    private final void addExpectedTypeConstraint(@NotNull KotlinResolutionCandidate $this$addExpectedTypeConstraint, UnwrappedType returnType2, UnwrappedType expectedType, KotlinResolutionCallbacks resolutionCallbacks) {
        if (returnType2 == null) {
            return;
        }
        if (expectedType == null || TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        if ($this$addExpectedTypeConstraint.getCsBuilder$resolution().currentStorage().getNotFixedTypeVariables().isEmpty()) {
            return;
        }
        if (!resolutionCallbacks.isCompileTimeConstant($this$addExpectedTypeConstraint.getResolvedCall(), expectedType)) {
            $this$addExpectedTypeConstraint.getCsBuilder$resolution().addSubtypeConstraint(returnType2, expectedType, new ExpectedTypeConstraintPosition($this$addExpectedTypeConstraint.getResolvedCall().getAtom()));
        }
    }

    private final void addExpectedTypeFromCastConstraint(@NotNull KotlinResolutionCandidate $this$addExpectedTypeFromCastConstraint, UnwrappedType returnType2, KotlinResolutionCallbacks resolutionCallbacks) {
        if (!$this$addExpectedTypeFromCastConstraint.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.ExpectedTypeFromCast)) {
            return;
        }
        if (returnType2 == null) {
            return;
        }
        UnwrappedType unwrappedType = resolutionCallbacks.getExpectedTypeFromAsExpressionAndRecordItInTrace($this$addExpectedTypeFromCastConstraint.getResolvedCall());
        if (unwrappedType == null) {
            return;
        }
        UnwrappedType expectedType = unwrappedType;
        $this$addExpectedTypeFromCastConstraint.getCsBuilder$resolution().addSubtypeConstraint(returnType2, expectedType, new ExpectedTypeConstraintPosition($this$addExpectedTypeFromCastConstraint.getResolvedCall().getAtom()));
    }

    private final KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode computeCompletionMode(@NotNull KotlinResolutionCandidate $this$computeCompletionMode, UnwrappedType expectedType, UnwrappedType currentReturnType) {
        if (expectedType != null) {
            return KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL;
        }
        if (currentReturnType == null) {
            return KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
        }
        return $this$computeCompletionMode.getCsBuilder$resolution().isProperType(currentReturnType) ? KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL : ($this$computeCompletionMode.getCsBuilder$resolution().isTypeVariable(currentReturnType) ? (this.hasProperNonTrivialLowerConstraints($this$computeCompletionMode, currentReturnType) ? KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL : KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL) : (this.containsTypeVariablesWithProperEqualConstraints($this$computeCompletionMode, currentReturnType) ? KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL : KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsTypeVariablesWithProperEqualConstraints(@NotNull KotlinResolutionCandidate $this$containsTypeVariablesWithProperEqualConstraints, UnwrappedType type2) {
        Map<TypeConstructorMarker, VariableWithConstraints> map2 = $this$containsTypeVariablesWithProperEqualConstraints.getCsBuilder$resolution().currentStorage().getNotFixedTypeVariables();
        boolean bl = false;
        Iterator<Map.Entry<TypeConstructorMarker, VariableWithConstraints>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Constraint it;
            Map.Entry<TypeConstructorMarker, VariableWithConstraints> entry;
            Map.Entry<TypeConstructorMarker, VariableWithConstraints> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            TypeConstructorMarker variableConstructor = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            VariableWithConstraints variableWithConstraints = entry2.getValue();
            if (!TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(variableConstructor){
                final /* synthetic */ TypeConstructorMarker $variableConstructor;

                public final boolean invoke(@NotNull UnwrappedType it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getConstructor(), (Object)this.$variableConstructor);
                }
                {
                    this.$variableConstructor = typeConstructorMarker;
                    super(1);
                }
            }))) continue;
            List<Constraint> constraints = variableWithConstraints.getConstraints();
            Collection collection = constraints;
            boolean bl3 = false;
            if (collection.isEmpty()) return false;
            boolean bl4 = true;
            if (!bl4) return false;
            Iterable $this$any$iv = constraints;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator3 = $this$any$iv.iterator();
            do {
                if (!iterator3.hasNext()) return false;
                Object element$iv = iterator3.next();
                it = (Constraint)element$iv;
                boolean bl5 = false;
            } while (!(it.getKind().isEqual() && $this$containsTypeVariablesWithProperEqualConstraints.getCsBuilder$resolution().isProperType(it.getType())));
            boolean bl6 = true;
            if (!bl6) return false;
            boolean bl7 = true;
            boolean onlyProperEqualConstraints = bl7;
            if (!onlyProperEqualConstraints) return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasProperNonTrivialLowerConstraints(@NotNull KotlinResolutionCandidate $this$hasProperNonTrivialLowerConstraints, UnwrappedType typeVariable2) {
        boolean bl;
        boolean bl2 = $this$hasProperNonTrivialLowerConstraints.getCsBuilder$resolution().isTypeVariable(typeVariable2);
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-KotlinCallCompleter$hasProperNonTrivialLowerConstraints$22 = false;
            String $i$a$-assert-KotlinCallCompleter$hasProperNonTrivialLowerConstraints$22 = typeVariable2 + " is not a type variable";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-KotlinCallCompleter$hasProperNonTrivialLowerConstraints$22));
        }
        NewConstraintSystem newConstraintSystem = $this$hasProperNonTrivialLowerConstraints.getSystem();
        if (newConstraintSystem == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext");
        }
        TypeSystemInferenceExtensionContext context = (TypeSystemInferenceExtensionContext)((Object)newConstraintSystem);
        TypeConstructor constructor2 = typeVariable2.getConstructor();
        VariableWithConstraints variableWithConstraints = $this$hasProperNonTrivialLowerConstraints.getCsBuilder$resolution().currentStorage().getNotFixedTypeVariables().get(constructor2);
        if (variableWithConstraints == null) return false;
        VariableWithConstraints variableWithConstraints2 = variableWithConstraints;
        List<Constraint> constraints = variableWithConstraints2.getConstraints();
        Collection collection = constraints;
        boolean bl4 = false;
        if (collection.isEmpty()) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        Iterable $this$any$iv = constraints;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Constraint it = (Constraint)element$iv;
            boolean bl6 = false;
            if (!TypeSystemContextHelpersKt.isIntegerLiteralTypeConstructor(TypeSystemContextHelpersKt.typeConstructor(it.getType(), context), context) && (it.getKind().isLower() || it.getKind().isEqual()) && $this$hasProperNonTrivialLowerConstraints.getCsBuilder$resolution().isProperType(it.getType())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final UnwrappedType computeReturnTypeWithSmartCastInfo(@NotNull KotlinResolutionCandidate $this$computeReturnTypeWithSmartCastInfo, UnwrappedType returnType2, KotlinResolutionCallbacks resolutionCallbacks) {
        if ($this$computeReturnTypeWithSmartCastInfo.getResolvedCall().getAtom().getCallKind() != KotlinCallKind.VARIABLE) {
            return returnType2;
        }
        Object object = resolutionCallbacks.createReceiverWithSmartCastInfo($this$computeReturnTypeWithSmartCastInfo.getResolvedCall());
        if (object == null || (object = ArgumentsUtilsKt.getStableType((ReceiverValueWithSmartCastInfo)object)) == null) {
            object = returnType2;
        }
        return object;
    }

    @NotNull
    public final CallResolutionResult asCallResolutionResult(@NotNull KotlinResolutionCandidate $this$asCallResolutionResult, @NotNull KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode type2, @NotNull KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asCallResolutionResult, (String)"$this$asCallResolutionResult");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        ConstraintStorage systemStorage = $this$asCallResolutionResult.getSystem().asReadOnlyStorage();
        List allDiagnostics = CollectionsKt.plus((Collection)diagnosticsHolder.getDiagnostics(), (Iterable)$this$asCallResolutionResult.getDiagnosticsFromResolutionParts());
        if (this.isErrorCandidate($this$asCallResolutionResult)) {
            return new ErrorCallResolutionResult($this$asCallResolutionResult.getResolvedCall(), allDiagnostics, systemStorage);
        }
        return type2 == KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL ? (SingleCallResolutionResult)new CompletedCallResolutionResult($this$asCallResolutionResult.getResolvedCall(), allDiagnostics, systemStorage) : (SingleCallResolutionResult)new PartialCallResolutionResult($this$asCallResolutionResult.getResolvedCall(), allDiagnostics, systemStorage);
    }

    private final boolean isErrorCandidate(@NotNull KotlinResolutionCandidate $this$isErrorCandidate) {
        return ErrorUtils.isError($this$isErrorCandidate.getResolvedCall().getCandidateDescriptor()) || ConstraintStorage.Empty.INSTANCE.getHasContradiction();
    }

    public KotlinCallCompleter(@NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter) {
        Intrinsics.checkParameterIsNotNull((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
    }

    public static final /* synthetic */ PostponedArgumentsAnalyzer access$getPostponedArgumentsAnalyzer$p(KotlinCallCompleter $this) {
        return $this.postponedArgumentsAnalyzer;
    }
}

