/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.checkers.ConstApplicability;
import org.jetbrains.kotlin.resolve.checkers.ConstModifierCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ConstModifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "canBeConst", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "constModifierPsiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "check", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkCanBeConst", "Lorg/jetbrains/kotlin/resolve/checkers/ConstApplicability;", "frontend"})
public final class ConstModifierChecker
implements DeclarationChecker {
    public static final ConstModifierChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(descriptor2 instanceof VariableDescriptor) || !declaration.hasModifier(KtTokens.CONST_KEYWORD)) {
            return;
        }
        KtModifierList ktModifierList = declaration.getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = ktModifierList.getModifier(KtTokens.CONST_KEYWORD);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"declaration.modifierList\u2026KtTokens.CONST_KEYWORD)!!");
        PsiElement constModifierPsiElement = psiElement;
        Diagnostic diagnostic = this.checkCanBeConst(declaration, constModifierPsiElement, (VariableDescriptor)descriptor2).getDiagnostic();
        if (diagnostic != null) {
            context.getTrace().report(diagnostic);
        }
    }

    public final boolean canBeConst(@NotNull KtDeclaration declaration, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)constModifierPsiElement, (String)"constModifierPsiElement");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return this.checkCanBeConst(declaration, constModifierPsiElement, descriptor2).getCanBeConst();
    }

    private final ConstApplicability checkCanBeConst(KtDeclaration declaration, PsiElement constModifierPsiElement, VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, "vars");
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.WRONG_MODIFIER_TA\u2026ns.CONST_KEYWORD, \"vars\")");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() != ClassKind.OBJECT) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement);
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"Errors.CONST_VAL_NOT_TOP\u2026(constModifierPsiElement)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (!(declaration instanceof KtProperty) || !(descriptor2 instanceof PropertyDescriptor)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        if (((KtProperty)declaration).hasDelegate()) {
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration).getDelegate();
            if (ktPropertyDelegate == null) {
                Intrinsics.throwNpe();
            }
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITH_DELEGATE.on(ktPropertyDelegate);
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"Errors.CONST_VAL_WITH_DE\u2026n(declaration.delegate!!)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KtPropertyAccessor getter2 = ((KtProperty)declaration).getGetter();
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"descriptor.getter!!");
        if (!propertyGetterDescriptor.isDefault() && getter2 != null) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITH_GETTER.on(getter2);
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"Errors.CONST_VAL_WITH_GETTER.on(getter)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.type");
        if (KotlinTypeKt.isError(kotlinType)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        KotlinType kotlinType2 = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
        if (!ConstUtilKt.canBeUsedForConstVal(kotlinType2)) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor2).getType());
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.TYPE_CANT_BE_USED\u2026Element, descriptor.type)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        if (((KtProperty)declaration).getInitializer() == null) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement);
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"Errors.CONST_VAL_WITHOUT\u2026(constModifierPsiElement)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null) {
            KtExpression ktExpression = ((KtProperty)declaration).getInitializer();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            SimpleDiagnostic<KtExpression> simpleDiagnostic = Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((KtExpression)((PsiElement)ktExpression));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"Errors.CONST_VAL_WITH_NO\u2026eclaration.initializer!!)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        return ConstApplicability.Applicable.INSTANCE;
    }

    private ConstModifierChecker() {
    }

    static {
        ConstModifierChecker constModifierChecker;
        INSTANCE = constModifierChecker = new ConstModifierChecker();
    }
}

