/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.utils.KotlinTypeBasedUtilsKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrArithBuilder;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering$WhenMappings;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "booleanMarker", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "byteMask", "", "calculator", "Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "eqeq", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "functionMarker", "instanceOfIntrinsicSymbol", "isArraySymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isInterfaceSymbol", "isObjectSymbol", "jsClassIntrinsicSymbol", "lit16", "lit24", "litNull", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "litTrue", "numberMarker", "shortMask", "stringMarker", "throwCCE", "throwNPE", "typeOfIntrinsicSymbol", "unit", "Lorg/jetbrains/kotlin/ir/types/IrType;", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
public final class TypeOperatorLowering
implements FileLoweringPass {
    private final IrType unit;
    private final IrGetObjectValueImpl unitValue;
    private final IrConstImpl<Integer> lit24;
    private final IrConstImpl<Integer> lit16;
    private final IrConstImpl<Integer> byteMask;
    private final IrConstImpl<Integer> shortMask;
    private final JsIrArithBuilder calculator;
    private final IrSimpleFunctionSymbol throwCCE;
    private final IrSimpleFunctionSymbol throwNPE;
    private final IrSimpleFunctionSymbol eqeq;
    private final IrSimpleFunctionSymbol instanceOfIntrinsicSymbol;
    private final IrSimpleFunctionSymbol typeOfIntrinsicSymbol;
    private final IrSimpleFunctionSymbol jsClassIntrinsicSymbol;
    private final IrConstImpl<String> stringMarker;
    private final IrConstImpl<String> booleanMarker;
    private final IrConstImpl<String> functionMarker;
    private final IrConstImpl<String> numberMarker;
    private final IrExpression litTrue;
    private final IrExpression litNull;
    @NotNull
    private final JsIrBackendContext context;

    private final IrSimpleFunctionSymbol isInterfaceSymbol() {
        return this.context.getIntrinsics().isInterfaceSymbol();
    }

    private final IrSimpleFunctionSymbol isArraySymbol() {
        return this.context.getIntrinsics().isArraySymbol();
    }

    private final IrSimpleFunctionSymbol isObjectSymbol() {
        return this.context.getIntrinsics().isObjectSymbol();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        irFile.transformChildren((IrElementTransformer)new IrElementTransformer<IrDeclarationParent>(this){
            final /* synthetic */ TypeOperatorLowering this$0;

            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, declaration);
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitClass(this, declaration, declaration);
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
                switch (TypeOperatorLowering$WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
                    case 1: {
                        irExpression = this.lowerImplicitCast(expression2);
                        break;
                    }
                    case 2: {
                        irExpression = this.lowerCoercionToUnit(expression2);
                        break;
                    }
                    case 3: {
                        irExpression = this.lowerIntegerCoercion(expression2, data);
                        break;
                    }
                    case 4: {
                        irExpression = this.lowerImplicitNotNull(expression2, data);
                        break;
                    }
                    case 5: {
                        irExpression = this.lowerInstanceOf(expression2, data, false);
                        break;
                    }
                    case 6: {
                        irExpression = this.lowerInstanceOf(expression2, data, true);
                        break;
                    }
                    case 7: {
                        irExpression = this.lowerCast(expression2, data, false);
                        break;
                    }
                    case 8: {
                        irExpression = this.lowerCast(expression2, data, true);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return irExpression;
            }

            private final IrExpression lowerImplicitNotNull(IrTypeOperatorCall expression2, IrDeclarationParent declaration) {
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_NOTNULL;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = IrTypeUtilsKt.isNullable(expression2.getTypeOperand()) ^ IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                List newStatements = new ArrayList<E>();
                IrExpression argument = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrCall irNullCheck = this.nullCheck(argument);
                Object object = newStatements;
                IrWhen irWhen = JsIrBuilder.INSTANCE.buildIfElse(expression2.getTypeOperand(), irNullCheck, JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowNPE$p(this.this$0), null, null, 6, null), argument);
                object.add(irWhen);
                Object $receiver = object = expression2;
                return new IrCompositeImpl($receiver.getStartOffset(), $receiver.getEndOffset(), $receiver.getTypeOperand(), null, newStatements);
            }

            private final IrExpression lowerCast(IrTypeOperatorCall expression2, IrDeclarationParent declaration, boolean isSafe) {
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.CAST || expression2.getOperator() == IrTypeOperator.SAFE_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                boolean bl3 = bl = expression2.getOperator() == IrTypeOperator.SAFE_CAST == isSafe;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrType toType = expression2.getTypeOperand();
                IrExpression failResult = isSafe ? TypeOperatorLowering.access$getLitNull$p(this.this$0) : (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowCCE$p(this.this$0), null, null, 6, null);
                List newStatements = new ArrayList<E>();
                IrExpression argument = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrExpression check2 = this.generateTypeCheck(argument, toType);
                Object object = newStatements;
                IrWhen irWhen = JsIrBuilder.INSTANCE.buildIfElse(toType, check2, argument, failResult);
                object.add(irWhen);
                Object $receiver = object = expression2;
                return new IrCompositeImpl($receiver.getStartOffset(), $receiver.getEndOffset(), toType, null, newStatements);
            }

            private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
                boolean bl;
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                IrTypeOperatorCall $receiver = irTypeOperatorCall;
                boolean bl2 = bl = $receiver.getOperator() == IrTypeOperator.IMPLICIT_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return $receiver.getArgument();
            }

            private final boolean advancedCheckRequired(IrType type2) {
                return IrTypeUtilsKt.isInterface(type2) || IrTypePredicatesKt.isArray(type2) || KotlinTypeBasedUtilsKt.isPrimitiveArray(type2) || this.isTypeOfCheckingType(type2);
            }

            private final boolean isTypeOfCheckingType(IrType type2) {
                return IrTypePredicatesKt.isByte(type2) || IrTypePredicatesKt.isShort(type2) || IrTypePredicatesKt.isInt(type2) || IrTypePredicatesKt.isFloat(type2) || IrTypePredicatesKt.isDouble(type2) || IrTypePredicatesKt.isNumber(type2) || IrTypePredicatesKt.isBoolean(type2) || IrTypeUtilsKt.isFunctionOrKFunction(type2) || IrTypePredicatesKt.isString(type2);
            }

            @NotNull
            public final IrExpression lowerInstanceOf(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent declaration, boolean inverted) {
                IrExpression irExpression;
                IrExpression result2;
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.INSTANCEOF || expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                boolean bl3 = bl = expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF == inverted;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrType toType = expression2.getTypeOperand();
                boolean isCopyRequired = IrTypeUtilsKt.isNullable(expression2.getArgument().getType()) && this.advancedCheckRequired(IrTypesKt.makeNotNull(toType));
                List newStatements = new ArrayList<E>();
                IrExpression argument = isCopyRequired ? this.cacheValue(expression2.getArgument(), newStatements, declaration) : expression2.getArgument();
                IrExpression check2 = this.generateTypeCheck(argument, toType);
                IrExpression irExpression2 = result2 = inverted ? TypeOperatorLowering.access$getCalculator$p(this.this$0).not(check2) : check2;
                if (isCopyRequired) {
                    Collection collection = newStatements;
                    collection.add(result2);
                    irExpression = new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), toType, null, newStatements);
                } else {
                    irExpression = result2;
                }
                return irExpression;
            }

            private final IrCall nullCheck(IrExpression value) {
                IrCall irCall;
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, value);
                $receiver.putValueArgument(1, TypeOperatorLowering.access$getLitNull$p(this.this$0));
                return irCall;
            }

            private final IrExpression cacheValue(IrExpression value, List<IrStatement> newStatements, IrDeclarationParent declaration) {
                IrVariable varDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, value.getType(), declaration, null, false, false, false, value, 60, null);
                Collection collection = newStatements;
                collection.add(varDeclaration);
                return JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)varDeclaration.getSymbol());
            }

            private final IrExpression generateTypeCheck(IrExpression argument, IrType toType) {
                IrExpression irExpression;
                boolean isNativeCheck;
                IrClassifierSymbol irClassifierSymbol;
                IrClassifierSymbol $receiver;
                IrClassifierSymbol irClassifierSymbol2 = IrTypesKt.getClassifierOrNull(toType);
                if (irClassifierSymbol2 != null && !($receiver = (irClassifierSymbol = irClassifierSymbol2)).isBound()) {
                    return argument;
                }
                IrType toNotNullable = IrTypesKt.makeNotNull(toType);
                IrExpression instanceCheck = this.generateTypeCheckNonNull(argument, toNotNullable);
                boolean isFromNullable = IrTypeUtilsKt.isNullable(argument.getType());
                boolean isToNullable = IrTypeUtilsKt.isNullable(toType);
                boolean bl = isNativeCheck = !this.advancedCheckRequired(toNotNullable);
                if (!isFromNullable) {
                    irExpression = instanceCheck;
                } else if (isToNullable) {
                    JsIrArithBuilder jsIrArithBuilder;
                    JsIrArithBuilder $receiver2 = jsIrArithBuilder = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    irExpression = $receiver2.oror(this.nullCheck(argument), instanceCheck);
                } else if (isNativeCheck) {
                    irExpression = instanceCheck;
                } else {
                    JsIrArithBuilder jsIrArithBuilder;
                    JsIrArithBuilder $receiver3 = jsIrArithBuilder = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    irExpression = $receiver3.andand($receiver3.not(this.nullCheck(argument)), instanceCheck);
                }
                return irExpression;
            }

            private final IrExpression generateTypeCheckNonNull(IrExpression argument, IrType toType) {
                boolean bl;
                boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable(toType);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return IrTypePredicatesKt.isAny(toType) ? (IrExpression)this.generateIsObjectCheck(argument) : (this.isTypeOfCheckingType(toType) ? this.generateTypeOfCheck(argument, toType) : (IrTypePredicatesKt.isArray(toType) ? (IrExpression)this.generateGenericArrayCheck(argument) : (KotlinTypeBasedUtilsKt.isPrimitiveArray(toType) ? this.generatePrimitiveArrayTypeCheck(argument, toType) : (IrTypeUtilsKt.isTypeParameter(toType) ? this.generateTypeCheckWithTypeParameter(argument, toType) : (IrTypeUtilsKt.isInterface(toType) ? this.generateInterfaceCheck(argument, toType) : this.generateNativeInstanceOf(argument, toType))))));
            }

            private final IrCall generateIsObjectCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isObjectSymbol$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, argument);
                return irCall;
            }

            /*
             * WARNING - void declaration
             */
            private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument, IrType toType) {
                void $receiver$iv;
                IrExpression initial$iv;
                boolean bl;
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
                if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) {
                    irClassifierSymbol = null;
                }
                IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)irClassifierSymbol;
                if (irTypeParameterSymbol == null) {
                    String string = "expected type parameter, but " + toType;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                IrTypeParameterSymbol typeParameterSymbol = irTypeParameterSymbol;
                if (!typeParameterSymbol.isBound()) {
                    return argument;
                }
                IrTypeParameter typeParameter = (IrTypeParameter)typeParameterSymbol.getOwner();
                boolean bl2 = bl = !typeParameter.isReified();
                if (_Assertions.ENABLED && !bl) {
                    String string = "reified parameters have to be lowered before";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Iterable iterable = typeParameter.getSuperTypes();
                IrExpression accumulator$iv = initial$iv = TypeOperatorLowering.access$getLitTrue$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    void t;
                    IrType irType = (IrType)element$iv;
                    IrExpression r = accumulator$iv;
                    IrExpression check2 = this.generateTypeCheckNonNull(argument, IrTypesKt.makeNotNull((IrType)t));
                    accumulator$iv = TypeOperatorLowering.access$getCalculator$p(this.this$0).and(r, check2);
                }
                return accumulator$iv;
            }

            private final IrExpression generateTypeOfCheck(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrConstImpl marker = IrTypeUtilsKt.isFunctionOrKFunction(toType) ? TypeOperatorLowering.access$getFunctionMarker$p(this.this$0) : (IrTypePredicatesKt.isBoolean(toType) ? TypeOperatorLowering.access$getBooleanMarker$p(this.this$0) : (IrTypePredicatesKt.isString(toType) ? TypeOperatorLowering.access$getStringMarker$p(this.this$0) : TypeOperatorLowering.access$getNumberMarker$p(this.this$0)));
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getTypeOfIntrinsicSymbol$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, argument);
                IrCall typeOf = irCall;
                $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, typeOf);
                $receiver.putValueArgument(1, marker);
                return irCall;
            }

            private final IrCall wrapTypeReference(IrType toType) {
                IrCall irCall;
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getJsClassIntrinsicSymbol$p(this.this$0), null, null, 6, null);
                $receiver.putTypeArgument(0, toType);
                return irCall;
            }

            private final IrCall generateGenericArrayCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isArraySymbol$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, argument);
                return irCall;
            }

            private final IrExpression generatePrimitiveArrayTypeCheck(IrExpression argument, IrType toType) {
                Object object = this.this$0.getContext().getIntrinsics().isPrimitiveArray();
                PrimitiveType primitiveType = KotlinTypeBasedUtilsKt.getPrimitiveArrayElementType(toType);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = object.get((Object)((Object)primitiveType));
                if (irSimpleFunctionSymbol == null) {
                    Intrinsics.throwNpe();
                }
                IrSimpleFunctionSymbol f = irSimpleFunctionSymbol;
                Object $receiver = object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, f, null, null, 6, null);
                $receiver.putValueArgument(0, argument);
                return (IrExpression)object;
            }

            private final IrExpression generateInterfaceCheck(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isInterfaceSymbol$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, argument);
                $receiver.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression generateNativeInstanceOf(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $receiver = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getInstanceOfIntrinsicSymbol$p(this.this$0), null, null, 6, null);
                $receiver.putValueArgument(0, argument);
                $receiver.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression lowerCoercionToUnit(IrTypeOperatorCall expression2) {
                IrTypeOperatorCall irTypeOperatorCall;
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IrTypeOperatorCall $receiver = irTypeOperatorCall = expression2;
                return new IrCompositeImpl($receiver.getStartOffset(), $receiver.getEndOffset(), TypeOperatorLowering.access$getUnit$p(this.this$0), null, CollectionsKt.listOf((Object[])new IrExpression[]{$receiver.getArgument(), TypeOperatorLowering.access$getUnitValue$p(this.this$0)}));
            }

            private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2, IrDeclarationParent declaration) {
                IrExpression irExpression;
                IrExpression argument;
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = IrTypePredicatesKt.isInt(expression2.getArgument().getType());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                boolean isNullable2 = IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                IrType toType = expression2.getTypeOperand();
                Function3<IrExpression, IrExpression, IrExpression, IrExpression> maskOp$ = new Function3<IrExpression, IrExpression, IrExpression, IrExpression>(this){
                    final /* synthetic */ lower.1 this$0;

                    @NotNull
                    public final IrExpression invoke(@NotNull IrExpression arg, @NotNull IrExpression mask, @NotNull IrExpression shift) {
                        JsIrArithBuilder jsIrArithBuilder;
                        Intrinsics.checkParameterIsNotNull((Object)arg, (String)"arg");
                        Intrinsics.checkParameterIsNotNull((Object)mask, (String)"mask");
                        Intrinsics.checkParameterIsNotNull((Object)shift, (String)"shift");
                        JsIrArithBuilder $receiver = jsIrArithBuilder = TypeOperatorLowering.access$getCalculator$p(this.this$0.this$0);
                        return $receiver.shr($receiver.shl($receiver.and(arg, mask), shift), shift);
                    }
                    {
                        this.this$0 = var1_1;
                        super(3);
                    }
                };
                List newStatements = new ArrayList<E>();
                IrExpression irExpression2 = argument = isNullable2 ? this.cacheValue(expression2.getArgument(), newStatements, declaration) : expression2.getArgument();
                if (IrTypePredicatesKt.isByte(toType)) {
                    irExpression = maskOp$.invoke(argument, (IrExpression)TypeOperatorLowering.access$getByteMask$p(this.this$0), (IrExpression)TypeOperatorLowering.access$getLit24$p(this.this$0));
                } else if (IrTypePredicatesKt.isShort(toType)) {
                    irExpression = maskOp$.invoke(argument, (IrExpression)TypeOperatorLowering.access$getShortMask$p(this.this$0), (IrExpression)TypeOperatorLowering.access$getLit16$p(this.this$0));
                } else {
                    if (IrTypePredicatesKt.isLong(toType)) {
                        String string = "Long coercion";
                        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                    }
                    String string = "Unreachable execution (coercion to non-Integer type";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                IrExpression casted = irExpression;
                Object object = newStatements;
                IrExpression irExpression3 = isNullable2 ? (IrExpression)JsIrBuilder.INSTANCE.buildIfElse(toType, this.nullCheck(argument), TypeOperatorLowering.access$getLitNull$p(this.this$0), casted) : casted;
                object.add(irExpression3);
                Object $receiver = object = expression2;
                return new IrCompositeImpl($receiver.getStartOffset(), $receiver.getEndOffset(), toType, null, newStatements);
            }
            {
                this.this$0 = $outer;
            }

            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
            }

            @NotNull
            public IrBody visitBlockBody(@NotNull IrBlockBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBlockBody(this, body, data);
            }

            @NotNull
            public IrBody visitBody(@NotNull IrBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBody(this, body, data);
            }

            @NotNull
            public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
            }

            @NotNull
            public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
            }

            @NotNull
            public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            @NotNull
            public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            }

            @NotNull
            public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            @NotNull
            public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
            }

            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
            }

            @NotNull
            public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
            }

            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
            }

            @NotNull
            public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
            }

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclaration declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            @NotNull
            public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            @NotNull
            public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
            }

            @NotNull
            public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
            }

            @NotNull
            public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            @NotNull
            public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            @NotNull
            public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            @NotNull
            public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            @NotNull
            public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
            }

            @NotNull
            public IrBody visitExpressionBody(@NotNull IrExpressionBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body, data);
            }

            @NotNull
            public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            @NotNull
            public IrStatement visitField(@NotNull IrField declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
            }

            @NotNull
            public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            @NotNull
            public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
            }

            @NotNull
            public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            @NotNull
            public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
            }

            @NotNull
            public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            @NotNull
            public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
            }

            @NotNull
            public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            @NotNull
            public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            @NotNull
            public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
            }

            @NotNull
            public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
            }

            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            @NotNull
            public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            @NotNull
            public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            @NotNull
            public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
            }

            @NotNull
            public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
            }

            @NotNull
            public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
            }

            @NotNull
            public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            @NotNull
            public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            @NotNull
            public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            @NotNull
            public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            @NotNull
            public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
            }

            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
            }

            @NotNull
            public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrDeclarationParent data) {
                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
            }
        }, irFile);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public TypeOperatorLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.unit = this.context.getIrBuiltIns().getUnitType();
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(this.unit);
        if (irClassifierSymbol == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        }
        this.unitValue = JsIrBuilder.INSTANCE.buildGetObjectValue(this.unit, (IrClassSymbol)irClassifierSymbol);
        this.lit24 = JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 24);
        this.lit16 = JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 16);
        this.byteMask = JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 255);
        this.shortMask = JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 65535);
        this.calculator = new JsIrArithBuilder(this.context);
        this.throwCCE = this.context.getIrBuiltIns().getThrowCceSymbol();
        this.throwNPE = this.context.getIrBuiltIns().getThrowNpeSymbol();
        this.eqeq = this.context.getIrBuiltIns().getEqeqSymbol();
        this.instanceOfIntrinsicSymbol = (IrSimpleFunctionSymbol)this.context.getIntrinsics().getJsInstanceOf().getSymbol();
        this.typeOfIntrinsicSymbol = (IrSimpleFunctionSymbol)this.context.getIntrinsics().getJsTypeOf().getSymbol();
        this.jsClassIntrinsicSymbol = this.context.getIntrinsics().getJsClass();
        this.stringMarker = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "string");
        this.booleanMarker = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "boolean");
        this.functionMarker = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "function");
        this.numberMarker = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "number");
        this.litTrue = JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true);
        this.litNull = JsIrBuilder.INSTANCE.buildNull(this.context.getIrBuiltIns().getNothingNType());
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$getThrowNPE$p(TypeOperatorLowering $this) {
        return $this.throwNPE;
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$getLitNull$p(TypeOperatorLowering $this) {
        return $this.litNull;
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$getThrowCCE$p(TypeOperatorLowering $this) {
        return $this.throwCCE;
    }

    @NotNull
    public static final /* synthetic */ JsIrArithBuilder access$getCalculator$p(TypeOperatorLowering $this) {
        return $this.calculator;
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$getEqeq$p(TypeOperatorLowering $this) {
        return $this.eqeq;
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$isObjectSymbol$p(TypeOperatorLowering $this) {
        return $this.isObjectSymbol();
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$getLitTrue$p(TypeOperatorLowering $this) {
        return $this.litTrue;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getFunctionMarker$p(TypeOperatorLowering $this) {
        return $this.functionMarker;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getBooleanMarker$p(TypeOperatorLowering $this) {
        return $this.booleanMarker;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getStringMarker$p(TypeOperatorLowering $this) {
        return $this.stringMarker;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getNumberMarker$p(TypeOperatorLowering $this) {
        return $this.numberMarker;
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$getTypeOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.typeOfIntrinsicSymbol;
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$getJsClassIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.jsClassIntrinsicSymbol;
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$isArraySymbol$p(TypeOperatorLowering $this) {
        return $this.isArraySymbol();
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$isInterfaceSymbol$p(TypeOperatorLowering $this) {
        return $this.isInterfaceSymbol();
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$getInstanceOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.instanceOfIntrinsicSymbol;
    }

    @NotNull
    public static final /* synthetic */ IrType access$getUnit$p(TypeOperatorLowering $this) {
        return $this.unit;
    }

    @NotNull
    public static final /* synthetic */ IrGetObjectValueImpl access$getUnitValue$p(TypeOperatorLowering $this) {
        return $this.unitValue;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getByteMask$p(TypeOperatorLowering $this) {
        return $this.byteMask;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getLit24$p(TypeOperatorLowering $this) {
        return $this.lit24;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getShortMask$p(TypeOperatorLowering $this) {
        return $this.shortMask;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getLit16$p(TypeOperatorLowering $this) {
        return $this.lit16;
    }
}

