/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.script;

import java.io.File;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.script.CliScriptDependenciesProviderKt;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProviderKt;
import org.jetbrains.kotlin.script.ScriptContentLoader;
import org.jetbrains.kotlin.script.ScriptContentLoaderKt;
import org.jetbrains.kotlin.script.ScriptDependenciesProvider;
import org.jetbrains.kotlin.script.ScriptReportSink;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R.\u0010\u0005\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/script/CliScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/script/ScriptDependenciesProvider;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/HashMap;", "", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "Lkotlin/collections/HashMap;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "scriptContentLoader", "Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "calculateExternalDependencies", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getScriptDependencies", "cli"})
public final class CliScriptDependenciesProvider
implements ScriptDependenciesProvider {
    private final ReentrantReadWriteLock cacheLock;
    private final HashMap<String, ScriptDependencies> cache;
    private final ScriptContentLoader scriptContentLoader;
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ScriptDependencies getScriptDependencies(@NotNull VirtualFile file2) {
        ScriptDependencies scriptDependencies;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            scriptDependencies = this.calculateExternalDependencies(file2);
        }
        finally {
            readLock.unlock();
        }
        return scriptDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScriptDependencies calculateExternalDependencies(VirtualFile file2) {
        ScriptDependencies scriptDependencies;
        String path2 = file2.getPath();
        ScriptDependencies cached = this.cache.get(path2);
        if (cached != null) {
            scriptDependencies = cached;
        } else {
            KotlinScriptDefinition scriptDef = KotlinScriptDefinitionProviderKt.findScriptDefinition(file2, this.project);
            if (scriptDef != null) {
                int n;
                ScriptDependencies deps;
                DependenciesResolver.ResolveResult result2 = this.scriptContentLoader.loadContentsAndResolveDependencies(scriptDef, file2);
                ScriptReportSink scriptReportSink = ServiceManager.getService(this.project, ScriptReportSink.class);
                if (scriptReportSink != null) {
                    scriptReportSink.attachReports(file2, result2.getReports());
                }
                ScriptDependencies scriptDependencies2 = result2.getDependencies();
                Object object = deps = scriptDependencies2 != null ? ScriptContentLoaderKt.adjustByDefinition(scriptDependencies2, scriptDef) : null;
                if (deps != null) {
                    Logger logger = CliScriptDependenciesProviderKt.access$getLog$p();
                    StringBuilder stringBuilder = new StringBuilder().append("[kts] new cached deps for ").append(path2).append(": ");
                    Iterable iterable = deps.getClasspath();
                    String string = File.pathSeparator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
                    logger.info(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
                }
                ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                int n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    n = n3++;
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    ScriptDependencies scriptDependencies3 = this.cache.put(path2, deps);
                }
                finally {
                    n = 0;
                    int n5 = n2;
                    while (n < n5) {
                        int n6 = n++;
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                scriptDependencies = deps;
            } else {
                scriptDependencies = null;
            }
        }
        return scriptDependencies;
    }

    public CliScriptDependenciesProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.cacheLock = new ReentrantReadWriteLock();
        CliScriptDependenciesProvider cliScriptDependenciesProvider = this;
        HashMap hashMap = new HashMap();
        cliScriptDependenciesProvider.cache = hashMap;
        this.scriptContentLoader = new ScriptContentLoader(this.project);
    }

    @Override
    @Nullable
    public ScriptDependencies getScriptDependencies(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ScriptDependenciesProvider.DefaultImpls.getScriptDependencies(this, file2);
    }
}

