/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.util.containers.OpenTHashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.StringInterner;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.CDATA;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.ImmutableCDATA;
import org.jetbrains.kotlin.org.jdom.ImmutableElement;
import org.jetbrains.kotlin.org.jdom.ImmutableSameTypeAttributeList;
import org.jetbrains.kotlin.org.jdom.ImmutableText;
import org.jetbrains.kotlin.org.jdom.Text;

public class JDOMInterner {
    private final StringInterner myStrings = new StringInterner();
    private final OpenTHashSet<Element> myElements = new OpenTHashSet<Element>(new TObjectHashingStrategy<Element>(){

        @Override
        public int computeHashCode(Element e) {
            int result2 = e.getName().hashCode() * 31;
            result2 += JDOMInterner.computeAttributesHashCode(e);
            List<Content> content = e.getContent();
            result2 = result2 * 31 + content.size();
            for (Content child : content) {
                if (child instanceof Text) {
                    result2 = result2 * 31 + JDOMInterner.computeTextHashCode((Text)child);
                    continue;
                }
                if (!(child instanceof Element)) continue;
                result2 = result2 * 31 + this.computeHashCode((Element)child);
                break;
            }
            return result2;
        }

        @Override
        public boolean equals(Element o1, Element o2) {
            if (!Comparing.strEqual(o1.getName(), o2.getName())) {
                return false;
            }
            if (!JDOMInterner.attributesEqual(o1, o2)) {
                return false;
            }
            List<Content> content1 = o1.getContent();
            List<Content> content2 = o2.getContent();
            if (content1.size() != content2.size()) {
                return false;
            }
            for (int i = 0; i < content1.size(); ++i) {
                Content c1 = content1.get(i);
                Content c2 = content2.get(i);
                if (c1 instanceof Text) {
                    if (!(c2 instanceof Text)) {
                        return false;
                    }
                    if (Comparing.strEqual(c1.getValue(), c2.getValue())) continue;
                    return false;
                }
                if (c1 instanceof Element) {
                    if (!(c2 instanceof Element)) {
                        return false;
                    }
                    if (this.equals((Element)c1, (Element)c2)) continue;
                    return false;
                }
                throw new RuntimeException(c1.toString());
            }
            return true;
        }
    });
    private final OpenTHashSet<Text> myTexts = new OpenTHashSet<Text>(new TObjectHashingStrategy<Text>(){

        @Override
        public int computeHashCode(Text object) {
            return JDOMInterner.computeTextHashCode(object);
        }

        @Override
        public boolean equals(Text o1, Text o2) {
            return Comparing.strEqual(o1.getValue(), o2.getValue());
        }
    });

    private static int computeAttributesHashCode(Element e) {
        List<Attribute> attributes = e.getAttributes();
        if (attributes instanceof ImmutableSameTypeAttributeList) {
            return attributes.hashCode();
        }
        int result2 = 1;
        for (Attribute attribute : attributes) {
            result2 = result2 * 31 + JDOMInterner.computeAttributeHashCode(attribute.getName(), attribute.getValue());
        }
        return result2;
    }

    private static boolean attributesEqual(Element o1, Element o2) {
        if (o1 instanceof ImmutableElement) {
            return ((ImmutableElement)o1).attributesEqual(o2);
        }
        if (o2 instanceof ImmutableElement) {
            return ((ImmutableElement)o2).attributesEqual(o1);
        }
        List<Attribute> a1 = o1.getAttributes();
        List<Attribute> a2 = o2.getAttributes();
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            Attribute attr2;
            Attribute attr1 = a1.get(i);
            if (ImmutableElement.attributesEqual(attr1, attr2 = a2.get(i))) continue;
            return false;
        }
        return true;
    }

    static int computeAttributeHashCode(String name, String value) {
        return name.hashCode() * 31 + (value == null ? 0 : value.hashCode());
    }

    private static int computeTextHashCode(Text object) {
        return object.getValue().hashCode();
    }

    @NotNull
    public synchronized Element internElement(@NotNull Element element) {
        if (element == null) {
            JDOMInterner.$$$reportNull$$$0(0);
        }
        if (element instanceof ImmutableElement) {
            Element element2 = element;
            if (element2 == null) {
                JDOMInterner.$$$reportNull$$$0(1);
            }
            return element2;
        }
        Element interned = this.myElements.get(element);
        if (interned == null) {
            interned = new ImmutableElement(element, this);
            this.myElements.add(interned);
        }
        Element element3 = interned;
        if (element3 == null) {
            JDOMInterner.$$$reportNull$$$0(2);
        }
        return element3;
    }

    @NotNull
    synchronized Text internText(@NotNull Text text2) {
        if (text2 == null) {
            JDOMInterner.$$$reportNull$$$0(4);
        }
        if (text2 instanceof ImmutableText || text2 instanceof ImmutableCDATA) {
            Text text3 = text2;
            if (text3 == null) {
                JDOMInterner.$$$reportNull$$$0(5);
            }
            return text3;
        }
        Text interned = this.myTexts.get(text2);
        if (interned == null) {
            interned = text2 instanceof CDATA ? new ImmutableCDATA(text2.getText()) : new ImmutableText(this.myStrings.intern(text2.getText()));
            this.myTexts.add(interned);
        }
        Text text4 = interned;
        if (text4 == null) {
            JDOMInterner.$$$reportNull$$$0(6);
        }
        return text4;
    }

    synchronized String internString(String s) {
        return this.myStrings.intern(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/org/jdom/JDOMInterner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/org/jdom/JDOMInterner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "internText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInterned";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "internText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

