/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt$shouldNotBeVisibleAsLightClass$;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\u0004*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\u0004*\u00020\u0001\u00a8\u0006\r"}, d2={"getOutermostClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classOrObject", "hasParseErrorsAround", "", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isEnumEntryWithoutBody", "defaultJavaAncestorQualifiedName", "", "isPossiblyAffectedByAllOpen", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForSourceDeclaration;", "shouldNotBeVisibleAsLightClass", "light-classes"})
public final class KtLightClassForSourceDeclarationKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPossiblyAffectedByAllOpen(@NotNull KtLightClassForSourceDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isAnnotationType()) return false;
        if ($receiver.isInterface()) return false;
        List<KtAnnotationEntry> list2 = $receiver.getKotlinOrigin().getAnnotationEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"kotlinOrigin.annotationEntries");
        Collection collection = list2;
        if (collection.isEmpty()) return false;
        return true;
    }

    @NotNull
    public static final KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        KtClassOrObject outermostClass;
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        KtClassOrObject ktClassOrObject = KtPsiUtil.getOutermostClassOrObject(classOrObject);
        if (ktClassOrObject == null) {
            throw (Throwable)new IllegalStateException("Attempt to build a light class for a local class: " + classOrObject.getText());
        }
        KtClassOrObject ktClassOrObject2 = outermostClass = ktClassOrObject;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject2, (String)"outermostClass");
        return ktClassOrObject2;
    }

    @Nullable
    public static final String defaultJavaAncestorQualifiedName(@NotNull KtClassOrObject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof KtClass)) {
            return "java.lang.Object";
        }
        return $receiver.isAnnotation() ? "java.lang.annotation.Annotation" : (((KtClass)$receiver).isEnum() ? "java.lang.Enum" : (((KtClass)$receiver).isInterface() ? "java.lang.Object" : "java.lang.Object"));
    }

    public static final boolean shouldNotBeVisibleAsLightClass(@NotNull KtClassOrObject $receiver) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Sequence $receiver$iv = PsiUtilsKt.getParentsWithSelf($receiver);
            Sequence sequence2 = SequencesKt.filter($receiver$iv, (Function1)shouldNotBeVisibleAsLightClass$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $receiver$iv = sequence2;
            for (Object element$iv : $receiver$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                if (!PsiUtilsKt.hasExpectModifier(it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if ($receiver.isLocal()) {
            PsiFile psiFile = $receiver.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
            if (psiFile.getVirtualFile() == null) {
                return true;
            }
            if (KtLightClassForSourceDeclarationKt.hasParseErrorsAround($receiver) || PsiUtilCore.hasErrorElementChild($receiver)) {
                return true;
            }
        }
        return KtLightClassForSourceDeclarationKt.isEnumEntryWithoutBody($receiver);
    }

    private static final boolean isEnumEntryWithoutBody(KtClassOrObject classOrObject) {
        if (!(classOrObject instanceof KtEnumEntry)) {
            return false;
        }
        Object object = classOrObject.getBody();
        return object != null && (object = ((KtClassBody)object).getDeclarations()) != null ? object.isEmpty() : true;
    }

    private static final boolean hasParseErrorsAround(PsiElement psi) {
        block9: {
            block10: {
                ASTNode prevLeaf;
                ASTNode aSTNode;
                ASTNode node;
                block7: {
                    block8: {
                        ASTNode nextLeaf;
                        ASTNode aSTNode2 = psi.getNode();
                        if (aSTNode2 == null) {
                            return false;
                        }
                        node = aSTNode2;
                        ASTNode aSTNode3 = TreeUtil.nextLeaf(node);
                        if (aSTNode3 == null) break block7;
                        ASTNode aSTNode4 = nextLeaf = (aSTNode = aSTNode3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode4, (String)"nextLeaf");
                        if (Intrinsics.areEqual((Object)aSTNode4.getElementType(), (Object)TokenType.ERROR_ELEMENT)) break block8;
                        ASTNode aSTNode5 = nextLeaf.getTreePrev();
                        if (!Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getElementType() : null), (Object)TokenType.ERROR_ELEMENT)) break block7;
                    }
                    return true;
                }
                ASTNode aSTNode6 = TreeUtil.prevLeaf(node);
                if (aSTNode6 == null) break block9;
                ASTNode aSTNode7 = prevLeaf = (aSTNode = aSTNode6);
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode7, (String)"prevLeaf");
                if (Intrinsics.areEqual((Object)aSTNode7.getElementType(), (Object)TokenType.ERROR_ELEMENT)) break block10;
                ASTNode aSTNode8 = prevLeaf.getTreeNext();
                if (!Intrinsics.areEqual((Object)(aSTNode8 != null ? aSTNode8.getElementType() : null), (Object)TokenType.ERROR_ELEMENT)) break block9;
            }
            return true;
        }
        return false;
    }
}

