/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PackageScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

abstract class KtNamedDeclarationStub<T extends KotlinStubWithFqName<?>>
extends KtDeclarationStub<T>
implements KtNamedDeclaration {
    private static final Set<String> FUNCTIONLIKE_CONVENTIONS = ImmutableSet.of(OperatorNameConventions.INVOKE.asString(), OperatorNameConventions.GET.asString());

    public KtNamedDeclarationStub(@NotNull T stub2, @NotNull IStubElementType nodeType) {
        super(stub2, nodeType);
    }

    public KtNamedDeclarationStub(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String getName() {
        KotlinStubWithFqName stub2 = (KotlinStubWithFqName)this.getStub();
        if (stub2 != null) {
            return stub2.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text2 = identifier.getText();
            return text2 != null ? KtPsiUtil.unquoteIdentifier(text2) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name = this.getName();
        return name != null ? Name.identifier(name) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        return KtPsiUtil.safeName(this.getName());
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findChildByType(KtTokens.IDENTIFIER);
    }

    private static boolean shouldDropOperatorKeyword(String oldName, String newName2) {
        return !OperatorConventions.isConventionName(Name.identifier(newName2)) || FUNCTIONLIKE_CONVENTIONS.contains(oldName) != FUNCTIONLIKE_CONVENTIONS.contains(newName2);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement newIdentifier;
        PsiElement identifier = this.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.OPERATOR_KEYWORD) && KtNamedDeclarationStub.shouldDropOperatorKeyword(this.getName(), name)) {
            this.removeModifier(KtTokens.OPERATOR_KEYWORD);
        }
        if ((newIdentifier = KtPsiFactoryKt.KtPsiFactory(this).createNameIdentifierIfPossible(KtPsiUtilKt.quoteIfNeeded(name))) != null) {
            KtPsiUtilKt.astReplace(identifier, newIdentifier);
        } else {
            identifier.delete();
        }
        return this;
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement grandParent;
        KtElement enclosingBlock = KtPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            KtExpression condition;
            PsiElement enclosingParent = enclosingBlock.getParent();
            if (enclosingParent instanceof KtContainerNode) {
                enclosingParent = enclosingParent.getParent();
            }
            if (enclosingBlock instanceof KtBlockExpression && enclosingParent instanceof KtDoWhileExpression && (condition = ((KtDoWhileExpression)enclosingParent).getCondition()) != null) {
                return new LocalSearchScope(new PsiElement[]{enclosingBlock, condition});
            }
            return new LocalSearchScope(enclosingBlock);
        }
        PsiElement parent2 = this.getParent();
        PsiElement psiElement = grandParent = parent2 != null ? parent2.getParent() : null;
        if (parent2 instanceof KtBlockExpression && grandParent instanceof KtScript) {
            return new LocalSearchScope(this.getContainingFile());
        }
        if (this.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            KtElement companionObjectClass;
            KtElement containingClass = PsiTreeUtil.getParentOfType((PsiElement)this, KtClassOrObject.class);
            if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && (companionObjectClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)containingClass, KtClassOrObject.class)) != null) {
                containingClass = companionObjectClass;
            }
            if (containingClass != null) {
                return new LocalSearchScope(containingClass);
            }
            KtFile ktFile = this.getContainingKtFile();
            if (this instanceof KtClassOrObject) {
                Project project = this.getProject();
                GlobalSearchScope kotlinFilesScope = GlobalSearchScope.getScopeRestrictedByFileTypes(GlobalSearchScope.allScope(project), KotlinFileType.INSTANCE);
                PsiPackage psiPackage = JavaPsiFacade.getInstance(project).findPackage(ktFile.getPackageFqName().asString());
                SearchScope baseScope = psiPackage != null ? new PackageScope(psiPackage, false, true) : super.getUseScope();
                baseScope.intersectWith(GlobalSearchScope.notScope(kotlinFilesScope));
            } else {
                return new LocalSearchScope(ktFile);
            }
        }
        SearchScope scope = super.getUseScope();
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        if (classOrObject != null) {
            scope = scope.intersectWith(classOrObject.getUseScope());
        }
        return scope;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub2 = (KotlinStubWithFqName)this.getStub();
        if (stub2 != null) {
            return stub2.getFqName();
        }
        return KtNamedDeclarationUtil.getFQName(this);
    }
}

