/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/NameReplacingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "replaceMap", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Ljava/util/Map;)V", "applyToNamedNode", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/HasName;", "endVisit", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "js.translator"})
public final class NameReplacingVisitor
extends JsVisitorWithContextImpl {
    private final Map<JsName, JsExpression> replaceMap;

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        if (x.getQualifier() != null) {
            return;
        }
        Map<JsName, JsExpression> map2 = this.replaceMap;
        JsName jsName = x.getName();
        JsExpression jsExpression = map2.get(jsName);
        if (jsExpression == null) {
            return;
        }
        JsExpression replacement = jsExpression;
        if (replacement instanceof JsNameRef) {
            this.applyToNamedNode(x);
        } else {
            JsExpression replacementCopy = replacement.deepCopy();
            if (x.getSource() != null) {
                JsExpression jsExpression2 = replacementCopy;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"replacementCopy");
                jsExpression2.setSource(x.getSource());
            }
            ctx.replaceMe(this.accept((JsNode)replacementCopy));
        }
    }

    public void endVisit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    public void endVisit(@NotNull JsParameter x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
        this.applyToNamedNode(x);
    }

    private final void applyToNamedNode(HasName x) {
        JsExpression replacement;
        while ((replacement = this.replaceMap.get(x.getName())) instanceof HasName) {
            x.setName(((HasName)((Object)replacement)).getName());
        }
    }

    public NameReplacingVisitor(@NotNull Map<JsName, ? extends JsExpression> replaceMap) {
        Intrinsics.checkParameterIsNotNull(replaceMap, (String)"replaceMap");
        this.replaceMap = replaceMap;
    }
}

