/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001e\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010%\u001a\u00020\"H\u0002J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001a\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010\"H\u0002J.\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\"2\b\u0010-\u001a\u0004\u0018\u00010\"2\b\u0010.\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0002J$\u00104\u001a\u0004\u0018\u00010\u00102\b\u00105\u001a\u0004\u0018\u00010\u000b2\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"H\u0002J\u0010\u00108\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J$\u00109\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100!\u0018\u00010:2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020GH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/js/dce/Analyzer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "(Lorg/jetbrains/kotlin/js/dce/Context;)V", "analysisResult", "Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "astNodesToEliminate", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "astNodesToSkip", "functionsToEnter", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionsToSkip", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "invocationsToSkip", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleMapping", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "", "getModuleMapping", "()Ljava/util/Map;", "nodeMap", "postponedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "processedFunctions", "enterFunction", "", "function", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "enterFunctionWithGivenNodes", "extractVariableInitializedByEmptyObject", "expression", "handleAmdDefine", "invocation", "handleObjectCreate", "target", "arg", "handleObjectDefineProperty", "statement", "propertyName", "propertyDescriptor", "isProperFunctionalParameter", "", "body", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "processAssignment", "node", "lhs", "rhs", "processFunction", "tryExtractFunction", "Lkotlin/Pair;", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "js.dce"})
public final class Analyzer
extends JsVisitor {
    private final Set<JsFunction> processedFunctions;
    private final Map<JsName, JsFunction> postponedFunctions;
    private final Map<JsNode, Context.Node> nodeMap;
    private final Set<JsNode> astNodesToEliminate;
    private final Set<JsNode> astNodesToSkip;
    private final Set<JsInvocation> invocationsToSkip;
    @NotNull
    private final Map<JsStatement, String> moduleMapping;
    private final Set<JsFunction> functionsToEnter;
    private final Set<Context.Node> functionsToSkip;
    @NotNull
    private final AnalysisResult analysisResult;
    private final Context context;

    @NotNull
    public final Map<JsStatement, String> getModuleMapping() {
        return this.moduleMapping;
    }

    @NotNull
    public final AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        List<JsVars.JsVar> list2 = x.getVars();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.vars");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            JsExpression rhs = x.getInitExpression();
            if (rhs == null) break block1;
            JsNode jsNode = x;
            JsNameRef jsNameRef = x.getName().makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"x.name.makeRef()");
            Context.Node node = this.processAssignment(jsNode, jsNameRef, rhs);
            if (node != null) {
                Context.Node node2;
                Context.Node it = node2 = node;
                Map<JsNode, Context.Node> map2 = this.nodeMap;
                JsVars.JsVar jsVar = x;
                Context.Node node3 = it;
                map2.put(jsVar, node3);
            }
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        JsExpression expression2;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        JsExpression jsExpression = expression2 = x.getExpression();
        if (jsExpression instanceof JsBinaryOperation) {
            JsExpression jsExpression2 = expression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"expression");
            if (((JsBinaryOperation)jsExpression2).getOperator() == JsBinaryOperator.ASG) {
                JsNode jsNode = x;
                JsExpression jsExpression3 = ((JsBinaryOperation)expression2).getArg1();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"expression.arg1");
                JsExpression jsExpression4 = ((JsBinaryOperation)expression2).getArg2();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression4, (String)"expression.arg2");
                Context.Node node = this.processAssignment(jsNode, jsExpression3, jsExpression4);
                if (node != null) {
                    Context.Node node2;
                    Context.Node it = node2 = node;
                    Map<JsNode, Context.Node> map2 = this.nodeMap;
                    JsExpressionStatement jsExpressionStatement = x;
                    Context.Node node3 = it;
                    map2.put(jsExpressionStatement, node3);
                }
            }
        } else if (jsExpression instanceof JsFunction) {
            JsExpression jsExpression5 = expression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression5, (String)"expression");
            Object object = ((JsFunction)jsExpression5).getName();
            if (object != null) {
                Object object2;
                Object it = object2 = object;
                Context.Node node = this.context.getNodes().get(it);
                object = node != null ? node.getOriginal() : null;
                if (object != null) {
                    it = object2 = object;
                    Object object3 = this.nodeMap;
                    AbstractNode abstractNode = x;
                    Object object4 = it;
                    object3.put((JsNode)abstractNode, (Context.Node)object4);
                    object3 = ((Context.Node)it).getFunctions();
                    abstractNode = expression2;
                    object3.add(abstractNode);
                }
            }
        } else if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression6 = expression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression6, (String)"expression");
            JsExpression function2 = ((JsInvocation)jsExpression6).getQualifier();
            if (function2 instanceof JsFunction) {
                JsFunction jsFunction = (JsFunction)function2;
                List<JsExpression> list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.arguments");
                this.enterFunction(jsFunction, list2);
                return;
            }
            if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null) {
                JsFunction postponedFunction;
                JsFunction jsFunction;
                Object object;
                JsName jsName = ((JsNameRef)function2).getName();
                if (jsName != null) {
                    object = jsName;
                    JsName it = object;
                    jsFunction = this.postponedFunctions.get(it);
                } else {
                    jsFunction = postponedFunction = null;
                }
                if (postponedFunction != null) {
                    List<JsExpression> list3 = ((JsInvocation)expression2).getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"expression.arguments");
                    this.enterFunction(postponedFunction, list3);
                    object = this.invocationsToSkip;
                    JsExpression jsExpression7 = expression2;
                    object.add(jsExpression7);
                    return;
                }
            }
            JsExpression jsExpression8 = function2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression8, (String)"function");
            if (UtilKt.isObjectDefineProperty(this.context, jsExpression8)) {
                JsStatement jsStatement = x;
                List<JsExpression> list4 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"expression.arguments");
                JsExpression jsExpression9 = (JsExpression)CollectionsKt.getOrNull(list4, (int)0);
                List<JsExpression> list5 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list5, (String)"expression.arguments");
                JsExpression jsExpression10 = (JsExpression)CollectionsKt.getOrNull(list5, (int)1);
                List<JsExpression> list6 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list6, (String)"expression.arguments");
                this.handleObjectDefineProperty(jsStatement, jsExpression9, jsExpression10, (JsExpression)CollectionsKt.getOrNull(list6, (int)2));
            } else if (UtilKt.isDefineModule(this.context, function2)) {
                Collection collection = this.astNodesToEliminate;
                collection.add(x);
            } else if (UtilKt.isAmdDefine(this.context, function2)) {
                JsInvocation jsInvocation = (JsInvocation)expression2;
                List<JsExpression> list7 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list7, (String)"expression.arguments");
                this.handleAmdDefine(jsInvocation, list7);
            }
        }
    }

    private final void handleObjectDefineProperty(JsStatement statement2, JsExpression target, JsExpression propertyName, JsExpression propertyDescriptor) {
        if (target == null || !(propertyName instanceof JsStringLiteral) || propertyDescriptor == null) {
            return;
        }
        Context.Node node = this.context.extractNode(target);
        if (node == null) {
            return;
        }
        Context.Node targetNode = node;
        String string = ((JsStringLiteral)propertyName).getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"propertyName.value");
        Context.Node memberNode = targetNode.member(string);
        Map<JsNode, Context.Node> map2 = this.nodeMap;
        Context.Node node2 = memberNode;
        map2.put(statement2, node2);
        memberNode.setHasSideEffects(true);
        if (propertyDescriptor instanceof JsObjectLiteral) {
            for (JsPropertyInitializer initializer2 : ((JsObjectLiteral)propertyDescriptor).getPropertyInitializers()) {
                JsNode jsNode = statement2;
                JsExpression jsExpression = new JsNameRef(((JsStringLiteral)propertyName).getValue(), target);
                JsPropertyInitializer jsPropertyInitializer = initializer2;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"initializer");
                JsExpression jsExpression2 = jsPropertyInitializer.getValueExpr();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"initializer.valueExpr");
                this.processAssignment(jsNode, jsExpression, jsExpression2);
            }
        } else if (propertyDescriptor instanceof JsInvocation) {
            JsExpression function2;
            JsExpression jsExpression = function2 = ((JsInvocation)propertyDescriptor).getQualifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"function");
            if (UtilKt.isObjectGetOwnPropertyDescriptor(this.context, jsExpression)) {
                List<JsExpression> list2 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"propertyDescriptor.arguments");
                JsExpression source = (JsExpression)CollectionsKt.getOrNull(list2, (int)0);
                List<JsExpression> list3 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"propertyDescriptor.arguments");
                JsExpression sourcePropertyName = (JsExpression)CollectionsKt.getOrNull(list3, (int)1);
                if (source != null && sourcePropertyName instanceof JsStringLiteral) {
                    this.processAssignment(statement2, new JsNameRef(((JsStringLiteral)propertyName).getValue(), target), new JsNameRef(((JsStringLiteral)sourcePropertyName).getValue(), source));
                }
            }
        }
    }

    private final void handleAmdDefine(JsInvocation invocation, List<? extends JsExpression> arguments2) {
        Context.Node node;
        JsStringLiteral it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        HasMetadata hasMetadata;
        Map<JsName, JsFunction> map2;
        JsFunction jsFunction;
        JsExpression functionRef;
        List list2;
        switch (arguments2.size()) {
            case 2: {
                list2 = arguments2;
                break;
            }
            case 3: {
                list2 = CollectionsKt.drop((Iterable)arguments2, (int)1);
                break;
            }
            default: {
                return;
            }
        }
        List argumentsWithoutName = list2;
        Object e = argumentsWithoutName.get(0);
        if (!(e instanceof JsArrayLiteral)) {
            e = null;
        }
        JsArrayLiteral jsArrayLiteral = (JsArrayLiteral)e;
        if (jsArrayLiteral == null) {
            return;
        }
        JsArrayLiteral dependencies2 = jsArrayLiteral;
        JsExpression jsExpression = functionRef = (JsExpression)argumentsWithoutName.get(1);
        if (jsExpression instanceof JsFunction) {
            jsFunction = (JsFunction)functionRef;
        } else if (jsExpression instanceof JsNameRef) {
            if (((JsNameRef)functionRef).getQualifier() != null) {
                return;
            }
            map2 = this.postponedFunctions;
            hasMetadata = ((JsNameRef)functionRef).getName();
            jsFunction = (JsFunction)map2.get(hasMetadata);
            if (jsFunction == null) {
                return;
            }
        } else {
            return;
        }
        JsFunction function2 = jsFunction;
        List<JsExpression> list3 = dependencies2.getExpressions();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"dependencies.expressions");
        map2 = list3;
        hasMetadata = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsExpression jsExpression2 = (JsExpression)item$iv$iv;
            collection = destination$iv$iv;
            JsStringLiteral jsStringLiteral = it;
            if (!(jsStringLiteral instanceof JsStringLiteral)) {
                jsStringLiteral = null;
            }
            if ((JsStringLiteral)jsStringLiteral == null) {
                return;
            }
            collection.add(node);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Context.Node node2;
            it = (JsStringLiteral)item$iv$iv;
            collection = destination$iv$iv;
            if (Intrinsics.areEqual((Object)it.getValue(), (Object)"exports")) {
                node2 = this.context.getCurrentModule();
            } else {
                Context.Node node3 = this.context.getGlobalScope();
                String string = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.value");
                node2 = node3.member(string);
            }
            node = node2;
            collection.add(node);
        }
        List dependencyNodes = (List)destination$iv$iv;
        this.enterFunctionWithGivenNodes(function2, dependencyNodes);
        map2 = this.astNodesToSkip;
        hasMetadata = invocation.getQualifier();
        map2.add(hasMetadata);
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        String newModule = this.moduleMapping.get(x);
        if (newModule != null) {
            this.context.setCurrentModule(this.context.getGlobalScope().member(newModule));
        }
        List<JsStatement> list2 = x.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.statements");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            JsStatement it = (JsStatement)element$iv;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            this.accept((JsNode)x.getThenStatement());
            JsStatement jsStatement = x.getElseStatement();
            if (jsStatement == null) break block0;
            jsStatement.accept(this);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            JsExpression expr = x.getExpression();
            if (expr == null) break block1;
            Context.Node node = this.context.extractNode(expr);
            if (node != null) {
                Context.Node node2;
                Context.Node it = node2 = node;
                Map<JsNode, Context.Node> map2 = this.nodeMap;
                JsReturn jsReturn = x;
                Context.Node node3 = it;
                map2.put(jsReturn, node3);
            }
        }
    }

    private final Context.Node processAssignment(JsNode node, JsExpression lhs, JsExpression rhs) {
        Context.Node leftNode = this.context.extractNode(lhs);
        Context.Node rightNode = this.context.extractNode(rhs);
        if (leftNode != null && rightNode != null) {
            leftNode.alias(rightNode);
            return leftNode;
        }
        if (leftNode != null) {
            Pair<JsFunction, List<Context.Node>> pair;
            if (rhs instanceof JsInvocation) {
                Pair<JsFunction, List<Context.Node>> it;
                HasMetadata hasMetadata;
                JsExpression function2 = ((JsInvocation)rhs).getQualifier();
                if (function2 instanceof JsFunction) {
                    JsFunction jsFunction = (JsFunction)function2;
                    List<JsExpression> list2 = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"rhs.arguments");
                    this.enterFunction(jsFunction, list2);
                    Collection collection = this.astNodesToSkip;
                    collection.add(lhs);
                    return null;
                }
                if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null && (hasMetadata = ((JsNameRef)function2).getName()) != null && (hasMetadata = this.postponedFunctions.get(it = (pair = hasMetadata))) != null) {
                    it = pair = hasMetadata;
                    List<JsExpression> list3 = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"rhs.arguments");
                    this.enterFunction((JsFunction)it, (List<? extends JsExpression>)list3);
                    Collection $i$a$1$let = this.astNodesToSkip;
                    JsExpression jsExpression = lhs;
                    $i$a$1$let.add(jsExpression);
                    return null;
                }
                JsExpression jsExpression = function2;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"function");
                if (UtilKt.isObjectFunction(this.context, jsExpression, "create")) {
                    List<JsExpression> list4 = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list4, (String)"rhs.arguments");
                    this.handleObjectCreate(leftNode, (JsExpression)CollectionsKt.getOrNull(list4, (int)0));
                    return leftNode;
                }
                if (UtilKt.isDefineInlineFunction(this.context, function2) && ((JsInvocation)rhs).getArguments().size() == 2) {
                    JsExpression jsExpression2 = ((JsInvocation)rhs).getArguments().get(1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"rhs.arguments[1]");
                    Pair<JsFunction, List<Context.Node>> pair2 = this.tryExtractFunction(jsExpression2);
                    if (pair2 != null) {
                        Collection collection;
                        Pair<JsFunction, List<Context.Node>> $inlineableFunction_additionalDeps = pair = pair2;
                        JsFunction inlineableFunction = (JsFunction)$inlineableFunction_additionalDeps.component1();
                        List additionalDeps = (List)$inlineableFunction_additionalDeps.component2();
                        Collection $i$a$2$let = leftNode.getFunctions();
                        $i$a$2$let.add(inlineableFunction);
                        Context.Node defineInlineFunctionNode = this.context.extractNode(function2);
                        if (defineInlineFunctionNode != null) {
                            collection = leftNode.getDependencies();
                            collection.add(defineInlineFunctionNode);
                        }
                        collection = leftNode.getDependencies();
                        CollectionsKt.addAll((Collection)collection, (Iterable)additionalDeps);
                        return leftNode;
                    }
                }
                Pair<JsFunction, List<Context.Node>> pair3 = this.tryExtractFunction(rhs);
                if (pair3 != null) {
                    Pair<JsFunction, List<Context.Node>> $functionBody_additionalDeps = pair = pair3;
                    JsFunction functionBody = (JsFunction)$functionBody_additionalDeps.component1();
                    List additionalDeps = (List)$functionBody_additionalDeps.component2();
                    Collection collection = leftNode.getFunctions();
                    collection.add(functionBody);
                    collection = leftNode.getDependencies();
                    CollectionsKt.addAll((Collection)collection, (Iterable)additionalDeps);
                    return leftNode;
                }
            } else if (rhs instanceof JsBinaryOperation) {
                if (((JsBinaryOperation)rhs).getOperator() == JsBinaryOperator.OR) {
                    JsExpression jsExpression = ((JsBinaryOperation)rhs).getArg1();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"rhs.arg1");
                    Context.Node secondNode = this.context.extractNode(jsExpression);
                    JsExpression reassignment = ((JsBinaryOperation)rhs).getArg2();
                    if (reassignment instanceof JsBinaryOperation && ((JsBinaryOperation)reassignment).getOperator() == JsBinaryOperator.ASG) {
                        JsExpression jsExpression3 = ((JsBinaryOperation)reassignment).getArg1();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"reassignment.arg1");
                        Context.Node reassignNode = this.context.extractNode(jsExpression3);
                        JsExpression reassignValue = ((JsBinaryOperation)reassignment).getArg2();
                        if (Intrinsics.areEqual((Object)reassignNode, (Object)secondNode) && reassignNode != null && reassignValue instanceof JsObjectLiteral && ((JsObjectLiteral)reassignValue).getPropertyInitializers().isEmpty()) {
                            JsExpression jsExpression4 = ((JsBinaryOperation)rhs).getArg1();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression4, (String)"rhs.arg1");
                            return this.processAssignment(node, lhs, jsExpression4);
                        }
                    }
                }
            } else {
                if (rhs instanceof JsFunction) {
                    Collection secondNode = leftNode.getFunctions();
                    secondNode.add(rhs);
                    return leftNode;
                }
                Context.Qualifier qualifier = leftNode.getQualifier();
                if (Intrinsics.areEqual((Object)(qualifier != null ? qualifier.getMemberName() : null), (Object)"$metadata$")) {
                    Collection secondNode = leftNode.getExpressions();
                    secondNode.add(rhs);
                    return leftNode;
                }
                if (rhs instanceof JsObjectLiteral && ((JsObjectLiteral)rhs).getPropertyInitializers().isEmpty()) {
                    return leftNode;
                }
            }
            Context.Node nodeInitializedByEmptyObject = this.extractVariableInitializedByEmptyObject(rhs);
            if (nodeInitializedByEmptyObject != null) {
                pair = this.astNodesToSkip;
                pair.add(rhs);
                leftNode.alias(nodeInitializedByEmptyObject);
                return leftNode;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsFunction, List<Context.Node>> tryExtractFunction(JsExpression expression2) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            return new Pair((Object)expression2, (Object)CollectionsKt.emptyList());
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"expression.qualifier");
            if (UtilKt.isWrapFunction(this.context, jsExpression2)) {
                List<JsExpression> list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.arguments");
                Object object = CollectionsKt.getOrNull(list2, (int)0);
                if (!(object instanceof JsFunction)) {
                    object = null;
                }
                JsFunction jsFunction = (JsFunction)object;
                if (jsFunction != null) {
                    void $receiver$iv$iv;
                    Object object2;
                    Object object3;
                    void $receiver$iv$iv2;
                    JsFunction jsFunction2;
                    JsFunction wrapper = jsFunction2 = jsFunction;
                    JsBlock jsBlock = wrapper.getBody();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"wrapper.body");
                    List<JsStatement> list3 = jsBlock.getStatements();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"wrapper.body.statements");
                    Object $receiver$iv = list3;
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv2) {
                        JsStatement it = (JsStatement)element$iv$iv;
                        if (!(!(it instanceof JsReturn))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List statementsWithoutBody = (List)destination$iv$iv;
                    Object it = $receiver$iv = new JsBlock(statementsWithoutBody);
                    this.context.addNodesForLocalVars((Collection<? extends JsName>)CollectUtilsKt.collectDefinedNames((JsNode)it));
                    this.accept((JsNode)it);
                    JsExpression jsExpression3 = ((JsInvocation)expression2).getQualifier();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"expression.qualifier");
                    Context.Node node = this.context.extractNode(jsExpression3);
                    if (node != null) {
                        Object it2 = it = node;
                        object3 = this.functionsToSkip;
                        object3.add(it2);
                        object2 = it;
                    } else {
                        object2 = null;
                    }
                    Object wrapperNode = object2;
                    JsBlock jsBlock2 = wrapper.getBody();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"wrapper.body");
                    List<JsStatement> list4 = jsBlock2.getStatements();
                    Intrinsics.checkExpressionValueIsNotNull(list4, (String)"wrapper.body.statements");
                    Iterable $receiver$iv2 = list4;
                    object3 = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        if (!(element$iv$iv instanceof JsReturn)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    JsExpression jsExpression4 = ((JsReturn)CollectionsKt.first((List)((List)destination$iv$iv2))).getExpression();
                    if (jsExpression4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsFunction");
                    }
                    JsFunction body = (JsFunction)jsExpression4;
                    return new Pair((Object)body, (Object)CollectionsKt.listOfNotNull((Object)wrapperNode));
                }
            }
        }
        return null;
    }

    private final void handleObjectCreate(Context.Node target, JsExpression arg) {
        if (arg == null) {
            return;
        }
        Context.Node node = this.context.extractNode(arg);
        if (node == null) {
            return;
        }
        Context.Node prototypeNode = node;
        Collection collection = target.getDependencies();
        Context.Node node2 = prototypeNode.getOriginal();
        collection.add(node2);
        collection = target.getExpressions();
        collection.add(arg);
    }

    private final Context.Node extractVariableInitializedByEmptyObject(JsExpression expression2) {
        if (!(expression2 instanceof JsConditional)) {
            return null;
        }
        JsExpression jsExpression = ((JsConditional)expression2).getTestExpression();
        if (!(jsExpression instanceof JsBinaryOperation)) {
            jsExpression = null;
        }
        JsBinaryOperation jsBinaryOperation = (JsBinaryOperation)jsExpression;
        if (jsBinaryOperation == null) {
            return null;
        }
        JsBinaryOperation testExpr = jsBinaryOperation;
        if (testExpr.getOperator() != JsBinaryOperator.REF_EQ) {
            return null;
        }
        JsExpression jsExpression2 = testExpr.getArg1();
        if (!(jsExpression2 instanceof JsPrefixOperation)) {
            jsExpression2 = null;
        }
        JsPrefixOperation jsPrefixOperation = (JsPrefixOperation)jsExpression2;
        if (jsPrefixOperation == null) {
            return null;
        }
        JsPrefixOperation testExprLhs = jsPrefixOperation;
        if (testExprLhs.getOperator() != JsUnaryOperator.TYPEOF) {
            return null;
        }
        JsExpression jsExpression3 = testExprLhs.getArg();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"testExprLhs.arg");
        Context.Node node = this.context.extractNode(jsExpression3);
        if (node == null) {
            return null;
        }
        Context.Node testExprNode = node;
        JsExpression jsExpression4 = testExpr.getArg2();
        if (!(jsExpression4 instanceof JsStringLiteral)) {
            jsExpression4 = null;
        }
        JsStringLiteral jsStringLiteral = (JsStringLiteral)jsExpression4;
        if (jsStringLiteral == null) {
            return null;
        }
        JsStringLiteral testExprRhs = jsStringLiteral;
        if (Intrinsics.areEqual((Object)testExprRhs.getValue(), (Object)"undefined") ^ true) {
            return null;
        }
        JsExpression jsExpression5 = ((JsConditional)expression2).getThenExpression();
        if (!(jsExpression5 instanceof JsObjectLiteral)) {
            jsExpression5 = null;
        }
        JsObjectLiteral jsObjectLiteral = (JsObjectLiteral)jsExpression5;
        if (jsObjectLiteral == null) {
            return null;
        }
        JsObjectLiteral thenExpr = jsObjectLiteral;
        List<JsPropertyInitializer> list2 = thenExpr.getPropertyInitializers();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"thenExpr.propertyInitializers");
        Collection collection = list2;
        if (!collection.isEmpty()) {
            return null;
        }
        JsExpression jsExpression6 = ((JsConditional)expression2).getElseExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression6, (String)"expression.elseExpression");
        Context.Node node2 = this.context.extractNode(jsExpression6);
        if (node2 == null) {
            return null;
        }
        Context.Node elseNode = node2;
        if (Intrinsics.areEqual((Object)testExprNode.getOriginal(), (Object)elseNode.getOriginal()) ^ true) {
            return null;
        }
        return testExprNode.getOriginal();
    }

    private final void enterFunction(JsFunction function2, List<? extends JsExpression> arguments2) {
        Collection collection2 = this.functionsToEnter;
        collection2.add(function2);
        this.context.addNodesForLocalVars((Collection<? extends JsName>)CollectUtilsKt.collectLocalVariables(function2));
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"function.body");
        this.context.markSpecialFunctions(jsBlock);
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.parameters");
        for (Collection collection2 : CollectionsKt.zip((Iterable)list2, (Iterable)arguments2)) {
            Object object;
            JsParameter param = (JsParameter)collection2.component1();
            JsExpression arg = (JsExpression)collection2.component2();
            if (arg instanceof JsFunction && ((JsFunction)arg).getName() == null) {
                JsBlock jsBlock2 = ((JsFunction)arg).getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"arg.body");
                JsStatement jsStatement = jsBlock2;
                JsParameter jsParameter = param;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsParameter, (String)"param");
                if (this.isProperFunctionalParameter(jsStatement, jsParameter)) {
                    JsName jsName;
                    object = this.postponedFunctions;
                    Intrinsics.checkExpressionValueIsNotNull((Object)param.getName(), (String)"param.name");
                    JsExpression jsExpression = arg;
                    object.put(jsName, jsExpression);
                    continue;
                }
            }
            JsNode jsNode = function2;
            JsParameter jsParameter = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsParameter, (String)"param");
            JsNameRef jsNameRef = jsParameter.getName().makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"param.name.makeRef()");
            if (this.processAssignment(jsNode, jsNameRef, arg) == null) continue;
            object = this.astNodesToSkip;
            object.add(arg);
        }
        this.processFunction(function2);
    }

    private final void enterFunctionWithGivenNodes(JsFunction function2, List<Context.Node> arguments2) {
        Collection collection2 = this.functionsToEnter;
        collection2.add(function2);
        this.context.addNodesForLocalVars((Collection<? extends JsName>)CollectUtilsKt.collectLocalVariables(function2));
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"function.body");
        this.context.markSpecialFunctions(jsBlock);
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.parameters");
        for (Collection collection2 : CollectionsKt.zip((Iterable)list2, (Iterable)arguments2)) {
            Context.Node paramNode;
            JsParameter param = (JsParameter)collection2.component1();
            Context.Node arg = (Context.Node)collection2.component2();
            Map<JsName, Context.Node> map2 = this.context.getNodes();
            JsParameter jsParameter = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsParameter, (String)"param");
            if (map2.get(jsParameter.getName()) == null) {
                Intrinsics.throwNpe();
            }
            paramNode.alias(arg);
        }
        this.processFunction(function2);
    }

    private final void processFunction(JsFunction function2) {
        if (this.processedFunctions.add(function2)) {
            this.accept((JsNode)function2.getBody());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isProperFunctionalParameter(JsStatement body, JsParameter parameter) {
        void result2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        body.accept(new RecursiveJsVisitor(this, parameter, (Ref.BooleanRef)result2){
            final /* synthetic */ Analyzer this$0;
            final /* synthetic */ JsParameter $parameter;
            final /* synthetic */ Ref.BooleanRef $result;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
                JsExpression qualifier = invocation.getQualifier();
                if (qualifier instanceof JsNameRef && ((JsNameRef)qualifier).getQualifier() == null && Intrinsics.areEqual((Object)((JsNameRef)qualifier).getName(), (Object)this.$parameter.getName())) {
                    boolean bl;
                    block6: {
                        List<JsExpression> list2 = invocation.getArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"invocation.arguments");
                        Iterable $receiver$iv = list2;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                JsExpression it = (JsExpression)element$iv;
                                Context context = Analyzer.access$getContext$p(this.this$0);
                                JsExpression jsExpression = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"it");
                                if (context.extractNode(jsExpression) != null) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                Context context = Analyzer.access$getContext$p(this.this$0);
                JsExpression jsExpression = qualifier;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"qualifier");
                if (UtilKt.isAmdDefine(context, jsExpression)) {
                    return;
                }
                super.visitInvocation(invocation);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                if (Intrinsics.areEqual((Object)nameRef.getName(), (Object)this.$parameter.getName())) {
                    this.$result.element = false;
                }
                super.visitNameRef(nameRef);
            }
            {
                this.this$0 = $outer;
                this.$parameter = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
            }
        });
        return result2.element;
    }

    public Analyzer(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        Analyzer analyzer2 = this;
        Object object = new LinkedHashSet();
        analyzer2.processedFunctions = object;
        analyzer2 = this;
        analyzer2.postponedFunctions = object = (Map)new LinkedHashMap();
        analyzer2 = this;
        analyzer2.nodeMap = object = (Map)new LinkedHashMap();
        analyzer2 = this;
        analyzer2.astNodesToEliminate = object = (Set)new LinkedHashSet();
        analyzer2 = this;
        analyzer2.astNodesToSkip = object = (Set)new LinkedHashSet();
        analyzer2 = this;
        analyzer2.invocationsToSkip = object = (Set)new LinkedHashSet();
        analyzer2 = this;
        analyzer2.moduleMapping = object = (Map)new LinkedHashMap();
        analyzer2 = this;
        analyzer2.functionsToEnter = object = (Set)new LinkedHashSet();
        analyzer2 = this;
        analyzer2.functionsToSkip = object = (Set)new LinkedHashSet();
        this.analysisResult = new AnalysisResult(this){
            final /* synthetic */ Analyzer this$0;

            @NotNull
            public Map<JsNode, Context.Node> getNodeMap() {
                return Analyzer.access$getNodeMap$p(this.this$0);
            }

            @NotNull
            public Set<JsNode> getAstNodesToEliminate() {
                return Analyzer.access$getAstNodesToEliminate$p(this.this$0);
            }

            @NotNull
            public Set<JsNode> getAstNodesToSkip() {
                return Analyzer.access$getAstNodesToSkip$p(this.this$0);
            }

            @NotNull
            public Set<JsFunction> getFunctionsToEnter() {
                return Analyzer.access$getFunctionsToEnter$p(this.this$0);
            }

            @NotNull
            public Set<JsInvocation> getInvocationsToSkip() {
                return Analyzer.access$getInvocationsToSkip$p(this.this$0);
            }

            @NotNull
            public Set<Context.Node> getFunctionsToSkip() {
                return Analyzer.access$getFunctionsToSkip$p(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(Analyzer $this) {
        return $this.context;
    }

    @NotNull
    public static final /* synthetic */ Map access$getNodeMap$p(Analyzer $this) {
        return $this.nodeMap;
    }

    @NotNull
    public static final /* synthetic */ Set access$getAstNodesToEliminate$p(Analyzer $this) {
        return $this.astNodesToEliminate;
    }

    @NotNull
    public static final /* synthetic */ Set access$getAstNodesToSkip$p(Analyzer $this) {
        return $this.astNodesToSkip;
    }

    @NotNull
    public static final /* synthetic */ Set access$getFunctionsToEnter$p(Analyzer $this) {
        return $this.functionsToEnter;
    }

    @NotNull
    public static final /* synthetic */ Set access$getInvocationsToSkip$p(Analyzer $this) {
        return $this.invocationsToSkip;
    }

    @NotNull
    public static final /* synthetic */ Set access$getFunctionsToSkip$p(Analyzer $this) {
        return $this.functionsToSkip;
    }
}

