/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.KotlinClassifiersCacheKt;
import org.jetbrains.kotlin.javac.resolve.MockKotlinClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0004`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/KotlinClassifiersCache;", "", "sourceFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/javac/JavacWrapper;)V", "classifiers", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Lkotlin/collections/HashMap;", "kotlinClasses", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "kotlinFacadeClasses", "kotlinPackages", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "createClassifier", "classId", "createMockKotlinClassifier", "Lorg/jetbrains/kotlin/javac/resolve/MockKotlinClassifier;", "classifier", "ktFile", "getKotlinClassifier", "hasPackage", "", "packageFqName", "cli"})
public final class KotlinClassifiersCache {
    private final HashSet<FqName> kotlinPackages;
    private final HashMap<ClassId, KtFile> kotlinFacadeClasses;
    private final Map<ClassId, KtClassOrObject> kotlinClasses;
    private final HashMap<ClassId, JavaClass> classifiers;
    private final JavacWrapper javac;

    @Nullable
    public final JavaClass getKotlinClassifier(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        JavaClass javaClass = this.classifiers.get(classId);
        if (javaClass == null) {
            javaClass = this.createClassifier(classId);
        }
        return javaClass;
    }

    @NotNull
    public final MockKotlinClassifier createMockKotlinClassifier(@Nullable KtClassOrObject classifier2, @Nullable KtFile ktFile, @NotNull ClassId classId) {
        MockKotlinClassifier mockKotlinClassifier;
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        MockKotlinClassifier $receiver = mockKotlinClassifier = new MockKotlinClassifier(classId, classifier2, ktFile, this, this.javac);
        Map map2 = this.classifiers;
        ClassId classId2 = classId;
        MockKotlinClassifier mockKotlinClassifier2 = $receiver;
        map2.put(classId2, mockKotlinClassifier2);
        return mockKotlinClassifier;
    }

    public final boolean hasPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return this.kotlinPackages.contains(packageFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final JavaClass createClassifier(ClassId classId) {
        KtFile ktFile = this.kotlinFacadeClasses.get(classId);
        if (ktFile != null) {
            KtFile ktFile2;
            KtFile it = ktFile2 = ktFile;
            return this.createMockKotlinClassifier(null, it, classId);
        }
        if (classId.isNestedClass()) {
            JavaClass javaClass;
            Iterator it;
            Object object;
            String it2;
            Object object2;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            JavaClass javaClass2 = this.classifiers.get(classId);
            if (javaClass2 != null) {
                JavaClass javaClass3;
                JavaClass it3 = javaClass3 = javaClass2;
                return it3;
            }
            List<Name> list2 = classId.getRelativeClassName().pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classId.relativeClassName.pathSegments()");
            Iterable $i$a$2$let = $receiver$iv = (Iterable)list2;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                object2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                object = ((Name)((Object)it2)).asString();
                collection.add(object);
            }
            List pathSegments = (List)((Object)destination$iv$iv);
            ClassId outerClassId = new ClassId(classId.getPackageFqName(), Name.identifier((String)CollectionsKt.first((List)pathSegments)));
            Object object3 = this.kotlinClasses.get(outerClassId);
            if (object3 == null || (object3 = (object = this.createMockKotlinClassifier((KtClassOrObject)((Object)(it = (destination$iv$iv = object3))), null, outerClassId))) == null) {
                return null;
            }
            JavaClass outerClass2 = (JavaClass)object3;
            Iterable $receiver$iv2 = CollectionsKt.drop((Iterable)pathSegments, (int)1);
            for (Object element$iv : $receiver$iv2) {
                it2 = (String)element$iv;
                Name name = Name.identifier(it2);
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(it)");
                if (outerClass2.findInnerClass(name) != null) continue;
                return null;
            }
            JavaClass $receiver = javaClass = outerClass2;
            Map map2 = this.classifiers;
            object2 = classId;
            JavaClass javaClass4 = $receiver;
            map2.put(object2, javaClass4);
            return javaClass;
        }
        KtClassOrObject ktClassOrObject = this.kotlinClasses.get(classId);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject kotlinClassifier = ktClassOrObject;
        return this.createMockKotlinClassifier(kotlinClassifier, null, classId);
    }

    /*
     * WARNING - void declaration
     */
    public KotlinClassifiersCache(@NotNull Collection<? extends KtFile> sourceFiles2, @NotNull JavacWrapper javac2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(sourceFiles2, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)javac2, (String)"javac");
        this.javac = javac2;
        KotlinClassifiersCache kotlinClassifiersCache2 = this;
        HashMap hashMap = new HashSet();
        kotlinClassifiersCache2.kotlinPackages = hashMap;
        kotlinClassifiersCache2 = this;
        hashMap = new HashMap();
        kotlinClassifiersCache2.kotlinFacadeClasses = hashMap;
        Iterable iterable = sourceFiles2;
        kotlinClassifiersCache2 = this;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv2;
            KtFile ktFile = (KtFile)element$iv$iv;
            this.kotlinPackages.add(ktFile.getPackageFqName());
            FqName facadeFqName = JvmFileClassUtilKt.getJavaFileFacadeFqName(ktFile);
            Object object = this.kotlinFacadeClasses;
            ClassId classId = new ClassId(facadeFqName.parent(), facadeFqName.shortName());
            KtFile ktFile2 = ktFile;
            object.put(classId, ktFile2);
            object = ktFile.getDeclarations();
            classId = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                if (!(element$iv$iv2 instanceof KtClassOrObject)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                KtClassOrObject $i$f$filterIsInstanceTo = (KtClassOrObject)item$iv$iv;
                Collection collection = destination$iv$iv2;
                Pair pair = TuplesKt.to((Object)KotlinClassifiersCacheKt.access$computeClassId((KtClassOrObject)it), (Object)it);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        hashMap = (List)destination$iv$iv;
        kotlinClassifiersCache2.kotlinClasses = MapsKt.toMap((Iterable)((Iterable)((Object)hashMap)));
        kotlinClassifiersCache2 = this;
        hashMap = new HashMap();
        kotlinClassifiersCache2.classifiers = hashMap;
    }
}

