/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.functors.AbstractReducingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0014J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ \u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/EqualsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/functors/AbstractReducingFunctor;", "isNegated", "", "(Z)V", "()Z", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "equateCallAndConstant", "call", "constant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "equateValues", "left", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "right", "invokeWithArguments", "isSafeToProduceFalse", "leftCall", "leftConstant", "rightConstant", "resolution"})
public final class EqualsFunctor
extends AbstractReducingFunctor {
    private final boolean isNegated;

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        boolean bl2 = bl = arguments2.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string = "Equals functor expected 2 arguments, got " + arguments2.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (arguments2.size() != 2) {
            return CollectionsKt.emptyList();
        }
        return this.invokeWithArguments(arguments2.get(0), arguments2.get(1));
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation left, @NotNull Computation right) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        if (left instanceof ESValue && right instanceof ESValue) {
            return this.equateValues((ESValue)left, (ESValue)right);
        }
        if (left instanceof ESConstant) {
            return this.equateCallAndConstant(right, (ESConstant)left);
        }
        if (right instanceof ESConstant) {
            return this.equateCallAndConstant(left, (ESConstant)right);
        }
        return CollectionsKt.emptyList();
    }

    private final List<ESEffect> equateCallAndConstant(Computation call2, ESConstant constant) {
        List resultingClauses = new ArrayList();
        for (ESEffect effect : call2.getEffects()) {
            if (!(effect instanceof ConditionalEffect) || !(((ConditionalEffect)effect).getSimpleEffect() instanceof ESReturns) || Intrinsics.areEqual((Object)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), (Object)ESConstant.Companion.getWILDCARD())) {
                Collection collection = resultingClauses;
                collection.add(effect);
                continue;
            }
            if (Intrinsics.areEqual((Object)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), (Object)constant)) {
                ConditionalEffect trueClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(ValuesKt.lift(!this.isNegated)));
                resultingClauses.add(trueClause);
            }
            if (!(Intrinsics.areEqual((Object)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), (Object)constant) ^ true) || !(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue() instanceof ESConstant) || !this.isSafeToProduceFalse(call2, (ESConstant)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) continue;
            ConditionalEffect falseClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(ValuesKt.lift(this.isNegated)));
            resultingClauses.add(falseClause);
        }
        return resultingClauses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSafeToProduceFalse(Computation leftCall, ESConstant leftConstant, ESConstant rightConstant) {
        if (KotlinBuiltIns.isBoolean(rightConstant.getType()) && leftCall.getType() != null) {
            KotlinType kotlinType = leftCall.getType();
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            if (KotlinBuiltIns.isBoolean(kotlinType)) {
                return true;
            }
        }
        if (!leftConstant.isNullConstant()) return false;
        if (!rightConstant.isNullConstant()) return false;
        return true;
    }

    private final List<ESEffect> equateValues(ESValue left, ESValue right) {
        return CollectionsKt.listOf((Object[])new ConditionalEffect[]{new ConditionalEffect(new ESEqual(left, right, this.isNegated), new ESReturns(ValuesKt.lift(true))), new ConditionalEffect(new ESEqual(left, right, !this.isNegated), new ESReturns(ValuesKt.lift(false)))});
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    public EqualsFunctor(boolean isNegated) {
        this.isNegated = isNegated;
    }
}

