/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ui.paint;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;

public class PaintUtil {
    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(2);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create((Graphics2D)g), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull JBUI.ScaleContext ctx, @Nullable RoundingMode rm, @Nullable ParityMode parityMode) {
        void pm;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(5);
        }
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        double scale = PaintUtil.getScale(ctx);
        int devValue = PaintUtil.devValue(usrValue, scale, pm != null && rm == RoundingMode.ROUND ? RoundingMode.FLOOR : rm);
        if (pm != null && ParityMode.of(devValue) != pm) {
            devValue += rm == RoundingMode.FLOOR ? -1 : 1;
        }
        return (double)devValue / scale;
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(7);
        }
        return PaintUtil.devValue(usrValue, JBUI.ScaleContext.create((Graphics2D)g));
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull JBUI.ScaleContext scaleContext) {
        void ctx;
        if (scaleContext == null) {
            PaintUtil.$$$reportNull$$$0(8);
        }
        return usrValue * PaintUtil.getScale((JBUI.ScaleContext)ctx);
    }

    private static int devValue(double usrValue, double scale, @Nullable RoundingMode rm) {
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        return rm.round(usrValue * scale);
    }

    private static double getScale(JBUI.ScaleContext ctx) {
        return ctx.getScale(JBUI.ScaleType.USR_SCALE) == 0.0 ? 0.0 : ctx.getScale(JBUI.ScaleType.PIX_SCALE) / ctx.getScale(JBUI.ScaleType.USR_SCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintWithAA(@NotNull Graphics2D g, @NotNull Object valueAA, @NotNull Runnable paint) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(12);
        }
        if (valueAA == null) {
            PaintUtil.$$$reportNull$$$0(13);
        }
        if (paint == null) {
            PaintUtil.$$$reportNull$$$0(14);
        }
        if (valueAA == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            paint.run();
            return;
        }
        Object key = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, valueAA);
        try {
            paint.run();
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tx";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAA";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ui/paint/PaintUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ui/paint/PaintUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "insets2offset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParityMode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "alignToInt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "devValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "alignTxToInt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "alignClipToInt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFractionalScale";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "paintWithAA";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ParityMode {
        EVEN,
        ODD;


        public static ParityMode of(int value) {
            return value % 2 == 0 ? EVEN : ODD;
        }
    }

    public static enum RoundingMode {
        FLOOR{

            @Override
            public int round(double value) {
                return (int)Math.floor(value);
            }
        }
        ,
        CEIL{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value);
            }
        }
        ,
        ROUND{

            @Override
            public int round(double value) {
                return (int)Math.round(value);
            }
        }
        ,
        ROUND_FLOOR_BIAS{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value - 0.5);
            }
        };


        public abstract int round(double var1);
    }
}

