/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreBundle;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class ClsElementImpl
extends PsiElementBase
implements PsiCompiledElement {
    public static final Key<PsiCompiledElement> COMPILED_ELEMENT = Key.create("COMPILED_ELEMENT");
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsElementImpl");
    private volatile Pair<TextRange, Identikit.ByType> myMirror;
    protected static final String NEXT_LINE = "go_to_next_line_and_indent";

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            ClsElementImpl.$$$reportNull$$$0(0);
        }
        return javaLanguage;
    }

    @Override
    public PsiManager getManager() {
        return this.getParent().getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        PsiElement parent2 = this.getParent();
        if (parent2 == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return parent2.getContainingFile();
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public boolean isValid() {
        PsiElement parent2 = this.getParent();
        return parent2 != null && parent2.isValid();
    }

    @Override
    public PsiElement copy() {
        return this;
    }

    @NotNull
    protected PsiElement[] getChildren(PsiElement ... children2) {
        if (children2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ClsElementImpl.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList list2 = ContainerUtil.newArrayListWithCapacity(children2.length);
        for (PsiElement child : children2) {
            if (child == null) continue;
            list2.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(list2);
        if (psiElementArray == null) {
            ClsElementImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(3);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @NotNull
    static IncorrectOperationException cannotModifyException(@NotNull PsiCompiledElement element) {
        VirtualFile virtualFile2;
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(4);
        }
        String path2 = (virtualFile2 = PsiUtilCore.getVirtualFile(element)) == null ? "?" : virtualFile2.getPresentableUrl();
        IncorrectOperationException incorrectOperationException = new IncorrectOperationException(JavaCoreBundle.message("psi.error.attempt.to.edit.class.file", path2));
        if (incorrectOperationException == null) {
            ClsElementImpl.$$$reportNull$$$0(5);
        }
        return incorrectOperationException;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(6);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(7);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(8);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            ClsElementImpl.$$$reportNull$$$0(9);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    public abstract void appendMirrorText(int var1, @NotNull StringBuilder var2);

    protected int getIndentSize() {
        return JavaCodeStyleSettingsFacade.getInstance(this.getProject()).getIndentSize();
    }

    public abstract void setMirror(@NotNull TreeElement var1) throws InvalidMirrorException;

    @Override
    public PsiElement getMirror() {
        PsiFile mirrorFile = ((ClsFileImpl)this.getContainingFile()).getMirror().getContainingFile();
        Pair<TextRange, Identikit.ByType> mirror = this.myMirror;
        return mirror == null ? null : ((Identikit.ByType)mirror.second).findPsiElement(mirrorFile, ((TextRange)mirror.first).getStartOffset(), ((TextRange)mirror.first).getEndOffset());
    }

    @Override
    public final TextRange getTextRange() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Override
    public final int getStartOffsetInParent() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getStartOffsetInParent() : -1;
    }

    @Override
    public int getTextLength() {
        String text2 = this.getText();
        return text2 == null ? 0 : text2.length();
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.findElementAt(offset2) : null;
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.findReferenceAt(offset2) : null;
    }

    @Override
    public final int getTextOffset() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextOffset() : -1;
    }

    @Override
    public String getText() {
        PsiElement mirror = this.getMirror();
        if (mirror != null) {
            return mirror.getText();
        }
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        LOG.warn("Mirror wasn't set for " + this + " in " + this.getContainingFile() + ", expected text '" + buffer + "'");
        return buffer.toString();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        PsiElement mirror = this.getMirror();
        char[] cArray = mirror != null ? mirror.textToCharArray() : ArrayUtil.EMPTY_CHAR_ARRAY;
        if (cArray == null) {
            ClsElementImpl.$$$reportNull$$$0(10);
        }
        return cArray;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            ClsElementImpl.$$$reportNull$$$0(11);
        }
        return this.getText().equals(text2.toString());
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(12);
        }
        return this.getText().equals(element.getText());
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    static void goNextLine(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsElementImpl.$$$reportNull$$$0(13);
        }
        buffer.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            buffer.append(' ');
        }
    }

    protected static void appendText(@Nullable PsiElement stub2, int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsElementImpl.$$$reportNull$$$0(14);
        }
        if (stub2 == null) {
            return;
        }
        ((ClsElementImpl)stub2).appendMirrorText(indentLevel, buffer);
    }

    protected static void appendText(@Nullable PsiElement stub2, int indentLevel, @NotNull StringBuilder buffer, @NotNull String separator) {
        if (buffer == null) {
            ClsElementImpl.$$$reportNull$$$0(15);
        }
        if (separator == null) {
            ClsElementImpl.$$$reportNull$$$0(16);
        }
        if (stub2 == null) {
            return;
        }
        int pos = buffer.length();
        ((ClsElementImpl)stub2).appendMirrorText(indentLevel, buffer);
        if (buffer.length() != pos) {
            if (separator == NEXT_LINE) {
                ClsElementImpl.goNextLine(indentLevel, buffer);
            } else {
                buffer.append(separator);
            }
        }
    }

    protected void setMirrorCheckingType(@NotNull TreeElement element, @Nullable IElementType type2) throws InvalidMirrorException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(17);
        }
        if (type2 != null && element.getElementType() != type2) {
            throw new InvalidMirrorException(element.getElementType() + " != " + type2);
        }
        PsiElement psi = element.getPsi();
        psi.putUserData(COMPILED_ELEMENT, this);
        this.myMirror = Pair.create(element.getTextRange(), Identikit.fromPsi(psi, JavaLanguage.INSTANCE));
    }

    protected static <T extends PsiElement> void setMirror(@Nullable T stub2, @Nullable T mirror) throws InvalidMirrorException {
        if (stub2 == null || mirror == null) {
            throw new InvalidMirrorException(stub2, mirror);
        }
        ((ClsElementImpl)stub2).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
    }

    protected static <T extends PsiElement> void setMirrorIfPresent(@Nullable T stub2, @Nullable T mirror) throws InvalidMirrorException {
        if (stub2 == null != (mirror == null)) {
            throw new InvalidMirrorException(stub2, mirror);
        }
        if (stub2 != null) {
            ((ClsElementImpl)stub2).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
        }
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull T[] stubs, @NotNull T[] mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            ClsElementImpl.$$$reportNull$$$0(18);
        }
        if (mirrors == null) {
            ClsElementImpl.$$$reportNull$$$0(19);
        }
        ClsElementImpl.setMirrors(Arrays.asList(stubs), Arrays.asList(mirrors));
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull List<T> stubs, @NotNull List<T> mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            ClsElementImpl.$$$reportNull$$$0(20);
        }
        if (mirrors == null) {
            ClsElementImpl.$$$reportNull$$$0(21);
        }
        if (stubs.size() != mirrors.size()) {
            throw new InvalidMirrorException(stubs, mirrors);
        }
        for (int i = 0; i < stubs.size(); ++i) {
            ClsElementImpl.setMirror((PsiElement)stubs.get(i), (PsiElement)mirrors.get(i));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsElementImpl";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubs";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mirrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsElementImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cannotModifyException";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cannotModifyException";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "goNextLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setMirrorCheckingType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setMirrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class InvalidMirrorException
    extends RuntimeException {
        public InvalidMirrorException(@NotNull String message) {
            if (message == null) {
                InvalidMirrorException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        public InvalidMirrorException(@Nullable PsiElement stubElement, @Nullable PsiElement mirrorElement) {
            this("stub:" + stubElement + "; mirror:" + mirrorElement);
        }

        public InvalidMirrorException(@NotNull List<? extends PsiElement> stubElements, @NotNull List<? extends PsiElement> mirrorElements) {
            if (stubElements == null) {
                InvalidMirrorException.$$$reportNull$$$0(1);
            }
            if (mirrorElements == null) {
                InvalidMirrorException.$$$reportNull$$$0(2);
            }
            this("stub:" + stubElements + "; mirror:" + mirrorElements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stubElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mirrorElements";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

