/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.signature.AsmTypeFactory;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.IncompatibleClassTracker;
import org.jetbrains.kotlin.codegen.state.ReceiverTypeAndTypeParameters;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.codegen.state.TypeMappingUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.IrBuiltinsPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class KotlinTypeMapper {
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final IncompatibleClassTracker incompatibleClassTracker;
    private final String moduleName;
    private final boolean isJvm8Target;
    private final boolean isReleaseCoroutines;
    private boolean isIrBackend;
    private final TypeMappingConfiguration<Type> typeMappingConfiguration = new TypeMappingConfiguration<Type>(){

        @Override
        @NotNull
        public KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
            return CommonSupertypes.commonSupertype(types);
        }

        @Override
        @Nullable
        public Type getPredefinedTypeForClass(@NotNull ClassDescriptor classDescriptor) {
            return KotlinTypeMapper.this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptor);
        }

        @Override
        @Nullable
        public String getPredefinedInternalNameForClass(@NotNull ClassDescriptor classDescriptor) {
            Type type2 = this.getPredefinedTypeForClass(classDescriptor);
            return type2 == null ? null : type2.getInternalName();
        }

        @Override
        public void processErrorType(@NotNull KotlinType kotlinType, @NotNull ClassDescriptor descriptor2) {
            if (((KotlinTypeMapper)KotlinTypeMapper.this).classBuilderMode.generateBodies) {
                throw new IllegalStateException(KotlinTypeMapper.generateErrorMessageForErrorType(kotlinType, descriptor2));
            }
        }

        @Override
        public boolean releaseCoroutines() {
            return KotlinTypeMapper.this.isReleaseCoroutines;
        }
    };
    private static final TypeMappingConfiguration<Type> staticTypeMappingConfiguration = new TypeMappingConfiguration<Type>(){

        @Override
        @NotNull
        public KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
            return CommonSupertypes.commonSupertype(types);
        }

        @Override
        @Nullable
        public Type getPredefinedTypeForClass(@NotNull ClassDescriptor classDescriptor) {
            return null;
        }

        @Override
        @Nullable
        public String getPredefinedInternalNameForClass(@NotNull ClassDescriptor classDescriptor) {
            return null;
        }

        @Override
        public void processErrorType(@NotNull KotlinType kotlinType, @NotNull ClassDescriptor descriptor2) {
            throw new IllegalStateException(KotlinTypeMapper.generateErrorMessageForErrorType(kotlinType, descriptor2));
        }

        @Override
        public boolean releaseCoroutines() {
            return false;
        }
    };
    public static final boolean RELEASE_COROUTINES_DEFAULT = false;
    private static final ClassId FAKE_CLASS_ID_FOR_BUILTINS = ClassId.topLevel(new FqName("kotlin.KotlinPackage"));

    public KotlinTypeMapper(@NotNull BindingContext bindingContext, @NotNull ClassBuilderMode classBuilderMode, @NotNull IncompatibleClassTracker incompatibleClassTracker, @NotNull String moduleName, boolean isJvm8Target) {
        this(bindingContext, classBuilderMode, incompatibleClassTracker, moduleName, isJvm8Target, false, false);
    }

    public KotlinTypeMapper(@NotNull BindingContext bindingContext, @NotNull ClassBuilderMode classBuilderMode, @NotNull IncompatibleClassTracker incompatibleClassTracker, @NotNull String moduleName, boolean isJvm8Target, boolean isReleaseCoroutines, boolean isIrBackend) {
        this.bindingContext = bindingContext;
        this.classBuilderMode = classBuilderMode;
        this.incompatibleClassTracker = incompatibleClassTracker;
        this.moduleName = moduleName;
        this.isJvm8Target = isJvm8Target;
        this.isReleaseCoroutines = isReleaseCoroutines;
        this.isIrBackend = isIrBackend;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2) {
        return this.mapOwner(descriptor2, true);
    }

    public Type mapImplementationOwner(@NotNull DeclarationDescriptor descriptor2) {
        return this.mapOwner(descriptor2, false);
    }

    @NotNull
    private Type mapOwner(@NotNull DeclarationDescriptor descriptor2, boolean publicFacade) {
        if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction((FunctionDescriptor)descriptor2));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.mapClass(((ConstructorDescriptor)descriptor2).getConstructedClass());
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof PackageFragmentDescriptor) {
            String packageMemberOwner = KotlinTypeMapper.internalNameForPackageMemberOwner((CallableMemberDescriptor)descriptor2, publicFacade);
            return Type.getObjectType(packageMemberOwner);
        }
        if (container2 instanceof ClassDescriptor) {
            return this.mapClass((ClassDescriptor)container2);
        }
        throw new UnsupportedOperationException("Don't know how to map owner for " + descriptor2);
    }

    @NotNull
    private static String internalNameForPackageMemberOwner(@NotNull CallableMemberDescriptor descriptor2, boolean publicFacade) {
        String facadeFqName;
        KtFile file2;
        boolean isAccessor = descriptor2 instanceof AccessorForCallableDescriptor;
        if (isAccessor) {
            descriptor2 = ((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor();
        }
        if ((file2 = DescriptorToSourceUtils.getContainingFile(descriptor2)) != null) {
            Visibility visibility = descriptor2.getVisibility();
            if (!publicFacade || KotlinTypeMapper.isNonConstProperty(descriptor2) || Visibilities.isPrivate(visibility) || isAccessor) {
                return JvmFileClassUtil.getFileClassInternalName(file2);
            }
            return JvmFileClassUtil.getFacadeClassInternalName(file2);
        }
        CallableMemberDescriptor directMember = DescriptorUtils.getDirectMember(descriptor2);
        if (directMember instanceof DeserializedCallableMemberDescriptor && (facadeFqName = KotlinTypeMapper.getPackageMemberOwnerInternalName((DeserializedCallableMemberDescriptor)directMember, publicFacade)) != null) {
            return facadeFqName;
        }
        if (descriptor2.getContainingDeclaration() instanceof IrBuiltinsPackageFragmentDescriptor) {
            return descriptor2.getContainingDeclaration().getName().asString();
        }
        throw new RuntimeException("Could not find package member for " + descriptor2 + " in package fragment " + descriptor2.getContainingDeclaration());
    }

    private static boolean isNonConstProperty(@NotNull CallableMemberDescriptor descriptor2) {
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        return !propertyDescriptor.isConst();
    }

    @NotNull
    public static ContainingClassesInfo getContainingClassesForDeserializedCallable(@NotNull DeserializedCallableMemberDescriptor deserializedDescriptor) {
        ContainingClassesInfo containingClassesInfo;
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            containingClassesInfo = KotlinTypeMapper.getPackageMemberContainingClassesInfo(deserializedDescriptor);
        } else {
            ClassId classId = KotlinTypeMapper.getContainerClassIdForClassDescriptor((ClassDescriptor)parentDeclaration);
            containingClassesInfo = ContainingClassesInfo.forClassMember(classId);
        }
        if (containingClassesInfo == null) {
            throw new IllegalStateException("Couldn't find container for " + deserializedDescriptor.getName());
        }
        return containingClassesInfo;
    }

    @NotNull
    private static ClassId getContainerClassIdForClassDescriptor(@NotNull ClassDescriptor classDescriptor) {
        ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
        assert (classId != null) : "Deserialized class should have a ClassId: " + classDescriptor;
        String nestedClass = DescriptorUtils.isInterface(classDescriptor) ? "$DefaultImpls" : (classDescriptor.isInline() ? "$Erased" : null);
        if (nestedClass != null) {
            FqName relativeClassName = classId.getRelativeClassName();
            String defaultImplsClassName = relativeClassName.shortName().asString() + nestedClass;
            return new ClassId(classId.getPackageFqName(), Name.identifier(defaultImplsClassName));
        }
        return classId;
    }

    @Nullable
    private static String getPackageMemberOwnerInternalName(@NotNull DeserializedCallableMemberDescriptor descriptor2, boolean publicFacade) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Not a top-level member: " + descriptor2;
        ContainingClassesInfo containingClasses = KotlinTypeMapper.getPackageMemberContainingClassesInfo(descriptor2);
        if (containingClasses == null) {
            return null;
        }
        ClassId ownerClassId = publicFacade ? containingClasses.getFacadeClassId() : containingClasses.getImplClassId();
        return JvmClassName.byClassId(ownerClassId).getInternalName();
    }

    @Nullable
    private static ContainingClassesInfo getPackageMemberContainingClassesInfo(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        JvmClassName facadeName;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof BuiltInsPackageFragment) {
            return new ContainingClassesInfo(FAKE_CLASS_ID_FOR_BUILTINS, FAKE_CLASS_ID_FOR_BUILTINS);
        }
        JvmClassName implClassName = UtilKt.getImplClassNameForDeserialized(descriptor2);
        assert (implClassName != null) : "No implClassName for " + descriptor2;
        if (containingDeclaration instanceof LazyJavaPackageFragment) {
            facadeName = ((LazyJavaPackageFragment)containingDeclaration).getFacadeNameForPartName(implClassName);
            if (facadeName == null) {
                return null;
            }
        } else if (containingDeclaration instanceof IncrementalPackageFragmentProvider.IncrementalMultifileClassPackageFragment) {
            facadeName = ((IncrementalPackageFragmentProvider.IncrementalMultifileClassPackageFragment)containingDeclaration).getFacadeName();
        } else {
            throw new AssertionError((Object)("Unexpected package fragment for " + descriptor2 + ": " + containingDeclaration + " (" + containingDeclaration.getClass().getSimpleName() + ")"));
        }
        return ContainingClassesInfo.forPackageMember(facadeName, implClassName);
    }

    @NotNull
    public Type mapReturnType(@NotNull CallableDescriptor descriptor2) {
        return this.mapReturnType(descriptor2, null);
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw) {
        KotlinType returnType2 = descriptor2.getReturnType();
        assert (returnType2 != null) : "Function has no return type: " + descriptor2;
        if (descriptor2 instanceof ConstructorDescriptor) {
            return Type.VOID_TYPE;
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            return this.mapReturnType(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView((SimpleFunctionDescriptor)descriptor2, this.isReleaseCoroutines), sw);
        }
        if (TypeSignatureMappingKt.hasVoidReturnType(descriptor2)) {
            if (sw != null) {
                sw.writeAsmType(Type.VOID_TYPE);
            }
            return Type.VOID_TYPE;
        }
        if (descriptor2 instanceof FunctionDescriptor && KotlinTypeMapper.forceBoxedReturnType((FunctionDescriptor)descriptor2)) {
            return this.mapType(descriptor2.getReturnType(), sw, TypeMappingMode.RETURN_TYPE_BOXED);
        }
        return this.mapReturnType(descriptor2, sw, returnType2);
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw, @NotNull KotlinType returnType2) {
        boolean isAnnotationMethod = DescriptorUtils.isAnnotationClass(descriptor2.getContainingDeclaration());
        if (sw == null || sw.skipGenericSignature()) {
            return this.mapType(returnType2, sw, TypeMappingMode.getModeForReturnTypeNoGeneric(isAnnotationMethod));
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(descriptor2, returnType2, isAnnotationMethod);
        if (typeMappingModeFromAnnotation != null) {
            return this.mapType(returnType2, sw, typeMappingModeFromAnnotation);
        }
        TypeMappingMode mappingMode = TypeMappingMode.getOptimalModeForReturnType(returnType2, isAnnotationMethod);
        return this.mapType(returnType2, sw, mappingMode);
    }

    @NotNull
    public Type mapSupertype(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        return this.mapType(jetType, signatureVisitor, TypeMappingMode.SUPER_TYPE);
    }

    @NotNull
    public Type mapTypeParameter(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        return this.mapType(jetType, signatureVisitor, TypeMappingMode.GENERIC_ARGUMENT);
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier2) {
        return this.mapType(classifier2.getDefaultType(), null, TypeMappingMode.CLASS_DECLARATION);
    }

    @NotNull
    public Type mapType(@NotNull KotlinType jetType) {
        return this.mapType(jetType, null, TypeMappingMode.DEFAULT);
    }

    @NotNull
    public Type mapTypeAsDeclaration(@NotNull KotlinType kotlinType) {
        return this.mapType(kotlinType, null, TypeMappingMode.CLASS_DECLARATION);
    }

    @NotNull
    public Type mapType(@NotNull CallableDescriptor descriptor2) {
        return this.mapType(descriptor2.getReturnType());
    }

    @NotNull
    public Type mapTypeAsDeclaration(@NotNull CallableDescriptor descriptor2) {
        return this.mapTypeAsDeclaration(descriptor2.getReturnType());
    }

    public Type mapErasedInlineClass(@NotNull ClassDescriptor descriptor2) {
        return Type.getObjectType(this.mapClass(descriptor2).getInternalName() + "$Erased");
    }

    @NotNull
    public JvmMethodGenericSignature mapAnnotationParameterSignature(@NotNull PropertyDescriptor descriptor2) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeReturnType();
        this.mapType(descriptor2.getType(), sw, TypeMappingMode.VALUE_FOR_ANNOTATION);
        ((JvmSignatureWriter)sw).writeReturnTypeEnd();
        return sw.makeJvmMethodSignature(descriptor2.getName().asString());
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor descriptor2) {
        return this.mapType(descriptor2.getDefaultType());
    }

    @NotNull
    public Type mapType(@NotNull KotlinType kotlinType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        return TypeSignatureMappingKt.mapType(kotlinType, AsmTypeFactory.INSTANCE, mode, this.typeMappingConfiguration, signatureVisitor, (ktType, asmType, typeMappingMode) -> {
            this.writeGenericType((KotlinType)ktType, (Type)asmType, signatureVisitor, (TypeMappingMode)typeMappingMode);
            return Unit.INSTANCE;
        }, this.isIrBackend);
    }

    @NotNull
    public static Type mapInlineClassTypeAsDeclaration(@NotNull KotlinType kotlinType) {
        return KotlinTypeMapper.mapInlineClassType(kotlinType, TypeMappingMode.CLASS_DECLARATION);
    }

    @NotNull
    public static Type mapUnderlyingTypeOfInlineClassType(@NotNull KotlinType kotlinType) {
        KotlinType underlyingType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(kotlinType);
        if (underlyingType == null) {
            throw new IllegalStateException("There should be underlying type for inline class type: " + kotlinType);
        }
        return KotlinTypeMapper.mapInlineClassType(underlyingType, TypeMappingMode.DEFAULT);
    }

    @NotNull
    public static Type mapToErasedInlineClassType(@NotNull KotlinType kotlinType) {
        return Type.getObjectType(KotlinTypeMapper.mapInlineClassTypeAsDeclaration(kotlinType).getInternalName() + "$Erased");
    }

    @NotNull
    public static Type mapInlineClassType(@NotNull KotlinType kotlinType) {
        return KotlinTypeMapper.mapInlineClassType(kotlinType, TypeMappingMode.DEFAULT);
    }

    private static Type mapInlineClassType(@NotNull KotlinType kotlinType, @NotNull TypeMappingMode mode) {
        return TypeSignatureMappingKt.mapType(kotlinType, AsmTypeFactory.INSTANCE, mode, staticTypeMappingConfiguration, null, (ktType, asmType, typeMappingMode) -> Unit.INSTANCE, false);
    }

    @NotNull
    public Type mapDefaultImpls(@NotNull ClassDescriptor descriptor2) {
        return Type.getObjectType(this.mapType(descriptor2).getInternalName() + "$DefaultImpls");
    }

    @NotNull
    private static String generateErrorMessageForErrorType(@NotNull KotlinType type2, @NotNull DeclarationDescriptor descriptor2) {
        PsiElement declarationElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declarationElement == null) {
            return String.format("Error type encountered: %s (%s).", type2, type2.getClass().getSimpleName());
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        PsiElement parentDeclarationElement = containingDeclaration != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingDeclaration) : null;
        return String.format("Error type encountered: %s (%s). Descriptor: %s. For declaration %s:%s in %s:%s", type2, type2.getClass().getSimpleName(), descriptor2, declarationElement, declarationElement.getText(), parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null");
    }

    private void writeGenericType(@NotNull KotlinType type2, @NotNull Type asmType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        if (signatureVisitor == null) {
            return;
        }
        if (signatureVisitor.skipGenericSignature() || KotlinTypeMapper.hasNothingInNonContravariantPosition(type2) || type2.getArguments().isEmpty()) {
            signatureVisitor.writeAsmType(asmType);
            return;
        }
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        assert (possiblyInnerType != null) : "possiblyInnerType with arguments should not be null";
        List<PossiblyInnerType> innerTypesAsList = possiblyInnerType.segments();
        int indexOfParameterizedType = CollectionsKt.indexOfFirst(innerTypesAsList, innerPart -> !innerPart.getArguments().isEmpty());
        if (indexOfParameterizedType < 0 || innerTypesAsList.size() == 1) {
            signatureVisitor.writeClassBegin(asmType);
            this.writeGenericArguments(signatureVisitor, possiblyInnerType, mode);
        } else {
            PossiblyInnerType outerType = innerTypesAsList.get(indexOfParameterizedType);
            signatureVisitor.writeOuterClassBegin(asmType, this.mapType(outerType.getClassDescriptor()).getInternalName());
            this.writeGenericArguments(signatureVisitor, outerType, mode);
            this.writeInnerParts(innerTypesAsList, signatureVisitor, mode, indexOfParameterizedType + 1);
        }
        signatureVisitor.writeClassEnd();
    }

    private void writeInnerParts(@NotNull List<PossiblyInnerType> innerTypesAsList, @NotNull JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode, int index2) {
        for (PossiblyInnerType innerPart : innerTypesAsList.subList(index2, innerTypesAsList.size())) {
            signatureVisitor.writeInnerClass(KotlinTypeMapper.getJvmShortName(innerPart.getClassDescriptor()));
            this.writeGenericArguments(signatureVisitor, innerPart, mode);
        }
    }

    @NotNull
    private static String getJvmShortName(@NotNull ClassDescriptor klass2) {
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtils.getFqName(klass2));
        if (classId != null) {
            return classId.getShortClassName().asString();
        }
        return SpecialNames.safeIdentifier(klass2.getName()).getIdentifier();
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull PossiblyInnerType type2, @NotNull TypeMappingMode mode) {
        ClassDescriptor classDescriptor = type2.getClassDescriptor();
        List<TypeParameterDescriptor> parameters2 = classDescriptor.getDeclaredTypeParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        if (classDescriptor instanceof FunctionClassDescriptor && ((FunctionClassDescriptor)classDescriptor).getFunctionKind() == FunctionClassDescriptor.Kind.KFunction) {
            this.writeGenericArguments(signatureVisitor, Collections.singletonList(CollectionsKt.last(arguments2)), Collections.singletonList(CollectionsKt.last(parameters2)), mode);
            return;
        }
        this.writeGenericArguments(signatureVisitor, arguments2, parameters2, mode);
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull List<? extends TypeProjection> arguments2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull TypeMappingMode mode) {
        for (Pair item : CollectionsKt.zip(parameters2, arguments2)) {
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)item.getFirst();
            TypeProjection argument = (TypeProjection)item.getSecond();
            if (argument.isStarProjection() || KotlinBuiltIns.isNothing(argument.getType()) && parameter.getVariance() == Variance.IN_VARIANCE) {
                signatureVisitor.writeUnboundedWildcard();
                continue;
            }
            TypeMappingMode argumentMode = TypeMappingUtil.updateArgumentModeFromAnnotations(mode, argument.getType());
            Variance projectionKind = KotlinTypeMapper.getVarianceForWildcard(parameter, argument, argumentMode);
            signatureVisitor.writeTypeArgument(projectionKind);
            this.mapType(argument.getType(), signatureVisitor, argumentMode.toGenericArgumentMode(UtilsKt.getEffectiveVariance(parameter.getVariance(), argument.getProjectionKind())));
            signatureVisitor.writeTypeArgumentEnd();
        }
    }

    private static boolean hasNothingInNonContravariantPosition(KotlinType kotlinType) {
        List<TypeParameterDescriptor> parameters2 = kotlinType.getConstructor().getParameters();
        List<TypeProjection> arguments2 = kotlinType.getArguments();
        for (int i = 0; i < arguments2.size(); ++i) {
            KotlinType type2;
            TypeProjection projection = arguments2.get(i);
            if (projection.isStarProjection() || !KotlinBuiltIns.isNullableNothing(type2 = projection.getType()) && (!KotlinBuiltIns.isNothing(type2) || parameters2.get(i).getVariance() == Variance.IN_VARIANCE)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Variance getVarianceForWildcard(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection projection, @NotNull TypeMappingMode mode) {
        Variance projectionKind = projection.getProjectionKind();
        Variance parameterVariance = parameter.getVariance();
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (mode.getSkipDeclarationSiteWildcards()) {
            return Variance.INVARIANT;
        }
        if (projectionKind == Variance.INVARIANT || projectionKind == parameterVariance) {
            if (mode.getSkipDeclarationSiteWildcardsIfPossible() && !projection.isStarProjection()) {
                if (parameterVariance == Variance.OUT_VARIANCE && TypeMappingUtil.isMostPreciseCovariantArgument(projection.getType())) {
                    return Variance.INVARIANT;
                }
                if (parameterVariance == Variance.IN_VARIANCE && TypeMappingUtil.isMostPreciseContravariantArgument(projection.getType(), parameter)) {
                    return Variance.INVARIANT;
                }
            }
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    private FunctionDescriptor findSuperDeclaration(@NotNull FunctionDescriptor descriptor2, boolean isSuperCall) {
        while (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends FunctionDescriptor> overridden = descriptor2.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor2);
            }
            FunctionDescriptor classCallable = null;
            for (FunctionDescriptor functionDescriptor : overridden) {
                if (DescriptorUtils.isInterface(functionDescriptor.getContainingDeclaration())) continue;
                classCallable = functionDescriptor;
                break;
            }
            if (classCallable != null) {
                descriptor2 = classCallable;
                continue;
            }
            if (isSuperCall && !AnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2) && !DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                return descriptor2;
            }
            descriptor2 = overridden.iterator().next();
        }
        return descriptor2;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall, @Nullable OwnerKind kind) {
        Type receiverParameterType;
        KotlinType extensionReceiverKotlinType;
        Type owner;
        KotlinType returnKotlinType;
        JvmMethodSignature signature;
        int invokeOpcode;
        SimpleType dispatchReceiverKotlinType;
        Type thisClass;
        Type ownerForDefaultImpl;
        FunctionDescriptor baseMethodDescriptor;
        if (descriptor2 instanceof ConstructorDescriptor && kind != OwnerKind.ERASED_INLINE_CLASS) {
            JvmMethodSignature method = this.mapSignatureSkipGeneric(descriptor2.getOriginal());
            Type owner2 = this.mapOwner(descriptor2);
            FunctionDescriptor originalDescriptor = descriptor2.getOriginal();
            String defaultImplDesc = this.mapDefaultMethod(originalDescriptor, OwnerKind.IMPLEMENTATION).getDescriptor();
            return new CallableMethod(owner2, owner2, defaultImplDesc, method, 183, null, null, null, null, null, originalDescriptor.getReturnType(), false, false);
        }
        if (descriptor2 instanceof LocalVariableAccessorDescriptor) {
            ResolvedCall<FunctionDescriptor> delegateAccessorResolvedCall = this.bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (VariableAccessorDescriptor)descriptor2);
            return this.mapToCallableMethod(delegateAccessorResolvedCall.getResultingDescriptor(), false);
        }
        DeclarationDescriptor functionParent = descriptor2.getOriginal().getContainingDeclaration();
        FunctionDescriptor functionDescriptor = this.findSuperDeclaration(descriptor2.getOriginal(), superCall);
        boolean isInterfaceMember = false;
        boolean isDefaultMethodInInterface = false;
        if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = KotlinTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = JvmCodegenUtil.isJvmInterface(declarationOwner);
            boolean currentIsInterface = JvmCodegenUtil.isJvmInterface(currentOwner);
            boolean isInterface = currentIsInterface && originalIsInterface;
            baseMethodDescriptor = KotlinTypeMapper.findBaseDeclaration(functionDescriptor).getOriginal();
            ClassDescriptor ownerForDefault = (ClassDescriptor)baseMethodDescriptor.getContainingDeclaration();
            isDefaultMethodInInterface = JvmCodegenUtil.isJvmInterface(ownerForDefault) && AnnotationUtilKt.hasJvmDefaultAnnotation(baseMethodDescriptor);
            Type type2 = ownerForDefaultImpl = JvmCodegenUtil.isJvmInterface(ownerForDefault) && !AnnotationUtilKt.hasJvmDefaultAnnotation(baseMethodDescriptor) ? this.mapDefaultImpls(ownerForDefault) : this.mapClass(ownerForDefault);
            if (isInterface && (superCall || descriptor2.getVisibility() == Visibilities.PRIVATE || KotlinTypeMapper.isAccessor(descriptor2))) {
                thisClass = this.mapClass(currentOwner);
                dispatchReceiverKotlinType = currentOwner.getDefaultType();
                if (declarationOwner instanceof JavaClassDescriptor || AnnotationUtilKt.hasJvmDefaultAnnotation(declarationFunctionDescriptor)) {
                    invokeOpcode = 183;
                    signature = this.mapSignatureSkipGeneric(functionDescriptor);
                    returnKotlinType = functionDescriptor.getReturnType();
                    owner = thisClass;
                    isInterfaceMember = true;
                } else {
                    invokeOpcode = 184;
                    FunctionDescriptor originalDescriptor = descriptor2.getOriginal();
                    signature = this.mapSignatureSkipGeneric(originalDescriptor, OwnerKind.DEFAULT_IMPLS);
                    returnKotlinType = originalDescriptor.getReturnType();
                    if (descriptor2 instanceof AccessorForCallableDescriptor && AnnotationUtilKt.hasJvmDefaultAnnotation(((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor())) {
                        owner = this.mapClass(currentOwner);
                        isInterfaceMember = true;
                    } else {
                        owner = this.mapDefaultImpls(currentOwner);
                    }
                }
            } else {
                boolean isStaticInvocation;
                boolean toInlinedErasedClass = currentOwner.isInline() && !KotlinTypeMapper.isAccessor(functionDescriptor);
                boolean bl = isStaticInvocation = DescriptorUtils.isStaticDeclaration(functionDescriptor) && !(functionDescriptor instanceof ImportedFromObjectCallableDescriptor) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor) || toInlinedErasedClass;
                if (isStaticInvocation) {
                    invokeOpcode = 184;
                    isInterfaceMember = currentIsInterface && currentOwner instanceof JavaClassDescriptor;
                } else if (isInterface) {
                    invokeOpcode = 185;
                    isInterfaceMember = true;
                } else {
                    boolean isPrivateFunInvocation = Visibilities.isPrivate(functionDescriptor.getVisibility()) && !functionDescriptor.isSuspend();
                    invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
                    isInterfaceMember = superCall && currentIsInterface;
                }
                FunctionDescriptor overriddenSpecialBuiltinFunction = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(functionDescriptor.getOriginal());
                FunctionDescriptor functionToCall = overriddenSpecialBuiltinFunction != null && !superCall && !toInlinedErasedClass ? overriddenSpecialBuiltinFunction.getOriginal() : functionDescriptor.getOriginal();
                signature = toInlinedErasedClass ? this.mapSignatureForInlineErasedClassSkipGeneric(functionToCall) : this.mapSignatureSkipGeneric(functionToCall);
                returnKotlinType = functionToCall.getReturnType();
                ClassDescriptor receiver = currentIsInterface && !originalIsInterface || currentOwner instanceof FunctionClassDescriptor ? declarationOwner : currentOwner;
                thisClass = owner = toInlinedErasedClass ? this.mapErasedInlineClass(receiver) : this.mapClass(receiver);
                dispatchReceiverKotlinType = receiver.getDefaultType();
            }
        } else {
            FunctionDescriptor originalDescriptor = functionDescriptor.getOriginal();
            signature = this.mapSignatureSkipGeneric(originalDescriptor);
            returnKotlinType = originalDescriptor.getReturnType();
            ownerForDefaultImpl = owner = this.mapOwner(functionDescriptor);
            baseMethodDescriptor = functionDescriptor;
            if (functionParent instanceof PackageFragmentDescriptor) {
                invokeOpcode = 184;
                thisClass = null;
                dispatchReceiverKotlinType = null;
            } else if (functionDescriptor instanceof ConstructorDescriptor) {
                invokeOpcode = 183;
                thisClass = null;
                dispatchReceiverKotlinType = null;
            } else {
                invokeOpcode = 182;
                thisClass = owner;
                DeclarationDescriptor ownerDescriptor = functionDescriptor.getContainingDeclaration();
                dispatchReceiverKotlinType = ownerDescriptor instanceof ClassDescriptor ? ((ClassDescriptor)ownerDescriptor).getDefaultType() : null;
            }
        }
        Type calleeType = ExpressionTypingUtils.isLocalFunction(functionDescriptor) ? owner : null;
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getOriginal().getExtensionReceiverParameter();
        if (receiverParameter != null) {
            extensionReceiverKotlinType = receiverParameter.getType();
            receiverParameterType = this.mapType(extensionReceiverKotlinType);
        } else {
            extensionReceiverKotlinType = null;
            receiverParameterType = null;
        }
        String defaultImplDesc = this.mapDefaultMethod(baseMethodDescriptor, KotlinTypeMapper.getKindForDefaultImplCall(baseMethodDescriptor)).getDescriptor();
        return new CallableMethod(owner, ownerForDefaultImpl, defaultImplDesc, signature, invokeOpcode, thisClass, dispatchReceiverKotlinType, receiverParameterType, extensionReceiverKotlinType, calleeType, returnKotlinType, this.isJvm8Target ? isInterfaceMember : invokeOpcode == 185, isDefaultMethodInInterface);
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall) {
        return this.mapToCallableMethod(descriptor2, superCall, null);
    }

    public static boolean isAccessor(@Nullable CallableMemberDescriptor descriptor2) {
        return descriptor2 instanceof AccessorForCallableDescriptor || descriptor2 instanceof AccessorForCompanionObjectInstanceFieldDescriptor;
    }

    public static boolean isStaticAccessor(@Nullable CallableMemberDescriptor descriptor2) {
        if (descriptor2 instanceof AccessorForConstructorDescriptor) {
            return false;
        }
        return KotlinTypeMapper.isAccessor(descriptor2);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return function2;
        }
        return KotlinTypeMapper.findBaseDeclaration(function2);
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2.getOverriddenDescriptors().isEmpty()) {
            return function2;
        }
        return KotlinTypeMapper.findBaseDeclaration(function2.getOverriddenDescriptors().iterator().next());
    }

    @NotNull
    public String mapFunctionName(@NotNull FunctionDescriptor descriptor2, @Nullable OwnerKind kind) {
        String platformName;
        if (!(descriptor2 instanceof JavaCallableMemberDescriptor) && (platformName = DescriptorUtils.getJvmName(descriptor2)) != null) {
            return platformName;
        }
        String nameForSpecialFunction = SpecialBuiltinMembers.getJvmMethodNameIfSpecial(descriptor2);
        if (nameForSpecialFunction != null) {
            return nameForSpecialFunction;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            if (DescriptorUtils.isAnnotationClass(property.getContainingDeclaration())) {
                return property.getName().asString();
            }
            boolean isAccessor = property instanceof AccessorForPropertyDescriptor;
            String propertyName = isAccessor ? ((AccessorForPropertyDescriptor)property).getAccessorSuffix() : property.getName().asString();
            String accessorName = descriptor2 instanceof PropertyGetterDescriptor ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
            return this.mangleMemberNameIfRequired(isAccessor ? "access$" + accessorName : accessorName, descriptor2);
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
            SamType samType;
            PsiElement expression2;
            PsiElement element = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (element instanceof KtFunctionLiteral && (expression2 = element.getParent()) instanceof KtLambdaExpression && (samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, (KtExpression)expression2)) != null) {
                return samType.getOriginalAbstractMethod().getName().asString();
            }
            return OperatorNameConventions.INVOKE.asString();
        }
        if (ExpressionTypingUtils.isLocalFunction(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            return OperatorNameConventions.INVOKE.asString();
        }
        if (OwnerKind.ERASED_INLINE_CLASS == kind && descriptor2 instanceof ConstructorDescriptor) {
            return "constructor";
        }
        return this.mangleMemberNameIfRequired(descriptor2.getName().asString(), descriptor2);
    }

    @NotNull
    private static OwnerKind getKindForDefaultImplCall(@NotNull FunctionDescriptor baseMethodDescriptor) {
        DeclarationDescriptor containingDeclaration = baseMethodDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return OwnerKind.PACKAGE;
        }
        if (DescriptorUtils.isInterface(containingDeclaration)) {
            return OwnerKind.DEFAULT_IMPLS;
        }
        return OwnerKind.IMPLEMENTATION;
    }

    @NotNull
    public static String mapDefaultFieldName(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegated) {
        String name = propertyDescriptor instanceof AccessorForPropertyDescriptor ? ((AccessorForPropertyDescriptor)propertyDescriptor).getCalleeDescriptor().getName().asString() : propertyDescriptor.getName().asString();
        return isDelegated ? name + "$delegate" : name;
    }

    @NotNull
    private String mangleMemberNameIfRequired(@NotNull String name, @NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2.getContainingDeclaration() instanceof ScriptDescriptor) {
            return name;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            String partName;
            if (Visibilities.isPrivate(descriptor2.getVisibility()) && !(descriptor2 instanceof ConstructorDescriptor) && !"<clinit>".equals(name) && (partName = KotlinTypeMapper.getPartSimpleNameForMangling(descriptor2)) != null) {
                return name + "$" + partName;
            }
            return name;
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getVisibility() == Visibilities.INTERNAL && !DescriptorUtilsKt.isPublishedApi(descriptor2)) {
            return InternalNameMapper.mangleInternalName(name, this.moduleName);
        }
        return name;
    }

    @Nullable
    private static String getPartSimpleNameForMangling(@NotNull CallableMemberDescriptor descriptor2) {
        String implShortName;
        KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
        if (containingFile != null) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                return fileClassInfo.getFileClassFqName().shortName().asString();
            }
            return null;
        }
        descriptor2 = DescriptorUtils.getDirectMember(descriptor2);
        assert (descriptor2 instanceof DeserializedCallableMemberDescriptor) : "Descriptor without sources should be instance of DeserializedCallableMemberDescriptor, but: " + descriptor2;
        ContainingClassesInfo containingClassesInfo = KotlinTypeMapper.getContainingClassesForDeserializedCallable((DeserializedCallableMemberDescriptor)descriptor2);
        String facadeShortName = containingClassesInfo.getFacadeClassId().getShortClassName().asString();
        return !facadeShortName.equals(implShortName = containingClassesInfo.getImplClassId().getShortClassName().asString()) ? implShortName : null;
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2) {
        return this.mapSignature(descriptor2).getAsmMethod();
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2, @NotNull OwnerKind kind) {
        return this.mapSignature(descriptor2, kind, true).getAsmMethod();
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f) {
        return this.mapSignature(f, OwnerKind.IMPLEMENTATION, true);
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f) {
        return this.mapSignatureSkipGeneric(f, OwnerKind.IMPLEMENTATION);
    }

    @NotNull
    public JvmMethodSignature mapSignatureForInlineErasedClassSkipGeneric(@NotNull FunctionDescriptor f) {
        return this.mapSignatureSkipGeneric(f, OwnerKind.ERASED_INLINE_CLASS);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureForBoxMethodOfInlineClass(@NotNull FunctionDescriptor f) {
        return this.mapSignature(f, OwnerKind.IMPLEMENTATION, true);
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        return this.mapSignature(f, kind, true);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        return this.mapSignature(f, kind, false);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean hasSpecialBridge) {
        return this.mapSignature(f, kind, false, hasSpecialBridge);
    }

    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean skipGenericSignature) {
        return this.mapSignature(f, kind, skipGenericSignature, false);
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean skipGenericSignature, boolean hasSpecialBridge) {
        if (f.getInitialSignatureDescriptor() != null && f != f.getInitialSignatureDescriptor() && (SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(f) == null || f.getContainingDeclaration().getOriginal() instanceof JavaClassDescriptor)) {
            return this.mapSignature(f.getInitialSignatureDescriptor(), kind, skipGenericSignature);
        }
        if (f instanceof TypeAliasConstructorDescriptor) {
            return this.mapSignature(((TypeAliasConstructorDescriptor)f).getUnderlyingConstructorDescriptor().getOriginal(), kind, skipGenericSignature);
        }
        if (f instanceof FunctionImportedFromObject) {
            return this.mapSignature((FunctionDescriptor)((FunctionImportedFromObject)f).getCallableFromObject(), kind, skipGenericSignature);
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(f)) {
            return this.mapSignature(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(f, this.isReleaseCoroutines), kind, skipGenericSignature);
        }
        if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(f)) {
            KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(f);
            SimpleType arrayOfNullableAny = builtIns.getArrayType(Variance.INVARIANT, builtIns.getNullableAnyType());
            return this.mapSignatureWithCustomParameters(f, kind, Stream.of(arrayOfNullableAny), false, false);
        }
        return this.mapSignatureWithCustomParameters(f, kind, f.getValueParameters().stream().map(ValueDescriptor::getType), skipGenericSignature, hasSpecialBridge);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithCustomParameters(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, @NotNull List<ValueParameterDescriptor> valueParameters2, boolean skipGenericSignature) {
        return this.mapSignatureWithCustomParameters(f, kind, valueParameters2.stream().map(ValueDescriptor::getType), skipGenericSignature, false);
    }

    @NotNull
    private JvmMethodGenericSignature mapSignatureWithCustomParameters(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, @NotNull Stream<KotlinType> valueParameterTypes, boolean skipGenericSignature, boolean hasSpecialBridge) {
        BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo specialSignatureInfo;
        JvmSignatureWriter sw;
        this.checkOwnerCompatibility(f);
        JvmSignatureWriter jvmSignatureWriter = sw = skipGenericSignature || f instanceof AccessorForCallableDescriptor ? new JvmSignatureWriter() : new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        if (f instanceof ClassConstructorDescriptor) {
            sw.writeParametersStart();
            this.writeAdditionalConstructorParameters((ClassConstructorDescriptor)f, sw);
            valueParameterTypes.forEach(type2 -> this.writeParameter(sw, (KotlinType)type2, f));
            if (f instanceof AccessorForConstructorDescriptor) {
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CONSTRUCTOR_MARKER, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER);
            }
            if (OwnerKind.ERASED_INLINE_CLASS == kind) {
                sw.writeReturnType();
                sw.writeAsmType(this.mapType(((ClassConstructorDescriptor)f).getContainingDeclaration()));
                sw.writeReturnTypeEnd();
            } else {
                KotlinTypeMapper.writeVoidReturn(sw);
            }
        } else {
            ReceiverParameterDescriptor receiverParameter;
            CallableMemberDescriptor directMember = DescriptorUtils.getDirectMember(f);
            KotlinType thisIfNeeded = null;
            if (OwnerKind.DEFAULT_IMPLS == kind) {
                ReceiverTypeAndTypeParameters receiverTypeAndTypeParameters = TypeMapperUtilsKt.patchTypeParametersForDefaultImplMethod(directMember);
                this.writeFormalTypeParameters(CollectionsKt.plus(receiverTypeAndTypeParameters.getTypeParameters(), directMember.getTypeParameters()), sw);
                thisIfNeeded = receiverTypeAndTypeParameters.getReceiverType();
            } else if (OwnerKind.ERASED_INLINE_CLASS == kind) {
                ClassDescriptor classDescriptor = (ClassDescriptor)directMember.getContainingDeclaration();
                thisIfNeeded = classDescriptor.getDefaultType();
            } else {
                this.writeFormalTypeParameters(directMember.getTypeParameters(), sw);
                if (KotlinTypeMapper.isAccessor(f) && f.getDispatchReceiverParameter() != null) {
                    thisIfNeeded = ((ClassDescriptor)f.getContainingDeclaration()).getDefaultType();
                }
            }
            sw.writeParametersStart();
            if (thisIfNeeded != null) {
                this.writeParameter(sw, JvmMethodParameterKind.THIS, thisIfNeeded, f);
            }
            if ((receiverParameter = f.getExtensionReceiverParameter()) != null) {
                this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType(), f);
            }
            valueParameterTypes.forEach(type2 -> {
                boolean forceBoxing = MethodSignatureMappingKt.forceSingleValueParameterBoxing(f);
                this.writeParameter(sw, forceBoxing ? TypeUtils.makeNullable(type2) : type2, f);
            });
            sw.writeReturnType();
            this.mapReturnType(f, sw);
            sw.writeReturnTypeEnd();
        }
        JvmMethodGenericSignature signature = sw.makeJvmMethodSignature(this.mapFunctionName(f, kind));
        if (kind != OwnerKind.DEFAULT_IMPLS && kind != OwnerKind.ERASED_INLINE_CLASS && !hasSpecialBridge && (specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(f)) != null) {
            String newGenericSignature = CodegenUtilKt.replaceValueParametersIn(specialSignatureInfo, signature.getGenericsSignature());
            return new JvmMethodGenericSignature(signature.getAsmMethod(), signature.getValueParameters(), newGenericSignature);
        }
        return signature;
    }

    private void checkOwnerCompatibility(@NotNull FunctionDescriptor descriptor2) {
        KotlinJvmBinaryClass ownerClass = KotlinJvmBinaryClassUtilKt.getContainingKotlinJvmBinaryClass(descriptor2);
        if (ownerClass == null) {
            return;
        }
        JvmBytecodeBinaryVersion version = ownerClass.getClassHeader().getBytecodeVersion();
        if (!version.isCompatible()) {
            this.incompatibleClassTracker.record(ownerClass);
        }
    }

    @NotNull
    private static String getDefaultDescriptor(@NotNull Method method, @Nullable String dispatchReceiverDescriptor, @NotNull CallableDescriptor callableDescriptor) {
        String descriptor2 = method.getDescriptor();
        int maskArgumentsCount = (callableDescriptor.getValueParameters().size() + 32 - 1) / 32;
        String additionalArgs = StringUtil.repeat(Type.INT_TYPE.getDescriptor(), maskArgumentsCount);
        additionalArgs = additionalArgs + (KotlinTypeMapper.isConstructor(method) ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE).getDescriptor();
        String result2 = descriptor2.replace(")", additionalArgs + ")");
        if (dispatchReceiverDescriptor != null && !KotlinTypeMapper.isConstructor(method)) {
            return result2.replace("(", "(" + dispatchReceiverDescriptor);
        }
        return result2;
    }

    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    private static boolean isConstructor(@NotNull Method method) {
        return "<init>".equals(method.getName());
    }

    @NotNull
    public Method mapDefaultMethod(@NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind) {
        Method jvmSignature = this.mapAsmMethod(functionDescriptor, kind);
        Type ownerType = this.mapOwner(functionDescriptor);
        boolean isConstructor = KotlinTypeMapper.isConstructor(jvmSignature);
        String descriptor2 = KotlinTypeMapper.getDefaultDescriptor(jvmSignature, AsmUtil.isStaticMethod(kind, functionDescriptor) || isConstructor ? null : ownerType.getDescriptor(), CodegenUtilKt.unwrapFrontendVersion(functionDescriptor));
        return new Method(isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor2);
    }

    private static boolean forceBoxedReturnType(@NotNull FunctionDescriptor descriptor2) {
        if (KotlinTypeMapper.isBoxMethodForInlineClass(descriptor2)) {
            return true;
        }
        if (!KotlinBuiltIns.isPrimitiveType(descriptor2.getReturnType())) {
            return false;
        }
        for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(descriptor2)) {
            if (KotlinBuiltIns.isPrimitiveType(overridden.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoxMethodForInlineClass(@NotNull FunctionDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
            return false;
        }
        return CallableMemberDescriptor.Kind.SYNTHESIZED == descriptor2.getKind() && InlineClassDescriptorResolver.BOX_METHOD_NAME.equals(descriptor2.getName());
    }

    private static void writeVoidReturn(@NotNull JvmSignatureWriter sw) {
        sw.writeReturnType();
        sw.writeAsmType(Type.VOID_TYPE);
        sw.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull KotlinType backingFieldType, @NotNull PropertyDescriptor propertyDescriptor) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        if (!propertyDescriptor.isVar()) {
            this.mapReturnType(propertyDescriptor, sw, backingFieldType);
        } else {
            this.writeParameterType(sw, backingFieldType, propertyDescriptor);
        }
        return ((JvmSignatureWriter)sw).makeJavaGenericSignature();
    }

    public void writeFormalTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters2, @NotNull JvmSignatureWriter sw) {
        if (sw.skipGenericSignature()) {
            return;
        }
        for (TypeParameterDescriptor typeParameter : typeParameters2) {
            this.writeFormalTypeParameter(typeParameter, sw);
        }
    }

    private void writeFormalTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull JvmSignatureWriter sw) {
        if (!this.classBuilderMode.generateBodies && typeParameterDescriptor.getName().isSpecial()) {
            return;
        }
        sw.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        sw.writeClassBound();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || JvmCodegenUtil.isJvmInterface(jetType)) continue;
            this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
            break;
        }
        sw.writeClassBoundEnd();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            ClassifierDescriptor classifier2 = jetType.getConstructor().getDeclarationDescriptor();
            if (classifier2 instanceof ClassDescriptor) {
                if (!JvmCodegenUtil.isJvmInterface(jetType)) continue;
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            if (classifier2 instanceof TypeParameterDescriptor) {
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unknown classifier: " + classifier2);
        }
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        this.writeParameter(sw, JvmMethodParameterKind.VALUE, type2, callableDescriptor);
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        sw.writeParameterType(kind);
        this.writeParameterType(sw, type2, callableDescriptor);
        sw.writeParameterTypeEnd();
    }

    private void writeParameterType(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw.skipGenericSignature()) {
            this.mapType(type2, sw, TypeMappingMode.DEFAULT);
            return;
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(callableDescriptor, type2, false);
        TypeMappingMode typeMappingMode = typeMappingModeFromAnnotation != null ? typeMappingModeFromAnnotation : (TypeMappingUtil.isMethodWithDeclarationSiteWildcards(callableDescriptor) && !type2.getArguments().isEmpty() ? TypeMappingMode.GENERIC_ARGUMENT : TypeMappingMode.getOptimalModeForValueParameter(type2));
        this.mapType(type2, sw, typeMappingMode);
    }

    private static void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull Type type2) {
        sw.writeParameterType(kind);
        sw.writeAsmType(type2);
        sw.writeParameterTypeEnd();
    }

    private void writeAdditionalConstructorParameters(@NotNull ClassConstructorDescriptor descriptor2, @NotNull JvmSignatureWriter sw) {
        KotlinType captureReceiverType;
        boolean isSynthesized = descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, descriptor2.getContainingDeclaration());
        ClassDescriptor captureThis = JvmCodegenUtil.getDispatchReceiverParameterForConstructorCall(descriptor2, closure);
        if (!isSynthesized && captureThis != null) {
            this.writeParameter(sw, JvmMethodParameterKind.OUTER, captureThis.getDefaultType(), descriptor2);
        }
        KotlinType kotlinType = captureReceiverType = closure != null ? closure.getCaptureReceiverType() : null;
        if (captureReceiverType != null) {
            this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, captureReceiverType, descriptor2);
        }
        ClassDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(isSynthesized || containingDeclaration.getKind() != ClassKind.ENUM_CLASS && containingDeclaration.getKind() != ClassKind.ENUM_ENTRY)) {
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getStringType(), descriptor2);
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getIntType(), descriptor2);
        }
        if (closure == null) {
            return;
        }
        for (DeclarationDescriptor variableDescriptor : closure.getCaptureVariables().keySet()) {
            Type type2;
            if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.getSharedVarType(variableDescriptor);
                if (sharedVarType == null) {
                    if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType((LocalVariableDescriptor)variableDescriptor, this.bindingContext);
                        assert (delegateType != null) : "Local delegated property type should not be null: " + variableDescriptor;
                        sharedVarType = this.mapType(delegateType);
                    } else {
                        sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                    }
                }
                type2 = sharedVarType;
            } else {
                type2 = ExpressionTypingUtils.isLocalFunction(variableDescriptor) ? CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor) : null;
            }
            if (type2 == null) continue;
            closure.setCapturedParameterOffsetInConstructor(variableDescriptor, sw.getCurrentSignatureSize() + 1);
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE, type2);
        }
        if (this.classBuilderMode.generateBodies) {
            ResolvedCall<ConstructorDescriptor> superCall = this.findFirstDelegatingSuperCall(descriptor2);
            if (superCall == null) {
                return;
            }
            this.writeSuperConstructorCallParameters(sw, descriptor2, superCall, captureThis != null);
        }
    }

    private void writeSuperConstructorCallParameters(@NotNull JvmSignatureWriter sw, @NotNull ClassConstructorDescriptor descriptor2, @NotNull ResolvedCall<ConstructorDescriptor> superCall, boolean hasOuter) {
        ConstructorDescriptor superDescriptor = (ConstructorDescriptor)SamCodegenUtil.resolveSamAdapter((FunctionDescriptor)superCall.getResultingDescriptor());
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = superCall.getValueArguments();
        List<JvmMethodParameterSignature> parameters2 = this.mapSignatureSkipGeneric(superDescriptor.getOriginal()).getValueParameters();
        int params = parameters2.size();
        int args = valueArguments.size();
        assert (params >= args) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", params, args, descriptor2);
        for (int i = 0; i < params - args; ++i) {
            JvmMethodParameterSignature parameter = parameters2.get(i);
            JvmMethodParameterKind kind = parameter.getKind();
            if (kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || hasOuter && kind == JvmMethodParameterKind.OUTER) continue;
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
        }
        if (DescriptorUtils.isAnonymousObject(descriptor2.getContainingDeclaration())) {
            for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> argumentAndValue : valueArguments.entrySet()) {
                ResolvedValueArgument valueArgument = argumentAndValue.getValue();
                if (valueArgument instanceof DefaultValueArgument) continue;
                JvmMethodParameterSignature parameter = parameters2.get(params - args + argumentAndValue.getKey().getIndex());
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
            }
        }
    }

    @Nullable
    private ResolvedCall<ConstructorDescriptor> findFirstDelegatingSuperCall(@NotNull ConstructorDescriptor descriptor2) {
        ResolvedCall<ConstructorDescriptor> next;
        ClassifierDescriptorWithTypeParameters constructorOwner = descriptor2.getContainingDeclaration();
        do {
            if ((next = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, descriptor2)) != null) continue;
            return null;
        } while ((descriptor2 = next.getResultingDescriptor().getOriginal()).getContainingDeclaration() == constructorOwner);
        return next;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeParametersStart();
        if (importedScripts.size() > 0) {
            this.writeParameter(sw, DescriptorUtilsKt.getModule(script).getBuiltIns().getArray().getDefaultType(), null);
        }
        for (ValueParameterDescriptor valueParameter : script.getUnsubstitutedPrimaryConstructor().getValueParameters()) {
            this.writeParameter(sw, valueParameter.getType(), null);
        }
        KotlinTypeMapper.writeVoidReturn(sw);
        return sw.makeJvmMethodSignature("<init>");
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor || descriptor2 instanceof FunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "Callable should have a receiver parameter: " + descriptor2;
            return StackValue.sharedTypeForType(this.mapType(receiverParameter.getType()));
        }
        if (descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated()) {
            return null;
        }
        if (descriptor2 instanceof VariableDescriptor && BindingContextUtils.isVarCapturedInClosure(this.bindingContext, descriptor2)) {
            return StackValue.sharedTypeForType(this.mapType(((VariableDescriptor)descriptor2).getType()));
        }
        return null;
    }

    @NotNull
    public String classInternalName(@NotNull ClassDescriptor classDescriptor) {
        Type recordedType = this.typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
        if (recordedType != null) {
            return recordedType.getInternalName();
        }
        return TypeSignatureMappingKt.computeInternalName(classDescriptor, this.typeMappingConfiguration, this.isIrBackend);
    }

    public static class InternalNameMapper {
        public static String mangleInternalName(@NotNull String name, @NotNull String moduleName) {
            return name + "$" + NameUtils.sanitizeAsJavaIdentifier(moduleName);
        }

        public static boolean canBeMangledInternalName(@NotNull String name) {
            return name.indexOf(36) != -1;
        }

        @Nullable
        public static String demangleInternalName(@NotNull String name) {
            int indexOfDollar = name.indexOf(36);
            return indexOfDollar >= 0 ? name.substring(0, indexOfDollar) : null;
        }

        @Nullable
        public static String getModuleNameSuffix(@NotNull String name) {
            int indexOfDollar = name.indexOf(36);
            return indexOfDollar >= 0 ? name.substring(indexOfDollar + 1) : null;
        }

        @Nullable
        public static String internalNameWithoutModuleSuffix(@NotNull String name) {
            String demangledName = InternalNameMapper.demangleInternalName(name);
            return demangledName != null ? demangledName + '$' : null;
        }
    }

    public static class ContainingClassesInfo {
        private final ClassId facadeClassId;
        private final ClassId implClassId;

        public ContainingClassesInfo(@NotNull ClassId facadeClassId, @NotNull ClassId implClassId) {
            this.facadeClassId = facadeClassId;
            this.implClassId = implClassId;
        }

        @NotNull
        public ClassId getFacadeClassId() {
            return this.facadeClassId;
        }

        @NotNull
        public ClassId getImplClassId() {
            return this.implClassId;
        }

        @NotNull
        private static ContainingClassesInfo forPackageMember(@NotNull JvmClassName facadeName, @NotNull JvmClassName partName) {
            return new ContainingClassesInfo(ClassId.topLevel(facadeName.getFqNameForTopLevelClassMaybeWithDollars()), ClassId.topLevel(partName.getFqNameForTopLevelClassMaybeWithDollars()));
        }

        @NotNull
        private static ContainingClassesInfo forClassMember(@NotNull ClassId classId) {
            return new ContainingClassesInfo(classId, classId);
        }
    }
}

