/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.WrappedType;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;

public class DeferredType
extends WrappedType {
    private static final Function1<Boolean, KotlinType> RECURSION_PREVENTER = firstTime -> {
        if (firstTime.booleanValue()) {
            throw new ReenteringLazyValueComputationException();
        }
        return ErrorUtils.createErrorType("Recursive dependency");
    };
    private final NotNullLazyValue<KotlinType> lazyValue;

    @NotNull
    static DeferredType create(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<KotlinType> compute) {
        DeferredType deferredType = new DeferredType(storageManager.createLazyValue(compute));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        return deferredType;
    }

    @NotNull
    static DeferredType createRecursionIntolerant(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<KotlinType> compute) {
        DeferredType deferredType = new DeferredType(storageManager.createLazyValueWithPostCompute(compute, RECURSION_PREVENTER, t -> null));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        return deferredType;
    }

    private DeferredType(@NotNull NotNullLazyValue<KotlinType> lazyValue) {
        this.lazyValue = lazyValue;
    }

    public boolean isComputing() {
        return this.lazyValue.isComputing();
    }

    @Override
    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    @Override
    @NotNull
    public KotlinType getDelegate() {
        return (KotlinType)this.lazyValue.invoke();
    }

    @Override
    @NotNull
    public String toString() {
        try {
            if (this.lazyValue.isComputed()) {
                return this.getDelegate().toString();
            }
            return "<Not computed yet>";
        }
        catch (ReenteringLazyValueComputationException e) {
            return "<Failed to compute this type>";
        }
    }
}

