/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020 \u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a \u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020 \"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"constructedClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getConstructedClass", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isAny", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)Z", "isReified", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;)Z", "propertyIfAccessor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getPropertyIfAccessor", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "createValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "index", "", "name", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "getFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "backend.js"})
public final class DescriptorBasedUtilsKt {
    @NotNull
    public static final ClassDescriptor getConstructedClass(@NotNull IrConstructorSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ((ClassConstructorDescriptor)$receiver.getDescriptor()).getConstructedClass();
    }

    public static final boolean isAny(@NotNull IrClassSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBuiltIns.isAny((ClassDescriptor)$receiver.getDescriptor());
    }

    @NotNull
    public static final List<FunctionDescriptor> getFunctions(@NotNull ModuleDescriptor $receiver, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName.parent()");
        Name name = fqName2.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"fqName.shortName()");
        return DescriptorBasedUtilsKt.getFunctions($receiver, fqName3, name);
    }

    @NotNull
    public static final List<FunctionDescriptor> getFunctions(@NotNull ModuleDescriptor $receiver, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return CollectionsKt.toList((Iterable)$receiver.getPackage(packageFqName).getMemberScope().getContributedFunctions(name, NoLookupLocation.FROM_BACKEND));
    }

    @Nullable
    public static final ClassifierDescriptor getClassifier(@NotNull ModuleDescriptor $receiver, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName.parent()");
        Name name = fqName2.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"fqName.shortName()");
        return DescriptorBasedUtilsKt.getClassifier($receiver, fqName3, name);
    }

    @Nullable
    public static final ClassifierDescriptor getClassifier(@NotNull ModuleDescriptor $receiver, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $receiver.getPackage(packageFqName).getMemberScope().getContributedClassifier(name, NoLookupLocation.FROM_BACKEND);
    }

    @NotNull
    public static final ValueParameterDescriptor createValueParameter(@NotNull CallableDescriptor containingDeclaration, int index2, @NotNull String name, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)containingDeclaration, (String)"containingDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        Name name2 = Name.identifier(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(name)");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
        return new ValueParameterDescriptorImpl(containingDeclaration, null, index2, annotations2, name2, type2, false, false, false, null, sourceElement);
    }

    @NotNull
    public static final CallableMemberDescriptor getPropertyIfAccessor(@NotNull CallableMemberDescriptor $receiver) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"this.correspondingProperty");
            callableMemberDescriptor = propertyDescriptor;
        } else {
            callableMemberDescriptor = $receiver;
        }
        return callableMemberDescriptor;
    }

    public static final boolean isReified(@NotNull IrTypeParameter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDescriptor().isReified();
    }
}

