/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.LanguageFeatureMessageRenderer$WhenMappings;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000fB\u0019\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "type", "Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "useHtml", "", "(Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;Z)V", "render", "", "obj", "renderingContext", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "Type", "frontend"})
public final class LanguageFeatureMessageRenderer
implements DiagnosticParameterRenderer<Pair<? extends LanguageFeature, ? extends LanguageVersionSettings>> {
    private final Type type;
    private final boolean useHtml;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String render(@NotNull Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> obj, @NotNull RenderingContext renderingContext) {
        void feature;
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)renderingContext, (String)"renderingContext");
        Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> pair = obj;
        LanguageFeature languageFeature = (LanguageFeature)((Object)pair.component1());
        LanguageVersionSettings settings2 = (LanguageVersionSettings)pair.component2();
        LanguageVersion since = feature.getSinceVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("The feature \"").append(feature.getPresentableName()).append("\" is ");
        switch (LanguageFeatureMessageRenderer$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                if (since == null) {
                    sb.append("experimental and should be enabled explicitly");
                    break;
                }
                if (since.compareTo((Enum)settings2.getLanguageVersion()) > 0) {
                    sb.append("only available since language version ").append(since.getVersionString());
                    break;
                }
                if (feature.getSinceApiVersion().compareTo(settings2.getApiVersion()) > 0) {
                    sb.append("only available since API version ").append(feature.getSinceApiVersion().getVersionString());
                    break;
                }
                sb.append("disabled");
                break;
            }
            case 2: {
                sb.append("experimental");
                break;
            }
            case 3: {
                sb.append("experimental and disabled");
            }
        }
        String hintUrl = feature.getHintUrl();
        if (hintUrl != null) {
            if (this.useHtml) {
                sb.append(" (").append("see more <a href=\"").append(hintUrl).append("\">here</a>)");
            } else {
                sb.append(" (see: ").append(hintUrl).append(")");
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type2, boolean useHtml) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        this.type = type2;
        this.useHtml = useHtml;
    }

    @JvmOverloads
    public /* synthetic */ LanguageFeatureMessageRenderer(Type type2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(type2, bl);
    }

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type2) {
        this(type2, false, 2, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "", "(Ljava/lang/String;I)V", "UNSUPPORTED", "WARNING", "ERROR", "frontend"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNSUPPORTED;
        public static final /* enum */ Type WARNING;
        public static final /* enum */ Type ERROR;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = UNSUPPORTED = new Type();
            typeArray[1] = WARNING = new Type();
            typeArray[2] = ERROR = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

