/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    public InvalidVirtualFileAccessException(@NotNull VirtualFile file2) {
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(0);
        }
        super(InvalidVirtualFileAccessException.composeMessage(file2));
    }

    private static String composeMessage(@NotNull VirtualFile file2) {
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(2);
        }
        String url = file2.getUrl();
        String message = "Accessing invalid virtual file: " + url;
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message = message + "; original:" + InvalidVirtualFileAccessException.hashCode(file2) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
            if (file2.isInLocalFileSystem()) {
                boolean physicalExists = new File(file2.getPath()).exists();
                message = message + "; File.exists()=" + physicalExists;
            } else {
                message = message + "; file system=" + file2.getFileSystem();
            }
        }
        catch (Throwable t) {
            message = message + "; lookup failed: " + t.getMessage();
        }
        return message;
    }

    private static String hashCode(Object o) {
        return o == null ? "-" : String.valueOf(o.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/InvalidVirtualFileAccessException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "composeMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

