/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Overrides$WhenMappings;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "ClassifierUsage", "Companion", "Experimentality", "Overrides", "frontend"})
public final class ExperimentalUsageChecker
implements CallChecker {
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final FqName EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final FqName USE_EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final FqName WAS_EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final Name USE_EXPERIMENTAL_ANNOTATION_CLASS;
    @NotNull
    private static final Name WAS_EXPERIMENTAL_ANNOTATION_CLASS;
    private static final Name LEVEL;
    private static final Name WARNING_LEVEL;
    private static final Name ERROR_LEVEL;
    private static final Name EXPERIMENTAL_SHORT_NAME;
    private static final Name USE_EXPERIMENTAL_SHORT_NAME;
    public static final Companion Companion;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        Set experimentalities = ExperimentalUsageChecker.Companion.loadExperimentalities((DeclarationDescriptor)obj, this.moduleAnnotationsResolver, context.getLanguageVersionSettings());
        ExperimentalUsageChecker.Companion.reportNotAcceptedExperimentalities(experimentalities, reportOn, context);
    }

    public ExperimentalUsageChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    static {
        Companion = new Companion(null);
        EXPERIMENTAL_FQ_NAME = new FqName("kotlin.Experimental");
        USE_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.UseExperimental");
        WAS_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.WasExperimental");
        USE_EXPERIMENTAL_ANNOTATION_CLASS = Name.identifier("markerClass");
        WAS_EXPERIMENTAL_ANNOTATION_CLASS = Name.identifier("markerClass");
        LEVEL = Name.identifier("level");
        WARNING_LEVEL = Name.identifier("WARNING");
        ERROR_LEVEL = Name.identifier("ERROR");
        EXPERIMENTAL_SHORT_NAME = EXPERIMENTAL_FQ_NAME.shortName();
        USE_EXPERIMENTAL_SHORT_NAME = USE_EXPERIMENTAL_FQ_NAME.shortName();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "severity", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;)V", "getAnnotationFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getSeverity", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "Severity", "frontend"})
    public static final class Experimentality {
        @NotNull
        private final FqName annotationFqName;
        @NotNull
        private final Severity severity;
        @NotNull
        private static final Severity DEFAULT_SEVERITY;
        public static final Companion Companion;

        @NotNull
        public final FqName getAnnotationFqName() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        public Experimentality(@NotNull FqName annotationFqName, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            this.annotationFqName = annotationFqName;
            this.severity = severity;
        }

        static {
            Companion = new Companion(null);
            DEFAULT_SEVERITY = Severity.ERROR;
        }

        @NotNull
        public final FqName component1() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @NotNull
        public final Experimentality copy(@NotNull FqName annotationFqName, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            return new Experimentality(annotationFqName, severity);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Experimentality copy$default(Experimentality experimentality, FqName fqName2, Severity severity, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = experimentality.annotationFqName;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            return experimentality.copy(fqName2, severity);
        }

        public String toString() {
            return "Experimentality(annotationFqName=" + this.annotationFqName + ", severity=" + (Object)((Object)this.severity) + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.annotationFqName;
            Severity severity = this.severity;
            return (fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (severity != null ? ((Object)((Object)severity)).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Experimentality)) break block3;
                    Experimentality experimentality = (Experimentality)object;
                    if (!Intrinsics.areEqual((Object)this.annotationFqName, (Object)experimentality.annotationFqName) || !Intrinsics.areEqual((Object)((Object)this.severity), (Object)((Object)experimentality.severity))) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "frontend"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING;
            public static final /* enum */ Severity ERROR;
            private static final /* synthetic */ Severity[] $VALUES;

            static {
                Severity[] severityArray = new Severity[2];
                Severity[] severityArray2 = severityArray;
                severityArray[0] = WARNING = new Severity();
                severityArray[1] = ERROR = new Severity();
                $VALUES = severityArray;
            }

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String string) {
                return Enum.valueOf(Severity.class, string);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Companion;", "", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "frontend"})
        public static final class Companion {
            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0002J\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinExperimentalOrUseExperimental", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsQualifier", "", "isUsageAsUseExperimentalArgument", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            ClassDescriptor targetClass;
            FqNameUnsafe fqName2;
            Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Name name = targetDescriptor.getName();
            if ((Intrinsics.areEqual((Object)name, (Object)EXPERIMENTAL_SHORT_NAME) || Intrinsics.areEqual((Object)name, (Object)USE_EXPERIMENTAL_SHORT_NAME)) && (Intrinsics.areEqual((Object)(fqName2 = DescriptorUtilsKt.getFqNameUnsafe(targetDescriptor)), (Object)Companion.getEXPERIMENTAL_FQ_NAME().toUnsafe()) || Intrinsics.areEqual((Object)fqName2, (Object)Companion.getUSE_EXPERIMENTAL_FQ_NAME$frontend().toUnsafe()))) {
                this.checkUsageOfKotlinExperimentalOrUseExperimental(element, context);
                return;
            }
            Set experimentalities = Companion.loadExperimentalities(targetDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings());
            Companion.reportNotAcceptedExperimentalities(experimentalities, element, context);
            ClassifierDescriptor classifierDescriptor = targetDescriptor;
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)targetDescriptor : (targetClass = classifierDescriptor instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
            if (targetClass != null && Companion.loadExperimentalityForMarkerAnnotation$frontend(targetClass) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element)) {
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
                if (!this.isUsageAsUseExperimentalArgument(element, bindingContext)) {
                    context.getTrace().report(Errors.EXPERIMENTAL_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_USE_EXPERIMENTAL.on(element));
                }
            }
        }

        private final void checkUsageOfKotlinExperimentalOrUseExperimental(PsiElement element, CheckerContext context) {
            if (!context.getLanguageVersionSettings().getFlag(AnalysisFlag.Flags.getUseExperimental()).contains(Companion.getEXPERIMENTAL_FQ_NAME().asString())) {
                context.getTrace().report(Errors.EXPERIMENTAL_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context.getTrace().report(Errors.EXPERIMENTAL_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(@NotNull PsiElement $receiver) {
            if ($receiver instanceof KtSimpleNameExpression) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$receiver);
                KtExpression qualifier = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$receiver;
                PsiElement psiElement = qualifier.getParent();
                if (!(psiElement instanceof KtDotQualifiedExpression)) {
                    psiElement = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
                if (Intrinsics.areEqual((Object)(ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null), (Object)qualifier)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsUseExperimentalArgument(@NotNull PsiElement $receiver, BindingContext bindingContext) {
            PsiElement psiElement;
            if (!($receiver.getParent() instanceof KtClassLiteralExpression)) return false;
            PsiElement psiElement2 = $receiver.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent");
            if (!(psiElement2.getParent() instanceof KtValueArgument)) return false;
            PsiElement psiElement3 = $receiver.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"parent");
            PsiElement psiElement4 = psiElement3.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"parent.parent");
            if (!(psiElement4.getParent() instanceof KtValueArgumentList)) return false;
            PsiElement psiElement5 = $receiver.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"parent");
            PsiElement psiElement6 = psiElement5.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"parent.parent");
            PsiElement psiElement7 = psiElement6.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement7, (String)"parent.parent.parent");
            PsiElement entry = psiElement = psiElement7.getParent();
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) return false;
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            AnnotationDescriptor annotation2 = annotationDescriptor2;
            if (Intrinsics.areEqual((Object)annotation2.getFqName(), (Object)Companion.getUSE_EXPERIMENTAL_FQ_NAME$frontend())) return true;
            if (!Intrinsics.areEqual((Object)annotation2.getFqName(), (Object)Companion.getWAS_EXPERIMENTAL_FQ_NAME$frontend())) return false;
            return true;
        }

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class Overrides
    implements DeclarationChecker {
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
            Iterable entry = collection;
            Iterable iterable = entry;
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                void $receiver$iv2;
                CallableMemberDescriptor member;
                CallableMemberDescriptor callableMemberDescriptor = member = (CallableMemberDescriptor)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
                Iterable iterable2 = Companion.loadExperimentalities(callableMemberDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings());
                void var12_13 = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void experimentality;
                    Experimentality experimentality2 = (Experimentality)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    Pair pair = TuplesKt.to((Object)experimentality, (Object)member);
                    collection2.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map experimentalOverridden = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            destination$iv$iv = experimentalOverridden;
            for (Map.Entry entry2 : destination$iv$iv.entrySet()) {
                PsiElement psiElement;
                DiagnosticFactory2<PsiElement, FqName, DeclarationDescriptor> diagnosticFactory2;
                Object element$iv$iv;
                element$iv$iv = entry2;
                Experimentality experimentality = (Experimentality)element$iv$iv.getKey();
                element$iv$iv = entry2;
                CallableMemberDescriptor member = (CallableMemberDescriptor)element$iv$iv.getValue();
                if (Companion.isExperimentalityAccepted(declaration, experimentality.getAnnotationFqName(), context)) continue;
                switch (ExperimentalUsageChecker$Overrides$WhenMappings.$EnumSwitchMapping$0[experimentality.getSeverity().ordinal()]) {
                    case 1: {
                        diagnosticFactory2 = Errors.EXPERIMENTAL_OVERRIDE;
                        break;
                    }
                    case 2: {
                        diagnosticFactory2 = Errors.EXPERIMENTAL_OVERRIDE_ERROR;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                DiagnosticFactory2<PsiElement, FqName, DeclarationDescriptor> diagnostic = diagnosticFactory2;
                KtDeclaration ktDeclaration = declaration;
                if (!(ktDeclaration instanceof KtNamedDeclaration)) {
                    ktDeclaration = null;
                }
                if ((psiElement = (KtNamedDeclaration)ktDeclaration) == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                    psiElement = declaration;
                }
                PsiElement reportOn = psiElement;
                BindingTrace bindingTrace = context.getTrace();
                FqName fqName2 = experimentality.getAnnotationFqName();
                CallableMemberDescriptor callableMemberDescriptor = member;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
                bindingTrace.report(diagnostic.on(reportOn, fqName2, callableMemberDescriptor.getContainingDeclaration()));
            }
        }

        public Overrides(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170\u001dJ&\u0010 \u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J0\u0010(\u001a\u00020)*\u00020%2!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b($\u0012\u0004\u0012\u00020)0\u001dH\u0082\bJ\u001c\u0010-\u001a\u00020)*\u00020%2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0002J\u001c\u00101\u001a\u00020)*\u00020%2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0002J\"\u00102\u001a\u00020)*\u00020%2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200J\u001c\u00102\u001a\u00020)*\u00020%2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0002J\"\u00103\u001a\b\u0012\u0004\u0012\u00020#04*\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0013\u00108\u001a\u0004\u0018\u00010#*\u000209H\u0000\u00a2\u0006\u0002\b:R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Companion;", "", "()V", "ERROR_LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "EXPERIMENTAL_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getEXPERIMENTAL_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "EXPERIMENTAL_SHORT_NAME", "LEVEL", "USE_EXPERIMENTAL_ANNOTATION_CLASS", "getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "()Lorg/jetbrains/kotlin/name/Name;", "USE_EXPERIMENTAL_FQ_NAME", "getUSE_EXPERIMENTAL_FQ_NAME$frontend", "USE_EXPERIMENTAL_SHORT_NAME", "WARNING_LEVEL", "WAS_EXPERIMENTAL_ANNOTATION_CLASS", "getWAS_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "WAS_EXPERIMENTAL_FQ_NAME", "getWAS_EXPERIMENTAL_FQ_NAME$frontend", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "reportNotAcceptedExperimentalities", "experimentalities", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "anyParentMatches", "", "predicate", "Lkotlin/ParameterName;", "name", "isDeclarationAnnotatedWith", "annotationFqName", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isElementAnnotatedWithUseExperimentalOf", "isExperimentalityAccepted", "loadExperimentalities", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadExperimentalityForMarkerAnnotation$frontend", "frontend"})
    public static final class Companion {
        @NotNull
        public final FqName getEXPERIMENTAL_FQ_NAME() {
            return EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getUSE_EXPERIMENTAL_FQ_NAME$frontend() {
            return USE_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getWAS_EXPERIMENTAL_FQ_NAME$frontend() {
            return WAS_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final Name getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return USE_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        @NotNull
        public final Name getWAS_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return WAS_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        private final void reportNotAcceptedExperimentalities(Collection<Experimentality> experimentalities, PsiElement element, CheckerContext context) {
            for (Experimentality experimentality : experimentalities) {
                DiagnosticFactory1<PsiElement, FqName> diagnosticFactory1;
                FqName annotationFqName = experimentality.component1();
                Experimentality.Severity severity = experimentality.component2();
                if (this.isExperimentalityAccepted(element, annotationFqName, context)) continue;
                switch (ExperimentalUsageChecker$Companion$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        diagnosticFactory1 = Errors.EXPERIMENTAL_API_USAGE;
                        break;
                    }
                    case 2: {
                        diagnosticFactory1 = Errors.EXPERIMENTAL_API_USAGE_ERROR;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                DiagnosticFactory1<PsiElement, FqName> diagnostic = diagnosticFactory1;
                context.getTrace().report(diagnostic.on(element, annotationFqName));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Experimentality> loadExperimentalities(@NotNull DeclarationDescriptor $receiver, ModuleAnnotationsResolver moduleAnnotationsResolver, LanguageVersionSettings languageVersionSettings) {
            DeclarationDescriptor container2;
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block8: {
                result2 = SmartSet.Companion.create();
                for (AnnotationDescriptor annotation2 : $receiver.getAnnotations()) {
                    ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotation2);
                    CollectionsKt.addIfNotNull(result2, classDescriptor != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor) : null);
                }
                Iterable $receiver$iv = $receiver.getAnnotations();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)Companion.getWAS_EXPERIMENTAL_FQ_NAME$frontend())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($receiver, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                Collection<Experimentality> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                element$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    ClassDescriptor classDescriptor = (ClassDescriptor)item$iv$iv;
                    collection = destination$iv$iv;
                    Experimentality experimentality = Companion.loadExperimentalityForMarkerAnnotation$frontend((ClassDescriptor)it);
                    collection.add(experimentality);
                }
                collection = (List)destination$iv$iv;
                smartSet.addAll(collection);
            }
            if ((container2 = $receiver.getContainingDeclaration()) instanceof ClassDescriptor && !($receiver instanceof ConstructorDescriptor)) {
                result2.addAll(this.loadExperimentalities(container2, moduleAnnotationsResolver, languageVersionSettings));
            }
            for (ClassId moduleAnnotationClassId : moduleAnnotationsResolver.getAnnotationsOnContainingModule($receiver)) {
                ClassDescriptor annotationClass = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($receiver), moduleAnnotationClassId);
                ClassDescriptor classDescriptor = annotationClass;
                CollectionsKt.addIfNotNull(result2, classDescriptor != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor) : null);
            }
            return result2;
        }

        @Nullable
        public final Experimentality loadExperimentalityForMarkerAnnotation$frontend(@NotNull ClassDescriptor $receiver) {
            Name name;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            AnnotationDescriptor annotationDescriptor = $receiver.getAnnotations().findAnnotation(this.getEXPERIMENTAL_FQ_NAME());
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor experimental = annotationDescriptor;
            ConstantValue<?> constantValue = experimental.getAllValueArguments().get(LEVEL);
            if (!(constantValue instanceof EnumValue)) {
                constantValue = null;
            }
            EnumValue enumValue = (EnumValue)constantValue;
            Name name2 = name = enumValue != null ? enumValue.getEnumEntryName() : null;
            Experimentality.Severity severity = Intrinsics.areEqual((Object)name, (Object)WARNING_LEVEL) ? Experimentality.Severity.WARNING : (Intrinsics.areEqual((Object)name, (Object)ERROR_LEVEL) ? Experimentality.Severity.ERROR : Experimentality.Companion.getDEFAULT_SEVERITY());
            return new Experimentality(DescriptorUtilsKt.getFqNameSafe($receiver), severity);
        }

        private final boolean isExperimentalityAccepted(@NotNull PsiElement $receiver, FqName annotationFqName, CheckerContext context) {
            LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
            return this.isExperimentalityAccepted($receiver, annotationFqName, languageVersionSettings, bindingContext);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExperimentalityAccepted(@NotNull PsiElement $receiver, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext) {
            void element;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
            if (languageVersionSettings.getFlag(AnalysisFlag.Flags.getExperimental()).contains(annotationFqName.asString())) return true;
            if (languageVersionSettings.getFlag(AnalysisFlag.Flags.getUseExperimental()).contains(annotationFqName.asString())) return true;
            PsiElement psiElement = $receiver;
            Companion companion = this;
            PsiElement element$iv = $receiver$iv;
            while (!Companion.isDeclarationAnnotatedWith((PsiElement)(element = element$iv), annotationFqName, bindingContext)) {
                if (Companion.isElementAnnotatedWithUseExperimentalOf((PsiElement)element, annotationFqName, bindingContext)) {
                    return true;
                }
                boolean bl = false;
                if (bl) {
                    return true;
                }
                if (element$iv.getParent() == null) return false;
            }
            return true;
        }

        private final boolean isDeclarationAnnotatedWith(@NotNull PsiElement $receiver, FqName annotationFqName, BindingContext bindingContext) {
            if (!($receiver instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
            return descriptor2 != null && !DescriptorUtils.isLocal(descriptor2) && descriptor2.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithUseExperimentalOf(@NotNull PsiElement $receiver, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($receiver instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$receiver).getAnnotationEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationEntries");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                AnnotationDescriptor descriptor2;
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                AnnotationDescriptor annotationDescriptor = descriptor2 = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)Companion.getUSE_EXPERIMENTAL_FQ_NAME$frontend())) {
                    ConstantValue<?> annotationClasses = descriptor2.getAllValueArguments().get(Companion.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl2;
                        Iterable $receiver$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                Object object;
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                ConstantValue constantValue = annotationClass;
                                if (!(constantValue instanceof KClassValue)) {
                                    constantValue = null;
                                }
                                if (!Intrinsics.areEqual((object = (KClassValue)constantValue) != null && (object = ((KClassValue)object).getValue()) != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object) : null, (Object)annotationFqName)) continue;
                                return true;
                            }
                            bl2 = false;
                        }
                        if (bl2) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkParameterIsNotNull(reportError2, (String)"reportError");
            Intrinsics.checkParameterIsNotNull(reportWarning, (String)"reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager(), languageVersionSettings);
            Function1<String, Boolean> checkAnnotation$ = new Function1<String, Boolean>(module2, deprecationResolver, reportWarning, reportError2){
                final /* synthetic */ ModuleDescriptor $module;
                final /* synthetic */ DeprecationResolver $deprecationResolver;
                final /* synthetic */ Function1 $reportWarning;
                final /* synthetic */ Function1 $reportError;

                public final boolean invoke(@NotNull String fqName2) {
                    String string;
                    Experimentality experimentality;
                    ClassDescriptor descriptor2;
                    Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                    ClassDescriptor classDescriptor = descriptor2 = DescriptorUtilKt.resolveClassByFqName(this.$module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
                    Experimentality experimentality2 = experimentality = classDescriptor != null ? ExperimentalUsageChecker.Companion.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor) : null;
                    if (descriptor2 == null) {
                        string = "Experimental API marker " + fqName2 + " is unresolved. Please make sure it's present in the module dependencies";
                    } else if (experimentality == null) {
                        string = "Class " + fqName2 + " is not an experimental API marker annotation";
                    } else {
                        for (Deprecation deprecation : this.$deprecationResolver.getDeprecations(descriptor2)) {
                            String string2;
                            String string3;
                            Function1 function1;
                            StringBuilder stringBuilder;
                            String string4;
                            Function1 report2;
                            Function1 function12;
                            switch (ExperimentalUsageChecker$Companion$WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                                case 1: {
                                    function12 = this.$reportWarning;
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    function12 = this.$reportError;
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            Function1 function13 = report2 = function12;
                            StringBuilder stringBuilder2 = new StringBuilder().append("Experimental API marker ").append(fqName2).append(" is deprecated");
                            String string5 = deprecation.getMessage();
                            if (string5 != null) {
                                string4 = string5;
                                stringBuilder = stringBuilder2;
                                function1 = function13;
                                String it = string4;
                                string3 = ". " + it;
                                function13 = function1;
                                stringBuilder2 = stringBuilder;
                                string2 = string3;
                            } else {
                                string2 = null;
                            }
                            string4 = string2;
                            stringBuilder = stringBuilder2;
                            function1 = function13;
                            String string6 = string4;
                            if (string6 == null) {
                                string6 = "";
                            }
                            string3 = string6;
                            function1.invoke((Object)stringBuilder.append(string3).toString());
                        }
                        return true;
                    }
                    String message = string;
                    this.$reportError.invoke((Object)message);
                    return false;
                }
                {
                    this.$module = moduleDescriptor;
                    this.$deprecationResolver = deprecationResolver;
                    this.$reportWarning = function1;
                    this.$reportError = function12;
                    super(1);
                }
            };
            Iterable iterable = $receiver$iv = (Iterable)languageVersionSettings.getFlag(AnalysisFlag.Flags.getExperimental());
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String p1 = (String)element$iv$iv;
                if (!checkAnnotation$.invoke(p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validExperimental = (List)destination$iv$iv;
            Iterable $receiver$iv2 = languageVersionSettings.getFlag(AnalysisFlag.Flags.getUseExperimental());
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String fqName2 = (String)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)fqName2, (Object)Companion.getEXPERIMENTAL_FQ_NAME().asString()) || checkAnnotation$.invoke(fqName2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List validUseExperimental = (List)destination$iv$iv2;
            for (String fqName3 : kotlin.collections.CollectionsKt.intersect((Iterable)validExperimental, (Iterable)validUseExperimental)) {
                reportError2.invoke((Object)("'-Xuse-experimental=" + fqName3 + "' has no effect because '-Xexperimental=" + fqName3 + "' is used"));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

