/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.io.PrintStream;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

public abstract class CLICompiler<A extends CommonCompilerArguments>
extends CLITool<A> {
    public static String KOTLIN_HOME_PROPERTY = "kotlin.home";
    public static String KOTLIN_HOME_ENV_VAR = "KOTLIN_HOME";
    private static final String kotlinHomeEnvVar = System.getenv(KOTLIN_HOME_ENV_VAR);

    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        return this.exec(errStream, services, MessageRenderer.XML, args);
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        return this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ExitCode execImpl(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupCommonArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull A arguments2, @NotNull Services services) {
        CompilerJarLocator locator;
        if (((CommonCompilerArguments)arguments2).getNoInline()) {
            configuration.put(CommonConfigurationKeys.DISABLE_INLINE, true);
        }
        if (((CommonCompilerArguments)arguments2).getIntellijPluginRoot() != null) {
            configuration.put(CLIConfigurationKeys.INTELLIJ_PLUGIN_ROOT, ((CommonCompilerArguments)arguments2).getIntellijPluginRoot());
        }
        if (((CommonCompilerArguments)arguments2).getReportOutputFiles()) {
            configuration.put(CommonConfigurationKeys.REPORT_OUTPUT_FILES, true);
        }
        if ((locator = services.get(CompilerJarLocator.class)) != null) {
            configuration.put(CLIConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        this.setupLanguageVersionSettings(configuration, arguments2);
    }

    private void setupLanguageVersionSettings(@NotNull CompilerConfiguration configuration, @NotNull A arguments2) {
        MessageCollector collector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        CommonConfigurationKeysKt.setLanguageVersionSettings(configuration, ((CommonCompilerArguments)arguments2).configureLanguageVersionSettings(collector2));
    }

    @Nullable
    private static KotlinPaths computeKotlinPaths(@NotNull MessageCollector messageCollector2, @NotNull CommonCompilerArguments arguments2) {
        KotlinPaths paths;
        File kotlinHome;
        String kotlinHomeProperty = System.getProperty(KOTLIN_HOME_PROPERTY);
        File file2 = arguments2.getKotlinHome() != null ? new File(arguments2.getKotlinHome()) : (kotlinHomeProperty != null ? new File(kotlinHomeProperty) : (kotlinHome = kotlinHomeEnvVar != null ? new File(kotlinHomeEnvVar) : null));
        if (kotlinHome != null) {
            if (kotlinHome.isDirectory()) {
                paths = new KotlinPathsFromHomeDir(kotlinHome);
            } else {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Kotlin home does not exist or is not a directory: " + kotlinHome, null);
                paths = null;
            }
        } else {
            paths = PathUtil.getKotlinPathsForCompiler();
        }
        if (paths != null) {
            messageCollector2.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), null);
        }
        return paths;
    }

    @Nullable
    public static File getLibraryFromHome(@Nullable KotlinPaths paths, @NotNull Function1<KotlinPaths, File> getLibrary, @NotNull String libraryName, @NotNull MessageCollector messageCollector2, @NotNull String noLibraryArgument) {
        File stdlibJar;
        if (paths != null && (stdlibJar = (File)getLibrary.invoke((Object)paths)).exists()) {
            return stdlibJar;
        }
        messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    protected abstract void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration var1, @NotNull A var2, @NotNull Services var3);

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull CompilerConfiguration var2, @NotNull Disposable var3, @Nullable KotlinPaths var4);

    @NotNull
    protected abstract CommonCompilerPerformanceManager getPerformanceManager();

    private static /* synthetic */ void lambda$execImpl$0(CompilerConfiguration configuration, PerformanceMeasurement it) {
        configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.INFO, "PERF: " + it.render(), null);
    }
}

