/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u000389:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001fJ>\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00152\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00030#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020%0#H\u0080\b\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020/H\u0016J\b\u00100\u001a\u00020,H\u0002J7\u00101\u001a\u0002H2\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u00020\u001a2\u0017\u00104\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H20#\u00a2\u0006\u0002\b5H\u0080\b\u00a2\u0006\u0004\b6\u00107R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\u00020\u0003*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext;", "", "errorTypeEqualsToAnything", "", "allowedTypeVariable", "(ZZ)V", "getAllowedTypeVariable", "()Z", "argumentsDepth", "", "getArgumentsDepth", "()I", "setArgumentsDepth", "(I)V", "getErrorTypeEqualsToAnything", "sameConstructorPolicy", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SeveralSupertypesWithSameConstructorPolicy;", "getSameConstructorPolicy", "()Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SeveralSupertypesWithSameConstructorPolicy;", "supertypesDeque", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/types/SimpleType;", "supertypesLocked", "supertypesSet", "", "isAllowedTypeVariable", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "(Lorg/jetbrains/kotlin/types/UnwrappedType;)Z", "addSubtypeConstraint", "subType", "superType", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;", "anySupertype", "start", "predicate", "Lkotlin/Function1;", "supertypesPolicy", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "anySupertype$descriptors", "areEqualTypeConstructors", "a", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "b", "clear", "", "getLowerCapturedTypePolicy", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$LowerCapturedTypePolicy;", "Lorg/jetbrains/kotlin/types/checker/NewCapturedType;", "initialize", "runWithArgumentsSettings", "T", "subArgument", "f", "Lkotlin/ExtensionFunctionType;", "runWithArgumentsSettings$descriptors", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "LowerCapturedTypePolicy", "SeveralSupertypesWithSameConstructorPolicy", "SupertypesPolicy", "descriptors"})
public class TypeCheckerContext {
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleType> supertypesDeque;
    private Set<SimpleType> supertypesSet;
    private final boolean errorTypeEqualsToAnything;
    private final boolean allowedTypeVariable;

    protected final int getArgumentsDepth() {
        return this.argumentsDepth;
    }

    protected final void setArgumentsDepth(int n) {
        this.argumentsDepth = n;
    }

    @Nullable
    public Boolean addSubtypeConstraint(@NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return null;
    }

    public boolean areEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a, (Object)b);
    }

    @NotNull
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(@NotNull SimpleType subType, @NotNull NewCapturedType superType) {
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    @NotNull
    public SeveralSupertypesWithSameConstructorPolicy getSameConstructorPolicy() {
        return SeveralSupertypesWithSameConstructorPolicy.INTERSECT_ARGUMENTS_AND_CHECK_AGAIN;
    }

    public final <T> T runWithArgumentsSettings$descriptors(@NotNull UnwrappedType subArgument, @NotNull Function1<? super TypeCheckerContext, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)subArgument, (String)"subArgument");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        if (this.argumentsDepth > 100) {
            String string = "Arguments depth is too high. Some related argument: " + subArgument;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        TypeCheckerContext typeCheckerContext = this;
        int n = typeCheckerContext.argumentsDepth;
        typeCheckerContext.argumentsDepth = n + 1;
        Object result2 = f.invoke((Object)this);
        TypeCheckerContext typeCheckerContext2 = this;
        int n2 = typeCheckerContext2.argumentsDepth;
        typeCheckerContext2.argumentsDepth = n2 + -1;
        return (T)result2;
    }

    private final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    private final void clear() {
        ArrayDeque<SimpleType> arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        arrayDeque.clear();
        Set<SimpleType> set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean anySupertype$descriptors(@NotNull SimpleType start, @NotNull Function1<? super SimpleType, Boolean> predicate, @NotNull Function1<? super SimpleType, ? extends SupertypesPolicy> supertypesPolicy) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(supertypesPolicy, (String)"supertypesPolicy");
        if (((Boolean)predicate.invoke((Object)start)).booleanValue()) {
            return true;
        }
        this.initialize();
        ArrayDeque arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        ArrayDeque deque = arrayDeque;
        Set set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        Set visitedSupertypes = set;
        deque.push(start);
        while (!(object = (Collection)deque).isEmpty()) {
            SimpleType current;
            if (visitedSupertypes.size() > 1000) {
                object = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes, null, null, null, (int)0, null, null, (int)63, null);
                throw (Throwable)new IllegalStateException(object.toString());
            }
            SimpleType simpleType2 = current = (SimpleType)deque.pop();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"current");
            if (!visitedSupertypes.add(simpleType2)) continue;
            Object object2 = supertypesPolicy.invoke((Object)current);
            SupertypesPolicy it = (SupertypesPolicy)object2;
            if ((SupertypesPolicy)(Intrinsics.areEqual((Object)it, (Object)SupertypesPolicy.None.INSTANCE) ^ true ? object2 : null) == null) {
                continue;
            }
            Iterator<KotlinType> iterator2 = current.getConstructor().getSupertypes().iterator();
            while (iterator2.hasNext()) {
                SupertypesPolicy policy;
                KotlinType supertype;
                KotlinType kotlinType = supertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"supertype");
                SimpleType newType = policy.transformType(kotlinType);
                if (((Boolean)predicate.invoke((Object)newType)).booleanValue()) {
                    this.clear();
                    return true;
                }
                deque.add(newType);
            }
        }
        this.clear();
        return false;
    }

    public final boolean isAllowedTypeVariable(@NotNull UnwrappedType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.allowedTypeVariable && $receiver.getConstructor() instanceof NewTypeVariableConstructor;
    }

    public final boolean getErrorTypeEqualsToAnything() {
        return this.errorTypeEqualsToAnything;
    }

    public final boolean getAllowedTypeVariable() {
        return this.allowedTypeVariable;
    }

    public TypeCheckerContext(boolean errorTypeEqualsToAnything, boolean allowedTypeVariable) {
        this.errorTypeEqualsToAnything = errorTypeEqualsToAnything;
        this.allowedTypeVariable = allowedTypeVariable;
    }

    public /* synthetic */ TypeCheckerContext(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        this(bl, bl2);
    }

    public static final /* synthetic */ void access$setSupertypesDeque$p(TypeCheckerContext $this, @Nullable ArrayDeque arrayDeque) {
        $this.supertypesDeque = arrayDeque;
    }

    public static final /* synthetic */ void access$setSupertypesSet$p(TypeCheckerContext $this, @Nullable Set set) {
        $this.supertypesSet = set;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "", "()V", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "LowerIfFlexible", "LowerIfFlexibleWithCustomSubstitutor", "None", "UpperIfFlexible", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$None;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$UpperIfFlexible;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$LowerIfFlexible;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$LowerIfFlexibleWithCustomSubstitutor;", "descriptors"})
    public static abstract class SupertypesPolicy {
        @NotNull
        public abstract SimpleType transformType(@NotNull KotlinType var1);

        private SupertypesPolicy() {
        }

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$None;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "()V", "transformType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE;

            @NotNull
            public Void transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                throw (Throwable)new UnsupportedOperationException("Should not be called");
            }

            private None() {
                super(null);
            }

            static {
                None none2;
                INSTANCE = none2 = new None();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$UpperIfFlexible;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "()V", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return FlexibleTypesKt.upperIfFlexible(type2);
            }

            private UpperIfFlexible() {
                super(null);
            }

            static {
                UpperIfFlexible upperIfFlexible;
                INSTANCE = upperIfFlexible = new UpperIfFlexible();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$LowerIfFlexible;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "()V", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return FlexibleTypesKt.lowerIfFlexible(type2);
            }

            private LowerIfFlexible() {
                super(null);
            }

            static {
                LowerIfFlexible lowerIfFlexible;
                INSTANCE = lowerIfFlexible = new LowerIfFlexible();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$LowerIfFlexibleWithCustomSubstitutor;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "(Lorg/jetbrains/kotlin/types/TypeSubstitutor;)V", "getSubstitutor", "()Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
        public static final class LowerIfFlexibleWithCustomSubstitutor
        extends SupertypesPolicy {
            @NotNull
            private final TypeSubstitutor substitutor;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                KotlinType kotlinType = this.substitutor.safeSubstitute(FlexibleTypesKt.lowerIfFlexible(type2), Variance.INVARIANT);
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"substitutor.safeSubstitu\u2026le(), Variance.INVARIANT)");
                return TypeSubstitutionKt.asSimpleType(kotlinType);
            }

            @NotNull
            public final TypeSubstitutor getSubstitutor() {
                return this.substitutor;
            }

            public LowerIfFlexibleWithCustomSubstitutor(@NotNull TypeSubstitutor substitutor2) {
                Intrinsics.checkParameterIsNotNull((Object)substitutor2, (String)"substitutor");
                super(null);
                this.substitutor = substitutor2;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SeveralSupertypesWithSameConstructorPolicy;", "", "(Ljava/lang/String;I)V", "TAKE_FIRST_FOR_SUBTYPING", "FORCE_NOT_SUBTYPE", "CHECK_ANY_OF_THEM", "INTERSECT_ARGUMENTS_AND_CHECK_AGAIN", "descriptors"})
    public static final class SeveralSupertypesWithSameConstructorPolicy
    extends Enum<SeveralSupertypesWithSameConstructorPolicy> {
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy TAKE_FIRST_FOR_SUBTYPING;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy FORCE_NOT_SUBTYPE;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy CHECK_ANY_OF_THEM;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy INTERSECT_ARGUMENTS_AND_CHECK_AGAIN;
        private static final /* synthetic */ SeveralSupertypesWithSameConstructorPolicy[] $VALUES;

        static {
            SeveralSupertypesWithSameConstructorPolicy[] severalSupertypesWithSameConstructorPolicyArray = new SeveralSupertypesWithSameConstructorPolicy[4];
            SeveralSupertypesWithSameConstructorPolicy[] severalSupertypesWithSameConstructorPolicyArray2 = severalSupertypesWithSameConstructorPolicyArray;
            severalSupertypesWithSameConstructorPolicyArray[0] = TAKE_FIRST_FOR_SUBTYPING = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[1] = FORCE_NOT_SUBTYPE = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[2] = CHECK_ANY_OF_THEM = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[3] = INTERSECT_ARGUMENTS_AND_CHECK_AGAIN = new SeveralSupertypesWithSameConstructorPolicy();
            $VALUES = severalSupertypesWithSameConstructorPolicyArray;
        }

        public static SeveralSupertypesWithSameConstructorPolicy[] values() {
            return (SeveralSupertypesWithSameConstructorPolicy[])$VALUES.clone();
        }

        public static SeveralSupertypesWithSameConstructorPolicy valueOf(String string) {
            return Enum.valueOf(SeveralSupertypesWithSameConstructorPolicy.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$LowerCapturedTypePolicy;", "", "(Ljava/lang/String;I)V", "CHECK_ONLY_LOWER", "CHECK_SUBTYPE_AND_LOWER", "SKIP_LOWER", "descriptors"})
    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER;
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER;
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER;
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;

        static {
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[3];
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray2 = lowerCapturedTypePolicyArray;
            lowerCapturedTypePolicyArray[0] = CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
            lowerCapturedTypePolicyArray[1] = CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
            lowerCapturedTypePolicyArray[2] = SKIP_LOWER = new LowerCapturedTypePolicy();
            $VALUES = lowerCapturedTypePolicyArray;
        }

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String string) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, string);
        }
    }
}

