/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.TypeArgument;
import org.jetbrains.kotlin.resolve.calls.model.TypeArgumentPlaceholder;
import org.jetbrains.kotlin.resolve.calls.model.WrongCountOfTypeArguments;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper;", "", "()V", "mapTypeArguments", "Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "TypeArgumentsMapping", "resolution"})
public final class TypeArgumentsToParametersMapper {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeArgumentsMapping mapTypeArguments(@NotNull KotlinCall call2, @NotNull CallableDescriptor descriptor2) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (call2.getTypeArguments().isEmpty()) {
            return TypeArgumentsMapping.NoExplicitArguments.INSTANCE;
        }
        if (call2.getTypeArguments().size() != descriptor2.getTypeParameters().size()) {
            return new TypeArgumentsMapping.TypeArgumentsMappingImpl((List<? extends KotlinCallDiagnostic>)CollectionsKt.listOf((Object)new WrongCountOfTypeArguments(descriptor2, call2.getTypeArguments().size())), MapsKt.emptyMap());
        }
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.typeParameters");
        Iterable $receiver$iv = CollectionsKt.zip((Iterable)list2, (Iterable)call2.getTypeArguments());
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Pair it;
            Map map2 = destination$iv$iv;
            Pair pair = it = (Pair)element$iv$iv;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map typeParameterToArgumentMap = destination$iv$iv;
        return new TypeArgumentsMapping.TypeArgumentsMappingImpl((List<? extends KotlinCallDiagnostic>)CollectionsKt.emptyList(), typeParameterToArgumentMap);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\f\rB\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping;", "", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "(Ljava/util/List;)V", "getDiagnostics", "()Ljava/util/List;", "getTypeArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/TypeArgument;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "NoExplicitArguments", "TypeArgumentsMappingImpl", "Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping$NoExplicitArguments;", "Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping$TypeArgumentsMappingImpl;", "resolution"})
    public static abstract class TypeArgumentsMapping {
        @NotNull
        private final List<KotlinCallDiagnostic> diagnostics;

        @NotNull
        public abstract TypeArgument getTypeArgument(@NotNull TypeParameterDescriptor var1);

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        private TypeArgumentsMapping(List<? extends KotlinCallDiagnostic> diagnostics) {
            this.diagnostics = diagnostics;
        }

        public /* synthetic */ TypeArgumentsMapping(@NotNull List diagnostics, DefaultConstructorMarker $constructor_marker) {
            this(diagnostics);
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping$NoExplicitArguments;", "Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping;", "()V", "getTypeArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/TypeArgument;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "resolution"})
        public static final class NoExplicitArguments
        extends TypeArgumentsMapping {
            public static final NoExplicitArguments INSTANCE;

            @Override
            @NotNull
            public TypeArgument getTypeArgument(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                return TypeArgumentPlaceholder.INSTANCE;
            }

            private NoExplicitArguments() {
                super(CollectionsKt.emptyList(), null);
            }

            static {
                NoExplicitArguments noExplicitArguments;
                INSTANCE = noExplicitArguments = new NoExplicitArguments();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping$TypeArgumentsMappingImpl;", "Lorg/jetbrains/kotlin/resolve/calls/components/TypeArgumentsToParametersMapper$TypeArgumentsMapping;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "typeParameterToArgumentMap", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/TypeArgument;", "(Ljava/util/List;Ljava/util/Map;)V", "getTypeArgument", "typeParameterDescriptor", "resolution"})
        public static final class TypeArgumentsMappingImpl
        extends TypeArgumentsMapping {
            private final Map<TypeParameterDescriptor, TypeArgument> typeParameterToArgumentMap;

            @Override
            @NotNull
            public TypeArgument getTypeArgument(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                TypeArgument typeArgument = this.typeParameterToArgumentMap.get(typeParameterDescriptor);
                if (typeArgument == null) {
                    typeArgument = TypeArgumentPlaceholder.INSTANCE;
                }
                return typeArgument;
            }

            public TypeArgumentsMappingImpl(@NotNull List<? extends KotlinCallDiagnostic> diagnostics, @NotNull Map<TypeParameterDescriptor, ? extends TypeArgument> typeParameterToArgumentMap) {
                Intrinsics.checkParameterIsNotNull(diagnostics, (String)"diagnostics");
                Intrinsics.checkParameterIsNotNull(typeParameterToArgumentMap, (String)"typeParameterToArgumentMap");
                super(diagnostics, null);
                this.typeParameterToArgumentMap = typeParameterToArgumentMap;
            }
        }
    }
}

