/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.backend.ast.metadata.TypeCheck;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String EQUALS_METHOD_NAME = Namer.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getAny(), "equals");
    public static final String COMPARE_TO_METHOD_NAME = Namer.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getComparable(), "compareTo");
    public static final String LONG_FROM_NUMBER = "fromNumber";
    public static final String LONG_TO_NUMBER = "toNumber";
    public static final String LONG_FROM_INT = "fromInt";
    public static final String LONG_ZERO = "ZERO";
    public static final String LONG_ONE = "ONE";
    public static final String LONG_NEG_ONE = "NEG_ONE";
    public static final String PRIMITIVE_COMPARE_TO = "primitiveCompareTo";
    public static final String IS_CHAR = "isChar";
    public static final String IS_NUMBER = "isNumber";
    public static final String GET_KCLASS = "getKClass";
    public static final String GET_KCLASS_FROM_EXPRESSION = "getKClassFromExpression";
    public static final String CALLEE_NAME = "$fun";
    public static final String CALL_FUNCTION = "call";
    public static final String OUTER_FIELD_NAME = "$outer";
    public static final String ANOTHER_THIS_PARAMETER_NAME = "$this";
    public static final String THROW_NPE_FUN_NAME = "throwNPE";
    public static final String THROW_CLASS_CAST_EXCEPTION_FUN_NAME = "throwCCE";
    public static final String THROW_ILLEGAL_STATE_EXCEPTION_FUN_NAME = "throwISE";
    public static final String THROW_UNINITIALIZED_PROPERTY_ACCESS_EXCEPTION = "throwUPAE";
    public static final JsNameRef IS_ARRAY_FUN_REF = new JsNameRef("isArray", "Array");
    public static final String DEFINE_INLINE_FUNCTION = "defineInlineFunction";
    public static final String DEFAULT_PARAMETER_IMPLEMENTOR_SUFFIX = "$default";
    private static final JsNameRef JS_OBJECT = new JsNameRef("Object");
    private static final JsNameRef JS_OBJECT_CREATE_FUNCTION = new JsNameRef("create", (JsExpression)JS_OBJECT);
    public static final String LOCAL_MODULE_PREFIX = "$module$";
    public static final String METADATA = "$metadata$";
    public static final String METADATA_SUPERTYPES = "interfaces";
    public static final String METADATA_SIMPLE_NAME = "simpleName";
    public static final String METADATA_CLASS_KIND = "kind";
    public static final String CLASS_KIND_ENUM = "Kind";
    public static final String CLASS_KIND_CLASS = "CLASS";
    public static final String CLASS_KIND_INTERFACE = "INTERFACE";
    public static final String CLASS_KIND_OBJECT = "OBJECT";
    public static final String OBJECT_INSTANCE_VAR_SUFFIX = "_instance";
    public static final String OBJECT_INSTANCE_FUNCTION_SUFFIX = "_getInstance";
    public static final String ENUM_NAME_FIELD = "name$";
    public static final String ENUM_ORDINAL_FIELD = "ordinal$";
    public static final String IMPORTS_FOR_INLINE_PROPERTY = "$$importsForInline$$";
    @NotNull
    private final JsObjectScope kotlinScope;
    @NotNull
    public static final String FUNCTION_CALLABLE_REF = "getCallableRef";
    @NotNull
    public static final String PROPERTY_CALLABLE_REF = "getPropertyCallableRef";
    @NotNull
    private final JsExpression callGetProperty;
    @NotNull
    private final JsExpression callSetProperty;

    @NotNull
    public static String getFunctionTag(@NotNull CallableDescriptor functionDescriptor, @NotNull JsConfig config) {
        String intrinsicTag = ArrayFIF.INSTANCE.getTag(functionDescriptor, config);
        if (intrinsicTag != null) {
            return intrinsicTag;
        }
        functionDescriptor = (CallableDescriptor)JsDescriptorUtils.findRealInlineDeclaration(functionDescriptor);
        String moduleName = JsDescriptorUtils.getModuleName(functionDescriptor);
        FqNameUnsafe fqNameParent = DescriptorUtils.getFqName(functionDescriptor).parent();
        String qualifier = null;
        if (!fqNameParent.isRoot()) {
            qualifier = fqNameParent.asString();
        }
        SuggestedName suggestedName = new NameSuggestion().suggest(functionDescriptor);
        assert (suggestedName != null) : "Suggested name can be null only for module descriptors: " + functionDescriptor;
        String mangledName = suggestedName.getNames().get(0);
        return StringUtil.join(Arrays.asList(moduleName, qualifier, mangledName), ".");
    }

    @NotNull
    public static String getReceiverParameterName() {
        return "$receiver";
    }

    @NotNull
    public static String getRootPackageName() {
        return "_";
    }

    @NotNull
    public static String getPrototypeName() {
        return "prototype";
    }

    @NotNull
    public static String getDelegatePrefix() {
        return "$delegate";
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        return JsAstUtils.pureFqn(CALL_FUNCTION, functionExpression);
    }

    @NotNull
    public static JsNameRef getFunctionApplyRef(@NotNull JsExpression functionExpression) {
        return JsAstUtils.pureFqn("apply", functionExpression);
    }

    @NotNull
    public static JsInvocation createObjectWithPrototypeFrom(@NotNull JsExpression referenceToClass) {
        return new JsInvocation((JsExpression)JS_OBJECT_CREATE_FUNCTION.deepCopy(), JsAstUtils.prototypeOf(referenceToClass));
    }

    @NotNull
    public static JsNameRef getCapturedVarAccessor(@NotNull JsExpression ref) {
        JsNameRef result2 = new JsNameRef("v", ref);
        MetadataProperties.setSideEffects(result2, SideEffectKind.DEPENDS_ON_STATE);
        return result2;
    }

    @NotNull
    public static String isInstanceSuggestedName(@NotNull TypeParameterDescriptor descriptor2) {
        return "is" + NameSuggestion.sanitizeName(descriptor2.getName().getIdentifier());
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope2) {
        return new Namer(rootScope2);
    }

    private Namer(@NotNull JsScope rootScope2) {
        this.kotlinScope = new JsObjectScope(rootScope2, "Kotlin standard object");
        this.callGetProperty = this.kotlin("callGetter");
        this.callSetProperty = this.kotlin("callSetter");
    }

    @NotNull
    private static String getStableMangledNameForDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull String functionName) {
        Collection<SimpleFunctionDescriptor> functions2 = descriptor2.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier(functionName), NoLookupLocation.FROM_BACKEND);
        assert (functions2.size() == 1) : "Can't select a single function: " + functionName + " in " + descriptor2;
        SuggestedName suggested = new NameSuggestion().suggest(functions2.iterator().next());
        assert (suggested != null) : "Suggested name for class members is always non-null: " + functions2.iterator().next();
        return suggested.getNames().get(0);
    }

    @NotNull
    public static JsNameRef kotlin(@NotNull JsName name) {
        return JsAstUtils.pureFqn(name, (JsExpression)Namer.kotlinObject());
    }

    @NotNull
    public JsNameRef kotlin(@NotNull String name) {
        return Namer.kotlin(this.kotlinScope.declareName(name));
    }

    @NotNull
    public static JsNameRef kotlinObject() {
        return JsAstUtils.pureFqn(KOTLIN_NAME, null);
    }

    @NotNull
    public JsExpression isTypeOf(@NotNull JsExpression type2) {
        return this.invokeFunctionAndSetTypeCheckMetadata("isTypeOf", type2, TypeCheck.TYPEOF);
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression type2) {
        return this.invokeFunctionAndSetTypeCheckMetadata("isInstanceOf", type2, TypeCheck.INSTANCEOF);
    }

    @NotNull
    public JsExpression orNull(@NotNull JsExpression callable) {
        return this.invokeFunctionAndSetTypeCheckMetadata("orNull", callable, TypeCheck.OR_NULL);
    }

    @NotNull
    public JsExpression andPredicate(@NotNull JsExpression a, @NotNull JsExpression b) {
        return this.invokeFunctionAndSetTypeCheckMetadata("andPredicate", Arrays.asList(a, b), TypeCheck.AND_PREDICATE);
    }

    @NotNull
    public JsExpression isComparable() {
        return this.kotlin("isComparable");
    }

    @NotNull
    public JsExpression isCharSequence() {
        return this.kotlin("isCharSequence");
    }

    @NotNull
    public JsExpression isArray() {
        return this.kotlin("isArray");
    }

    @NotNull
    public JsExpression isPrimitiveArray(@NotNull PrimitiveType type2) {
        return this.kotlin("is" + type2.getArrayTypeName().asString());
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @Nullable JsExpression argument, @NotNull TypeCheck metadata2) {
        List<JsExpression> arguments2 = argument != null ? Collections.singletonList(argument) : Collections.emptyList();
        return this.invokeFunctionAndSetTypeCheckMetadata(functionName, arguments2, metadata2);
    }

    @NotNull
    private JsExpression invokeFunctionAndSetTypeCheckMetadata(@NotNull String functionName, @NotNull List<JsExpression> arguments2, @NotNull TypeCheck metadata2) {
        JsInvocation invocation = new JsInvocation((JsExpression)this.kotlin(functionName), new JsExpression[0]);
        invocation.getArguments().addAll(arguments2);
        MetadataProperties.setTypeCheck(invocation, metadata2);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        return invocation;
    }

    @NotNull
    public static JsExpression isInstanceOf(@NotNull JsExpression instance, @NotNull JsExpression type2) {
        JsInvocation result2 = new JsInvocation((JsExpression)new JsNameRef("isType", KOTLIN_NAME), instance, type2);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        return result2;
    }

    @NotNull
    public static JsExpression getUndefinedExpression() {
        return new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0));
    }

    @NotNull
    public JsExpression getCallGetProperty() {
        return this.callGetProperty.deepCopy();
    }

    @NotNull
    public JsExpression getCallSetProperty() {
        return this.callSetProperty.deepCopy();
    }

    public static JsNameRef kotlinLong() {
        return JsAstUtils.pureFqn("Long", (JsExpression)Namer.kotlinObject());
    }

    @NotNull
    public static JsExpression createSpecialFunction(@NotNull SpecialFunction specialFunction) {
        return JsAstUtils.pureFqn(specialFunction.getSuggestedName(), (JsExpression)Namer.kotlinObject());
    }

    @NotNull
    public static String suggestedModuleName(@NotNull String id) {
        if (id.isEmpty()) {
            return "_";
        }
        StringBuilder sb = new StringBuilder(id.length());
        char c = id.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
        }
        for (int i = 1; i < id.length(); ++i) {
            c = id.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return sb.toString();
    }

    public static JsNameRef imul() {
        return JsAstUtils.pureFqn("imul", (JsExpression)Namer.kotlinObject());
    }

    public static boolean requiresEscaping(@NotNull String name) {
        if (name.isEmpty() || !Character.isJavaIdentifierStart(name.charAt(0))) {
            return true;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

