/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.dce.Context;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\r0\f\u001a(\u0010\u000e\u001a\u00020\u000f*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u0018\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u001b\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0007\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u001e\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u00a8\u0006 "}, d2={"isSpecialFunction", "", "expr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "asString", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "extractRoots", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "extractRootsImpl", "", "target", "", "visited", "isAmdDefine", "Lorg/jetbrains/kotlin/js/dce/Context;", "function", "isDefineInlineFunction", "isDefineModule", "isKotlinFunction", "name", "isObjectDefineProperty", "isObjectFunction", "functionName", "isObjectGetOwnPropertyDescriptor", "isTopLevelFunction", "isWrapFunction", "js.dce"})
public final class UtilKt {
    public static final boolean isObjectDefineProperty(@NotNull Context $receiver, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return UtilKt.isObjectFunction($receiver, function2, "defineProperty");
    }

    public static final boolean isObjectGetOwnPropertyDescriptor(@NotNull Context $receiver, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return UtilKt.isObjectFunction($receiver, function2, "getOwnPropertyDescriptor");
    }

    public static final boolean isDefineModule(@NotNull Context $receiver, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($receiver, function2, "defineModule");
    }

    public static final boolean isDefineInlineFunction(@NotNull Context $receiver, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($receiver, function2, "defineInlineFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.DEFINE_INLINE_FUNCTION);
    }

    public static final boolean isWrapFunction(@NotNull Context $receiver, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($receiver, function2, "wrapFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.WRAP_FUNCTION);
    }

    public static final boolean isObjectFunction(@NotNull Context $receiver, @NotNull JsExpression function2, @NotNull String functionName) {
        Context.Node node;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        if (!(function2 instanceof JsNameRef)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)functionName) ^ true) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        if (jsNameRef == null) {
            return false;
        }
        JsNameRef receiver = jsNameRef;
        JsName jsName = receiver.getName();
        if (jsName != null) {
            JsName jsName2;
            JsName it = jsName2 = jsName;
            node = $receiver.getNodes().get(it);
        } else {
            node = null;
        }
        if (node != null) {
            return false;
        }
        return Intrinsics.areEqual((Object)receiver.getIdent(), (Object)"Object");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFunction(@NotNull Context $receiver, @NotNull JsExpression function2, @NotNull String name) {
        Map<JsName, Context.Node> map2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (!(function2 instanceof JsNameRef)) return false;
        if (Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)name) ^ true) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        HasMetadata hasMetadata = jsNameRef;
        if (jsNameRef == null) return false;
        JsName jsName = ((JsNameRef)hasMetadata).getName();
        hasMetadata = jsName;
        if (jsName == null) return false;
        HasMetadata receiver = hasMetadata;
        Object object = $receiver.getNodes();
        Map<JsName, Context.Node> map3 = map2 = object;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map3.containsKey(receiver)) return false;
        Object object2 = object = ((JsName)receiver).getIdent();
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        if (!Intrinsics.areEqual((Object)string, (Object)"kotlin")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSpecialFunction(@NotNull JsExpression expr, @NotNull SpecialFunction specialFunction) {
        Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
        Intrinsics.checkParameterIsNotNull((Object)((Object)specialFunction), (String)"specialFunction");
        if (!(expr instanceof JsNameRef)) return false;
        if (((JsNameRef)expr).getQualifier() != null) return false;
        JsName jsName = ((JsNameRef)expr).getName();
        if (!Intrinsics.areEqual((Object)((Object)(jsName != null ? MetadataProperties.getSpecialFunction(jsName) : null)), (Object)((Object)specialFunction))) return false;
        return true;
    }

    public static final boolean isAmdDefine(@NotNull Context $receiver, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        return UtilKt.isTopLevelFunction($receiver, function2, "define");
    }

    public static final boolean isTopLevelFunction(@NotNull Context $receiver, @NotNull JsExpression function2, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (!(function2 instanceof JsNameRef) || ((JsNameRef)function2).getQualifier() != null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)name) && !CollectionsKt.contains((Iterable)$receiver.getNodes().keySet(), (Object)((JsNameRef)function2).getName());
    }

    @Nullable
    public static final JsLocation extractLocation(@NotNull JsNode $receiver) {
        JsLocation jsLocation;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JsNode jsNode = $receiver;
        if (jsNode instanceof SourceInfoAwareJsNode) {
            Object object = ((SourceInfoAwareJsNode)$receiver).getSource();
            if (!(object instanceof JsLocation)) {
                object = null;
            }
            jsLocation = (JsLocation)object;
        } else if (jsNode instanceof JsExpressionStatement) {
            Object object = ((JsExpressionStatement)$receiver).getExpression().getSource();
            if (!(object instanceof JsLocation)) {
                object = null;
            }
            jsLocation = (JsLocation)object;
        } else {
            jsLocation = null;
        }
        return jsLocation;
    }

    @NotNull
    public static final String asString(@NotNull JsLocation $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getFile();
        int n = StringsKt.lastIndexOf$default((CharSequence)$receiver.getFile(), (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String simpleFileName = string3;
        return "" + simpleFileName + ':' + ($receiver.getStartLine() + 1);
    }

    @NotNull
    public static final Set<Context.Node> extractRoots(@NotNull Set<Context.Node> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Set result2 = new LinkedHashSet();
        Set visited2 = new LinkedHashSet();
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            Context.Node it = (Context.Node)element$iv;
            UtilKt.extractRootsImpl(it.getOriginal(), result2, visited2);
        }
        return result2;
    }

    private static final void extractRootsImpl(@NotNull Context.Node $receiver, Set<Context.Node> target, Set<Context.Node> visited2) {
        if (!visited2.add($receiver.getOriginal())) {
            return;
        }
        Context.Qualifier qualifier = $receiver.getOriginal().getQualifier();
        if (qualifier == null) {
            Collection collection = target;
            Context.Node node = $receiver.getOriginal();
            collection.add(node);
        } else {
            UtilKt.extractRootsImpl(qualifier.getParent(), target, visited2);
        }
    }
}

