/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyVariantReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaModuleReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;

public class PsiJavaModuleReferenceElementImpl
extends CompositePsiElement
implements PsiJavaModuleReferenceElement {
    public PsiJavaModuleReferenceElementImpl() {
        super(JavaElementType.MODULE_REFERENCE);
    }

    @Override
    @NotNull
    public String getReferenceText() {
        StringBuilder sb = new StringBuilder();
        for (PsiElement e = this.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
            sb.append(e.getText());
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleReferenceElementImpl", "getReferenceText"));
        }
        return string;
    }

    @Override
    public PsiPolyVariantReference getReference() {
        return (PsiPolyVariantReference)CachedValuesManager.getCachedValue(this, () -> {
            PsiJavaModuleReferenceElementImpl refElement = this;
            PsiJavaModuleReference ref = refElement.getParent() instanceof PsiJavaModule ? null : new PsiJavaModuleReference(refElement);
            return CachedValueProvider.Result.create(ref, refElement);
        });
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaModuleReferenceElementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModuleReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaModuleReference";
    }
}

