/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.augment;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.lang.psiAugmentProvider");

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        return list2;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "inferType"));
        }
        return null;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers2) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifiers"));
        }
        if (modifiers2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifiers"));
        }
        Set<String> set = modifiers2;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifiers"));
        }
        return set;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        List result2 = ContainerUtil.newSmartList();
        PsiAugmentProvider.forEach(element.getProject(), provider -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "lambda$collectAugments$0"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "lambda$collectAugments$0"));
            }
            result2.addAll(provider.getAugments(element, type2));
            return true;
        });
        List list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        return list2;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "getInferredType"));
        }
        Ref result2 = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider -> {
            if (typeElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "lambda$getInferredType$1"));
            }
            PsiType type2 = provider.inferType(typeElement);
            if (type2 != null) {
                result2.set(type2);
                return false;
            }
            return true;
        });
        return (PsiType)result2.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList, @NotNull Project project, @NotNull Set<String> modifiers2) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        if (modifiers2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        Ref<Set<String>> result2 = Ref.create(modifiers2);
        PsiAugmentProvider.forEach(project, provider -> {
            if (modifierList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "lambda$transformModifierProperties$2"));
            }
            result2.set(provider.transformModifiers(modifierList, Collections.unmodifiableSet((Set)result2.get())));
            return true;
        });
        Set<String> set = result2.get();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        return set;
    }

    private static void forEach(Project project, Processor<PsiAugmentProvider> processor) {
        boolean dumb = DumbService.isDumb(project);
        for (PsiAugmentProvider provider : Extensions.getExtensions(EP_NAME)) {
            if (dumb && !DumbService.isDumbAware(provider)) continue;
            try {
                boolean goOn = processor.process(provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, e);
            }
        }
    }
}

