/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.kotlin.utils.StringsKt;

public abstract class CLICompiler<A extends CommonCompilerArguments>
extends CLITool<A> {
    public static String KOTLIN_HOME_PROPERTY = "kotlin.home";
    public static String KOTLIN_HOME_ENV_VAR = "KOTLIN_HOME";

    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        return this.exec(errStream, services, MessageRenderer.XML, args);
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        return this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public ExitCode execImpl(@NotNull MessageCollector messageCollector2, @NotNull Services services, @NotNull A arguments2) {
        GroupingMessageCollector groupingCollector = new GroupingMessageCollector(messageCollector2);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, groupingCollector);
        try {
            this.setupCommonArgumentsAndServices(configuration, arguments2, services);
            this.setupPlatformSpecificArgumentsAndServices(configuration, arguments2, services);
            KotlinPaths paths = CLICompiler.computeKotlinPaths(groupingCollector, arguments2);
            if (groupingCollector.hasErrors()) {
                ExitCode exitCode2 = ExitCode.COMPILATION_ERROR;
                return exitCode2;
            }
            ExitCode exitCode3 = ExitCode.OK;
            int repeatCount = 1;
            String repeat = ((CommonCompilerArguments)arguments2).getRepeat();
            if (repeat != null) {
                try {
                    repeatCount = Integer.parseInt(repeat);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            CompilationCanceledStatus canceledStatus = services.get(CompilationCanceledStatus.class);
            ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(canceledStatus);
            for (int i = 0; i < repeatCount; ++i) {
                if (i > 0) {
                    K2JVMCompiler.Companion.resetInitStartTime();
                }
                Disposable rootDisposable = Disposer.newDisposable();
                try {
                    UtilKt.setIdeaIoUseFallback();
                    ExitCode code = this.doExecute(arguments2, configuration, rootDisposable, paths);
                    exitCode3 = groupingCollector.hasErrors() ? ExitCode.COMPILATION_ERROR : code;
                    continue;
                }
                catch (CompilationCanceledException e) {
                    messageCollector2.report(CompilerMessageSeverity.INFO, "Compilation was canceled", null);
                    ExitCode exitCode4 = ExitCode.OK;
                    groupingCollector.flush();
                    return exitCode4;
                }
                catch (RuntimeException e) {
                    block22: {
                        Throwable cause = e.getCause();
                        if (!(cause instanceof CompilationCanceledException)) break block22;
                        messageCollector2.report(CompilerMessageSeverity.INFO, "Compilation was canceled", null);
                        ExitCode exitCode5 = ExitCode.OK;
                        Disposer.dispose(rootDisposable);
                        groupingCollector.flush();
                        return exitCode5;
                    }
                    throw e;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Disposer.dispose(rootDisposable);
                }
            }
            ExitCode exitCode6 = exitCode3;
            return exitCode6;
            {
                catch (Throwable t) {
                    MessageCollectorUtil.reportException(groupingCollector, t);
                    ExitCode exitCode7 = ExitCode.INTERNAL_ERROR;
                    return exitCode7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            groupingCollector.flush();
        }
    }

    private void setupCommonArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull A arguments2, @NotNull Services services) {
        CompilerJarLocator locator;
        if (((CommonCompilerArguments)arguments2).getNoInline()) {
            configuration.put(CommonConfigurationKeys.DISABLE_INLINE, true);
        }
        if (((CommonCompilerArguments)arguments2).getIntellijPluginRoot() != null) {
            configuration.put(CLIConfigurationKeys.INTELLIJ_PLUGIN_ROOT, ((CommonCompilerArguments)arguments2).getIntellijPluginRoot());
        }
        if (((CommonCompilerArguments)arguments2).getReportOutputFiles()) {
            configuration.put(CommonConfigurationKeys.REPORT_OUTPUT_FILES, true);
        }
        if ((locator = services.get(CompilerJarLocator.class)) != null) {
            configuration.put(CLIConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        this.setupLanguageVersionSettings(configuration, arguments2);
    }

    private void setupLanguageVersionSettings(@NotNull CompilerConfiguration configuration, @NotNull A arguments2) {
        LanguageFeature.State coroutinesState;
        LanguageVersion languageVersion = CLICompiler.parseVersion(configuration, ((CommonCompilerArguments)arguments2).getLanguageVersion(), "language");
        LanguageVersion apiVersion = CLICompiler.parseVersion(configuration, ((CommonCompilerArguments)arguments2).getApiVersion(), "API");
        if (languageVersion == null) {
            languageVersion = LanguageVersion.LATEST_STABLE;
        }
        if (apiVersion == null) {
            apiVersion = languageVersion;
        } else {
            configuration.put(CLIConfigurationKeys.IS_API_VERSION_EXPLICIT, true);
        }
        MessageCollector collector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (apiVersion.compareTo(languageVersion) > 0) {
            collector2.report(CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion.getVersionString() + ") cannot be greater than -language-version (" + languageVersion.getVersionString() + ")", null);
        }
        if (!languageVersion.isStable()) {
            collector2.report(CompilerMessageSeverity.STRONG_WARNING, "Language version " + languageVersion.getVersionString() + " is experimental, there are no backwards compatibility guarantees for new language and library features", null);
        }
        HashMap<LanguageFeature, LanguageFeature.State> extraLanguageFeatures = new HashMap<LanguageFeature, LanguageFeature.State>(0);
        if (((CommonCompilerArguments)arguments2).getMultiPlatform()) {
            extraLanguageFeatures.put(LanguageFeature.MultiPlatformProjects, LanguageFeature.State.ENABLED);
        }
        if ((coroutinesState = CLICompiler.chooseCoroutinesApplicabilityLevel(configuration, arguments2)) != null) {
            extraLanguageFeatures.put(LanguageFeature.Coroutines, coroutinesState);
        }
        CommonConfigurationKeysKt.setLanguageVersionSettings(configuration, new LanguageVersionSettingsImpl(languageVersion, ApiVersion.createByLanguageVersion(apiVersion), ((CommonCompilerArguments)arguments2).configureAnalysisFlags(collector2), extraLanguageFeatures));
    }

    @Nullable
    private static KotlinPaths computeKotlinPaths(@NotNull MessageCollector messageCollector2, @NotNull CommonCompilerArguments arguments2) {
        KotlinPaths paths;
        File kotlinHome;
        String kotlinHomeProperty = System.getProperty(KOTLIN_HOME_PROPERTY);
        String kotlinHomeEnvVar = System.getenv(KOTLIN_HOME_ENV_VAR);
        File file = arguments2.getKotlinHome() != null ? new File(arguments2.getKotlinHome()) : (kotlinHomeProperty != null ? new File(kotlinHomeProperty) : (kotlinHome = kotlinHomeEnvVar != null ? new File(kotlinHomeEnvVar) : null));
        if (kotlinHome != null) {
            if (kotlinHome.isDirectory()) {
                paths = new KotlinPathsFromHomeDir(kotlinHome);
            } else {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Kotlin home does not exist or is not a directory: " + kotlinHome, null);
                paths = null;
            }
        } else {
            paths = PathUtil.getKotlinPathsForCompiler();
        }
        if (paths != null) {
            messageCollector2.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), null);
        }
        return paths;
    }

    @Nullable
    public static File getLibraryFromHome(@Nullable KotlinPaths paths, @NotNull Function1<KotlinPaths, File> getLibrary, @NotNull String libraryName, @NotNull MessageCollector messageCollector2, @NotNull String noLibraryArgument) {
        File stdlibJar;
        if (paths != null && (stdlibJar = (File)getLibrary.invoke((Object)paths)).exists()) {
            return stdlibJar;
        }
        messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    @Nullable
    private static LanguageFeature.State chooseCoroutinesApplicabilityLevel(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2) {
        switch (arguments2.getCoroutinesState()) {
            case "error": {
                return LanguageFeature.State.ENABLED_WITH_ERROR;
            }
            case "enable": {
                return LanguageFeature.State.ENABLED;
            }
            case "warn": {
                return null;
            }
        }
        String message = "Invalid value of -Xcoroutines (should be: enable, warn or error): " + arguments2.getCoroutinesState();
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, null);
        return null;
    }

    @Nullable
    private static LanguageVersion parseVersion(@NotNull CompilerConfiguration configuration, @Nullable String value, @NotNull String versionOf) {
        if (value == null) {
            return null;
        }
        LanguageVersion version = LanguageVersion.fromVersionString(value);
        if (version != null) {
            return version;
        }
        List versionStrings = ArraysKt.map((Object[])LanguageVersion.values(), LanguageVersion::getDescription);
        String message = "Unknown " + versionOf + " version: " + value + "\nSupported " + versionOf + " versions: " + StringsKt.join(versionStrings, ", ");
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, null);
        return null;
    }

    protected abstract void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration var1, @NotNull A var2, @NotNull Services var3);

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull CompilerConfiguration var2, @NotNull Disposable var3, @Nullable KotlinPaths var4);
}

