/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class LocalSearchScope
extends SearchScope {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.search.LocalSearchScope");
    @NotNull
    private final PsiElement[] myScope;
    private final VirtualFile[] myVirtualFiles;
    private final boolean myIgnoreInjectedPsi;
    public static final LocalSearchScope EMPTY = new LocalSearchScope(PsiElement.EMPTY_ARRAY);
    private String myDisplayName;

    public LocalSearchScope(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(scope, null);
    }

    public LocalSearchScope(@NotNull PsiElement scope, @Nullable String displayName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(new PsiElement[]{scope});
        this.myDisplayName = displayName;
    }

    public LocalSearchScope(@NotNull PsiElement[] scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(scope, null);
    }

    public LocalSearchScope(@NotNull PsiElement[] scope, @Nullable String displayName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(scope, displayName, false);
    }

    public LocalSearchScope(@NotNull PsiElement[] scope, @Nullable String displayName, boolean ignoreInjectedPsi) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
        this.myDisplayName = displayName;
        LinkedHashSet<PsiElement> localScope = new LinkedHashSet<PsiElement>(scope.length);
        THashSet<VirtualFile> virtualFiles = new THashSet<VirtualFile>(scope.length);
        for (PsiElement element : scope) {
            VirtualFile virtualFile2;
            LOG.assertTrue(element != null, "null element");
            PsiFile containingFile = element.getContainingFile();
            LOG.assertTrue(containingFile != null, element.getClass().getName());
            if (element instanceof PsiFile) {
                for (PsiFile file : ((PsiFile)element).getViewProvider().getAllFiles()) {
                    if (file == null) {
                        throw new IllegalArgumentException("file " + element + " returned null in its getAllFiles()");
                    }
                    localScope.add(file);
                }
            } else if (element instanceof StubBasedPsiElement || element.getTextRange() != null) {
                localScope.add(element);
            }
            if ((virtualFile2 = PsiUtilCore.getVirtualFile(containingFile)) == null) continue;
            virtualFiles.add(virtualFile2);
        }
        this.myScope = PsiUtilCore.toPsiElementArray(localScope);
        this.myVirtualFiles = VfsUtilCore.toVirtualFileArray(virtualFiles);
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName == null ? super.getDisplayName() : this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElement[] getScope() {
        if (this.myScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getScope"));
        }
        return this.myScope;
    }

    @NotNull
    public VirtualFile[] getVirtualFiles() {
        if (this.myVirtualFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getVirtualFiles"));
        }
        return this.myVirtualFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalSearchScope)) {
            return false;
        }
        LocalSearchScope other = (LocalSearchScope)o;
        if (other.myIgnoreInjectedPsi != this.myIgnoreInjectedPsi) {
            return false;
        }
        if (other.myScope.length != this.myScope.length) {
            return false;
        }
        if (!Comparing.strEqual(this.myDisplayName, other.myDisplayName)) {
            return false;
        }
        for (PsiElement scopeElement : this.myScope) {
            for (PsiElement thatScopeElement : other.myScope) {
                if (Comparing.equal(scopeElement, thatScopeElement)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 0;
        result2 += this.myIgnoreInjectedPsi ? 1 : 0;
        for (PsiElement element : this.myScope) {
            result2 += element.hashCode();
        }
        return result2;
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        if (this.equals(scope2)) {
            LocalSearchScope localSearchScope = this;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = LocalSearchScope.intersection(this, scope2);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        return localSearchScope;
    }

    @NotNull
    private static LocalSearchScope intersection(@NotNull LocalSearchScope scope1, @NotNull LocalSearchScope scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope1", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersection"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersection"));
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement element1 : scope1.myScope) {
            for (PsiElement element2 : scope2.myScope) {
                PsiElement element = LocalSearchScope.intersectScopeElements(element1, element2);
                if (element == null) continue;
                result2.add(element);
            }
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(PsiUtilCore.toPsiElementArray(result2), null, scope1.myIgnoreInjectedPsi || scope2.myIgnoreInjectedPsi);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersection"));
        }
        return localSearchScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope = this.intersectWith((LocalSearchScope)scope2);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
            }
            return localSearchScope;
        }
        LocalSearchScope nonPhysicalScope = this.tryIntersectNonPhysicalWith((GlobalSearchScope)scope2);
        if (nonPhysicalScope != null) {
            LocalSearchScope localSearchScope = nonPhysicalScope;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = ((GlobalSearchScope)scope2).intersectWith(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        return searchScope;
    }

    @Nullable
    private LocalSearchScope tryIntersectNonPhysicalWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "tryIntersectNonPhysicalWith"));
        }
        Project project = scope.getProject();
        for (PsiElement element : this.myScope) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            if (containingFile.getViewProvider().isPhysical()) {
                return null;
            }
            if (project == null || project == containingFile.getProject()) continue;
            return EMPTY;
        }
        return this;
    }

    @Nullable
    private static PsiElement intersectScopeElements(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectScopeElements"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "intersectScopeElements"));
        }
        if (PsiTreeUtil.isContextAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isContextAncestor(element2, element1, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element1;
        }
        return null;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < this.myScope.length; ++i) {
            PsiElement element = this.myScope[i];
            if (i > 0) {
                result2.append(",");
            }
            result2.append(element);
        }
        return "LocalSearchScope:" + result2;
    }

    @Override
    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "union"));
        }
        if (scope instanceof LocalSearchScope) {
            SearchScope searchScope = this.union((LocalSearchScope)scope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "union"));
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = ((GlobalSearchScope)scope).union(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "union"));
        }
        return globalSearchScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "contains"));
        }
        return this.isInScope(file);
    }

    @NotNull
    public SearchScope union(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "union"));
        }
        if (this.equals(scope2)) {
            LocalSearchScope localSearchScope = this;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "union"));
            }
            return localSearchScope;
        }
        PsiElement[] elements1 = this.getScope();
        PsiElement[] elements2 = scope2.getScope();
        boolean[] united = new boolean[elements2.length];
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        block0: for (PsiElement element1 : elements1) {
            for (int j = 0; j < elements2.length; ++j) {
                PsiElement element2 = elements2[j];
                PsiElement unionElement = LocalSearchScope.scopeElementsUnion(element1, element2);
                if (unionElement == null || unionElement.getContainingFile() == null) continue;
                result2.add(unionElement);
                united[j] = true;
                break block0;
            }
            result2.add(element1);
        }
        for (int i = 0; i < united.length; ++i) {
            boolean b = united[i];
            if (b) continue;
            result2.add(elements2[i]);
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(PsiUtilCore.toPsiElementArray(result2));
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "union"));
        }
        return localSearchScope;
    }

    private static PsiElement scopeElementsUnion(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "scopeElementsUnion"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "scopeElementsUnion"));
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element2;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        if (commonParent == null) {
            return null;
        }
        return commonParent;
    }

    public boolean isInScope(VirtualFile file) {
        return ArrayUtil.indexOf(this.myVirtualFiles, file) != -1;
    }

    public boolean containsRange(PsiFile file, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "containsRange"));
        }
        for (PsiElement element : this.getScope()) {
            if (file != element.getContainingFile() || !element.getTextRange().contains(range)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static LocalSearchScope getScopeRestrictedByFileTypes(@NotNull LocalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        if (scope == EMPTY) {
            LocalSearchScope localSearchScope = EMPTY;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = ApplicationManager.getApplication().runReadAction(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "lambda$getScopeRestrictedByFileTypes$0"));
            }
            if (fileTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "lambda$getScopeRestrictedByFileTypes$0"));
            }
            PsiElement[] elements = scope.getScope();
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements.length);
            for (PsiElement element : elements) {
                PsiFile containingFile = element.getContainingFile();
                FileType fileType = containingFile.getFileType();
                if (!ArrayUtil.contains(fileType, fileTypes)) continue;
                result2.add(element);
            }
            return result2.isEmpty() ? EMPTY : new LocalSearchScope(PsiUtilCore.toPsiElementArray(result2), scope.getDisplayName(), scope.isIgnoreInjectedPsi());
        });
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        return localSearchScope;
    }
}

