/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.ManualRangeMarker;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnfairTextRange;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerTracker;

class MarkerCache {
    static final Comparator<SelfElementInfo> INFO_COMPARATOR = (info1, info2) -> {
        int o1 = info1.getPsiStartOffset();
        int o2 = info2.getPsiStartOffset();
        if (o1 < 0 || o2 < 0) {
            return o1 >= 0 ? -1 : (o2 >= 0 ? 1 : 0);
        }
        if (o1 != o2) {
            return o1 > o2 ? 1 : -1;
        }
        o1 = info1.getPsiEndOffset();
        if (o1 != (o2 = info2.getPsiEndOffset())) {
            return o1 > o2 ? 1 : -1;
        }
        return (info1.isGreedy() ? 1 : 0) - (info2.isGreedy() ? 1 : 0);
    };
    private final SmartPointerTracker myPointers;
    private UpdatedRanges myUpdatedRanges;

    MarkerCache(SmartPointerTracker pointers) {
        this.myPointers = pointers;
    }

    private UpdatedRanges getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        UpdatedRanges answer;
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedMarkers"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedMarkers"));
        }
        int eventCount = events.size();
        assert (eventCount > 0);
        UpdatedRanges cache2 = this.myUpdatedRanges;
        if (cache2 != null && cache2.myEventCount == eventCount) {
            return cache2;
        }
        if (cache2 != null && cache2.myEventCount < eventCount) {
            answer = MarkerCache.applyEvents(events.subList(cache2.myEventCount, eventCount), cache2);
        } else {
            List<SelfElementInfo> infos2 = this.myPointers.getSortedInfos();
            ManualRangeMarker[] markers = MarkerCache.createMarkers(infos2);
            answer = MarkerCache.applyEvents(events, new UpdatedRanges(0, frozen, infos2, markers));
        }
        this.myUpdatedRanges = answer;
        return answer;
    }

    @NotNull
    private static ManualRangeMarker[] createMarkers(List<SelfElementInfo> infos2) {
        ManualRangeMarker[] markers = new ManualRangeMarker[infos2.size()];
        int i = 0;
        while (i < markers.length) {
            SelfElementInfo info = infos2.get(i);
            boolean greedy = info.isGreedy();
            int start = info.getPsiStartOffset();
            int end = info.getPsiEndOffset();
            markers[i] = new ManualRangeMarker(start, end, greedy, greedy, !greedy, null);
            ++i;
            while (i < markers.length && MarkerCache.rangeEquals(infos2.get(i), start, end, greedy)) {
                markers[i] = markers[i - 1];
                ++i;
            }
        }
        if (markers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "createMarkers"));
        }
        return markers;
    }

    private static boolean rangeEquals(SelfElementInfo info, int start, int end, boolean greedy) {
        return start == info.getPsiStartOffset() && end == info.getPsiEndOffset() && greedy == info.isGreedy();
    }

    private static UpdatedRanges applyEvents(@NotNull List<DocumentEvent> events, UpdatedRanges struct) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "applyEvents"));
        }
        FrozenDocument frozen = struct.myResultDocument;
        ManualRangeMarker[] resultMarkers = (ManualRangeMarker[])struct.myMarkers.clone();
        for (DocumentEvent event : events) {
            DocumentEventImpl corrected;
            FrozenDocument before = frozen;
            if (event instanceof RetargetRangeMarkers) {
                RetargetRangeMarkers retarget = (RetargetRangeMarkers)event;
                corrected = new RetargetRangeMarkers(frozen, retarget.getStartOffset(), retarget.getEndOffset(), retarget.getMoveDestinationOffset());
            } else {
                corrected = new DocumentEventImpl(frozen, event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), event.isWholeTextReplaced(), ((DocumentEventImpl)event).getInitialStartOffset(), ((DocumentEventImpl)event).getInitialOldLength());
                frozen = frozen.applyEvent(event, 0);
            }
            int i = 0;
            while (i < resultMarkers.length) {
                ManualRangeMarker updatedRange;
                int sameMarkersEnd;
                ManualRangeMarker currentRange = resultMarkers[i];
                for (sameMarkersEnd = i + 1; sameMarkersEnd < resultMarkers.length && resultMarkers[sameMarkersEnd] == currentRange; ++sameMarkersEnd) {
                }
                ManualRangeMarker manualRangeMarker = updatedRange = currentRange == null ? null : currentRange.getUpdatedRange(corrected, before);
                while (i < sameMarkersEnd) {
                    resultMarkers[i] = updatedRange;
                    ++i;
                }
            }
        }
        return new UpdatedRanges(struct.myEventCount + events.size(), frozen, struct.mySortedInfos, resultMarkers);
    }

    boolean updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        UpdatedRanges updated = this.getUpdatedMarkers(frozen, events);
        boolean sorted2 = true;
        for (int i = 0; i < updated.myMarkers.length; ++i) {
            SelfElementInfo info = (SelfElementInfo)updated.mySortedInfos.get(i);
            info.setRange(updated.myMarkers[i]);
            if (!sorted2 || i <= 0 || INFO_COMPARATOR.compare((SelfElementInfo)updated.mySortedInfos.get(i - 1), info) <= 0) continue;
            sorted2 = false;
        }
        this.myUpdatedRanges = null;
        return sorted2;
    }

    @Nullable
    TextRange getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        UpdatedRanges struct = this.getUpdatedMarkers(frozen, events);
        int i = Collections.binarySearch(struct.mySortedInfos, info, INFO_COMPARATOR);
        ManualRangeMarker updated = i >= 0 ? struct.myMarkers[i] : null;
        return updated == null ? null : new UnfairTextRange(updated.getStartOffset(), updated.getEndOffset());
    }

    void rangeChanged() {
        this.myUpdatedRanges = null;
    }

    private static class UpdatedRanges {
        private final int myEventCount;
        private final FrozenDocument myResultDocument;
        private final List<SelfElementInfo> mySortedInfos;
        private final ManualRangeMarker[] myMarkers;

        public UpdatedRanges(int eventCount, FrozenDocument resultDocument, List<SelfElementInfo> sortedInfos, ManualRangeMarker[] markers) {
            this.myEventCount = eventCount;
            this.myResultDocument = resultDocument;
            this.mySortedInfos = sortedInfos;
            this.myMarkers = markers;
        }
    }
}

