/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;

public class LightTypeParameterListBuilder
extends LightElement
implements PsiTypeParameterList {
    private final List<PsiTypeParameter> myParameters = new ArrayList<PsiTypeParameter>();
    private PsiTypeParameter[] cached;

    public LightTypeParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    @Override
    public String toString() {
        return "Light type parameter list";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightTypeParameterListBuilder", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiTypeParameter[] getTypeParameters() {
        if (this.cached == null) {
            this.cached = this.myParameters.isEmpty() ? PsiTypeParameter.EMPTY_ARRAY : this.myParameters.toArray(new PsiTypeParameter[this.myParameters.size()]);
        }
        return this.cached;
    }

    @Override
    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        return this.myParameters.indexOf(typeParameter);
    }

    public void addParameter(PsiTypeParameter parameter) {
        this.cached = null;
        this.myParameters.add(parameter);
    }
}

