/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.KeyedExtensionCollector;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileCopyEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileMoveEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector;
    private final List<VirtualFileSystem> myPhysicalFileSystems;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster;
    private final List<Object> myVirtualFileManagerListeners;

    public VirtualFileManagerImpl(@NotNull VirtualFileSystem[] fileSystems, @NotNull MessageBus bus) {
        if (fileSystems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystems", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "<init>"));
        }
        this.myCollector = new KeyedExtensionCollector<VirtualFileSystem, String>("org.jetbrains.kotlin.com.intellij.virtualFileSystem"){

            @Override
            @NotNull
            protected String keyToString(@NotNull String key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$1", "keyToString"));
                }
                String string = key;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$1", "keyToString"));
                }
                return string;
            }
        };
        this.myPhysicalFileSystems = new ArrayList<VirtualFileSystem>();
        this.myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
        this.myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        for (VirtualFileSystem fileSystem : fileSystems) {
            this.registerFileSystem(fileSystem);
        }
        if (LOG.isDebugEnabled()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    private void registerFileSystem(@NotNull VirtualFileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "registerFileSystem"));
        }
        this.myCollector.addExplicitExtension(fileSystem.getProtocol(), fileSystem);
        if (!(fileSystem instanceof CachingVirtualFileSystem)) {
            fileSystem.addVirtualFileListener(this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        this.myPhysicalFileSystems.add(fileSystem);
    }

    @Override
    public long getStructureModificationCount() {
        return 0L;
    }

    @Override
    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List<VirtualFileSystem> systems = this.myCollector.forKey(protocol);
        if (systems.isEmpty()) {
            return null;
        }
        LOG.assertTrue(systems.size() == 1);
        return systems.get(0);
    }

    @Override
    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "findFileByUrl"));
        }
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath(url));
    }

    @Nullable
    private VirtualFileSystem getFileSystemForUrl(String url) {
        String protocol = VirtualFileManagerImpl.extractProtocol(url);
        if (protocol == null) {
            return null;
        }
        return this.getFileSystem(protocol);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileListener"));
        }
        this.myVirtualFileListenerMulticaster.addListener(listener);
    }

    @Override
    public void notifyPropertyChanged(final @NotNull VirtualFile virtualFile2, final @NotNull String property, final Object oldValue, final Object newValue) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "notifyPropertyChanged"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "notifyPropertyChanged"));
        }
        final Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (virtualFile2.isValid() && !application.isDisposed()) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent(this, virtualFile2, property, oldValue, newValue, false));
                            BulkFileListener listener = application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                            listener.before(events);
                            listener.after(events);
                        }
                    });
                }
            }
        };
        application.invokeLater(runnable, ModalityState.NON_MODAL);
    }

    @Override
    public long getModificationCount() {
        return 0L;
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        @Override
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "propertyChanged"));
            }
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "contentsChanged"));
            }
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileCreated"));
            }
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileDeleted"));
            }
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileMoved"));
            }
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileCopied"));
            }
            LOG.debug("fileCopied: file = " + event.getFile() + "originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforeContentsChange"));
            }
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforePropertyChange"));
            }
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforeFileDeletion"));
            }
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        @Override
        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforeFileMovement"));
            }
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }
    }
}

