/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins.cl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents2, PluginId pluginId, String version, File pluginRoot) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader", "<init>"));
        }
        if (parents2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader", "<init>"));
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.myParents = parents2;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList();
        File libDir = new File(pluginRoot, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader", "loadClass"));
        }
        Class c = this.tryLoadingClass(name, resolve2, null);
        if (c == null) {
            throw new ClassNotFoundException(name + " " + this);
        }
        return c;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name, boolean resolve2, @Nullable Set<ClassLoader> visited2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader", "tryLoadingClass"));
        }
        Class c = this.loadClassInsideSelf(name);
        if (c == null) {
            c = this.loadClassFromParents(name, visited2);
        }
        if (c != null) {
            if (resolve2) {
                this.resolveClass(c);
            }
            return c;
        }
        return null;
    }

    @Nullable
    private Class loadClassFromParents(String name, Set<ClassLoader> visited2) {
        for (ClassLoader parent2 : this.myParents) {
            if (visited2 == null) {
                visited2 = ContainerUtilRt.newHashSet(this);
            }
            if (!visited2.add(parent2)) continue;
            if (parent2 instanceof PluginClassLoader) {
                Class c = ((PluginClassLoader)parent2).tryLoadingClass(name, false, visited2);
                if (c == null) continue;
                return c;
            }
            try {
                return parent2.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private synchronized Class loadClassInsideSelf(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader", "loadClassInsideSelf"));
        }
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            c = this._findClass(name);
        }
        catch (IncompatibleClassChangeError e) {
            throw new PluginException("While loading class " + name + ": " + e.getMessage(), e, this.myPluginId);
        }
        catch (UnsupportedClassVersionError e) {
            throw new PluginException("While loading class " + name + ": " + e.getMessage(), e, this.myPluginId);
        }
        if (c != null) {
            PluginManagerCore.addPluginClass(this.myPluginId);
        }
        return c;
    }

    @Override
    public URL findResource(String name) {
        URL resource = this.findResourceImpl(name);
        if (resource != null) {
            return resource;
        }
        for (ClassLoader parent2 : this.myParents) {
            URL parentResource = PluginClassLoader.fetchResource(parent2, name);
            if (parentResource == null) continue;
            return parentResource;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        InputStream stream2 = super.getResourceAsStream(name);
        if (stream2 != null) {
            return stream2;
        }
        for (ClassLoader parent2 : this.myParents) {
            InputStream inputStream = parent2.getResourceAsStream(name);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[this.myParents.length + 1];
        resources[0] = super.findResources(name);
        for (int idx = 0; idx < this.myParents.length; ++idx) {
            resources[idx + 1] = PluginClassLoader.fetchResources(this.myParents[idx], name);
        }
        return new DeepEnumeration(resources);
    }

    @Override
    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    private static URL fetchResource(ClassLoader cl, String resourceName) {
        try {
            Method findResource = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResource");
            return findResource != null ? (URL)findResource.invoke((Object)cl, resourceName) : null;
        }
        catch (Exception e) {
            Logger.getInstance(PluginClassLoader.class).error(e);
            return null;
        }
    }

    private static Enumeration<URL> fetchResources(ClassLoader cl, String resourceName) {
        try {
            Method findResources = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResources");
            Enumeration e = findResources == null ? null : (Enumeration)findResources.invoke((Object)cl, resourceName);
            return e;
        }
        catch (Exception e) {
            Logger.getInstance(PluginClassLoader.class).error(e);
            return null;
        }
    }

    private static Method getFindResourceMethod(Class<?> clClass, String methodName) {
        try {
            Method declaredMethod = clClass.getDeclaredMethod(methodName, String.class);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clClass.getSuperclass();
            if (superclass == null || superclass.equals(Object.class)) {
                return null;
            }
            return PluginClassLoader.getFindResourceMethod(superclass, methodName);
        }
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "]";
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex = 0;

        public DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e = this.myEnumerations[this.myIndex];
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }
}

