/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.DefaultValues;
import org.jetbrains.kotlin.cli.common.arguments.GradleOption;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.Jsr305State;
import org.jetbrains.kotlin.config.JvmTarget;

public class K2JVMCompilerArguments
extends CommonCompilerArguments {
    public static final long serialVersionUID = 0L;
    @Argument(value="-d", valueDescription="<directory|jar>", description="Destination for generated class files")
    public String destination;
    @Argument(value="-classpath", shortName="-cp", valueDescription="<path>", description="Paths where to find user class files")
    public String classpath;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-include-runtime", description="Include Kotlin runtime in to resulting .jar")
    public boolean includeRuntime;
    @GradleOption(value=DefaultValues.StringNullDefault.class)
    @Argument(value="-jdk-home", valueDescription="<path>", description="Path to JDK home directory to include into classpath, if differs from default JAVA_HOME")
    public String jdkHome;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-no-jdk", description="Don't include Java runtime into classpath")
    public boolean noJdk;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="-no-stdlib", description="Don't include Kotlin runtime into classpath")
    public boolean noStdlib;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="-no-reflect", description="Don't include Kotlin reflection implementation into classpath")
    public boolean noReflect;
    @Argument(value="-script", description="Evaluate the script file")
    public boolean script;
    @Argument(value="-script-templates", valueDescription="<fully qualified class name[,]>", description="Script definition template classes")
    public String[] scriptTemplates;
    @Argument(value="-kotlin-home", valueDescription="<path>", description="Path to Kotlin compiler home directory, used for runtime libraries discovery")
    public String kotlinHome;
    @Argument(value="-module-name", description="Module name")
    public String moduleName;
    @GradleOption(value=DefaultValues.JvmTargetVersions.class)
    @Argument(value="-jvm-target", valueDescription="<version>", description="Target version of the generated JVM bytecode (1.6 or 1.8), default is 1.6")
    public String jvmTarget = JvmTarget.DEFAULT.getDescription();
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-java-parameters", description="Generate metadata for Java 1.8 reflection on method parameters")
    public boolean javaParameters;
    @Argument(value="-Xmodule-path", valueDescription="<path>", description="Paths where to find Java 9+ modules")
    public String javaModulePath;
    @Argument(value="-Xadd-modules", valueDescription="<module[,]>", description="Root modules to resolve in addition to the initial modules,\nor all modules on the module path if <module> is ALL-MODULE-PATH")
    public String[] additionalJavaModules;
    @Argument(value="-Xno-call-assertions", description="Don't generate not-null assertion after each invocation of method returning not-null")
    public boolean noCallAssertions;
    @Argument(value="-Xno-param-assertions", description="Don't generate not-null assertions on parameters of methods accessible from Java")
    public boolean noParamAssertions;
    @Argument(value="-Xno-optimize", description="Disable optimizations")
    public boolean noOptimize;
    @Argument(value="-Xreport-perf", description="Report detailed performance statistics")
    public boolean reportPerf;
    @Argument(value="-Xbuild-file", deprecatedName="-module", valueDescription="<path>", description="Path to the .xml build file to compile")
    public String buildFile;
    @Argument(value="-Xmultifile-parts-inherit", description="Compile multifile classes as a hierarchy of parts and facade")
    public boolean inheritMultifileParts;
    @Argument(value="-Xskip-runtime-version-check", description="Allow Kotlin runtime libraries of incompatible versions in the classpath")
    public boolean skipRuntimeVersionCheck;
    @Argument(value="-Xuse-old-class-files-reading", description="Use old class files reading implementation (may slow down the build and should be used in case of problems with the new implementation)")
    public boolean useOldClassFilesReading;
    @Argument(value="-Xdump-declarations-to", valueDescription="<path>", description="Path to JSON file to dump Java to Kotlin declaration mappings")
    public String declarationsOutputPath;
    @Argument(value="-Xsingle-module", description="Combine modules for source files and binary dependencies into a single module")
    public boolean singleModule;
    @Argument(value="-Xadd-compiler-builtins", description="Add definitions of built-in declarations to the compilation classpath (useful with -no-stdlib)")
    public boolean addCompilerBuiltIns;
    @Argument(value="-Xload-builtins-from-dependencies", description="Load definitions of built-in declarations from module dependencies, instead of from the compiler")
    public boolean loadBuiltInsFromDependencies;
    @Argument(value="-Xscript-resolver-environment", valueDescription="<key=value[,]>", description="Script resolver environment in key-value pairs (the value could be quoted and escaped)")
    public String[] scriptResolverEnvironment;
    @Argument(value="-Xuse-javac", description="Use javac for Java source and class files analysis")
    public boolean useJavac;
    @Argument(value="-Xjavac-arguments", valueDescription="<option[,]>", description="Java compiler arguments")
    public String[] javacArguments;
    @Argument(value="-Xjsr305-annotations", valueDescription="{ignore|enable}", description="Specify global behavior for JSR-305 nullability annotations: ignore, or treat as other supported nullability annotations")
    public String jsr305GlobalReportLevel = Jsr305State.DEFAULT.getDescription();
    public String[] friendPaths;

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> configureAnalysisFlags() {
        Map<AnalysisFlag<?>, Object> result2 = super.configureAnalysisFlags();
        for (Jsr305State state2 : Jsr305State.values()) {
            if (!state2.getDescription().equals(this.jsr305GlobalReportLevel)) continue;
            result2.put(AnalysisFlag.getLoadJsr305Annotations(), (Object)state2);
            break;
        }
        Map<AnalysisFlag<?>, Object> map2 = result2;
        if (map2 == null) {
            K2JVMCompilerArguments.$$$reportNull$$$0(0);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments", "configureAnalysisFlags"));
    }
}

