/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J6\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J8\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J6\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "wrappedTypeFactory", "Lorg/jetbrains/kotlin/types/WrappedTypeFactory;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/types/WrappedTypeFactory;)V", "resolveDelegatedPropertyType", "Lorg/jetbrains/kotlin/types/KotlinType;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "scopeForInitializer", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveInitializerType", "scope", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resolveType", "Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorWithInitializerImpl;", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "local", "", "resolveTypeNullable", "setConstantForVariableIfNeeded", "", "variableType", "Companion", "kotlin-compiler"})
public final class VariableTypeAndInitializerResolver {
    private final StorageManager storageManager;
    private final ExpressionTypingServices expressionTypingServices;
    private final TypeResolver typeResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final WrappedTypeFactory wrappedTypeFactory;
    @JvmField
    @NotNull
    public static final SimpleType STUB_FOR_PROPERTY_WITHOUT_TYPE;
    public static final Companion Companion;

    @NotNull
    public final KotlinType resolveType(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scopeForInitializer, @NotNull KtVariableDeclaration variable, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean local) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(scopeForInitializer, "scopeForInitializer");
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KotlinType kotlinType = this.resolveTypeNullable(variableDescriptor, scopeForInitializer, variable, dataFlowInfo, trace, local);
        if (kotlinType != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            return it;
        }
        if (local) {
            trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on((KtVariableDeclaration)((PsiElement)variable)));
        }
        SimpleType simpleType2 = STUB_FOR_PROPERTY_WITHOUT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "STUB_FOR_PROPERTY_WITHOUT_TYPE");
        return simpleType2;
    }

    @Nullable
    public final KotlinType resolveTypeNullable(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scopeForInitializer, @NotNull KtVariableDeclaration variable, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean local) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(scopeForInitializer, "scopeForInitializer");
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtTypeReference propertyTypeRef = variable.getTypeReference();
        if (propertyTypeRef != null) {
            kotlinType = this.typeResolver.resolveType(scopeForInitializer, propertyTypeRef, trace, true);
        } else if (!variable.hasInitializer() && variable instanceof KtProperty && variableDescriptor instanceof VariableDescriptorWithAccessors && ((KtProperty)variable).hasDelegateExpression()) {
            kotlinType = this.resolveDelegatedPropertyType((KtProperty)variable, (VariableDescriptorWithAccessors)((Object)variableDescriptor), scopeForInitializer, dataFlowInfo, trace);
        } else if (variable.hasInitializer()) {
            if (!local) {
                kotlinType = this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, (Function0<? extends KotlinType>)new Function0<KotlinType>(this, variable, trace, scopeForInitializer, dataFlowInfo, variableDescriptor){
                    final /* synthetic */ VariableTypeAndInitializerResolver this$0;
                    final /* synthetic */ KtVariableDeclaration $variable;
                    final /* synthetic */ BindingTrace $trace;
                    final /* synthetic */ LexicalScope $scopeForInitializer;
                    final /* synthetic */ DataFlowInfo $dataFlowInfo;
                    final /* synthetic */ VariableDescriptorWithInitializerImpl $variableDescriptor;

                    @NotNull
                    public final KotlinType invoke() {
                        PreliminaryDeclarationVisitor.Companion.createForDeclaration(this.$variable, this.$trace);
                        KtExpression ktExpression = this.$variable.getInitializer();
                        if (ktExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "variable.initializer!!");
                        KotlinType initializerType = VariableTypeAndInitializerResolver.access$resolveInitializerType(this.this$0, this.$scopeForInitializer, ktExpression, this.$dataFlowInfo, this.$trace);
                        KotlinType kotlinType = DescriptorResolver.transformAnonymousTypeIfNeeded(this.$variableDescriptor, this.$variable, initializerType, this.$trace);
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "transformAnonymousTypeIf\u2026, initializerType, trace)");
                        return kotlinType;
                    }
                    {
                        this.this$0 = variableTypeAndInitializerResolver;
                        this.$variable = ktVariableDeclaration;
                        this.$trace = bindingTrace;
                        this.$scopeForInitializer = lexicalScope;
                        this.$dataFlowInfo = dataFlowInfo;
                        this.$variableDescriptor = variableDescriptorWithInitializerImpl;
                        super(0);
                    }
                });
            } else {
                KtExpression ktExpression = variable.getInitializer();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression, "variable.initializer!!");
                kotlinType = this.resolveInitializerType(scopeForInitializer, ktExpression, dataFlowInfo, trace);
            }
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public final void setConstantForVariableIfNeeded(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scope, @NotNull KtVariableDeclaration variable, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType variableType, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(variable, "variable");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(variableType, "variableType");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (!variable.hasInitializer() || variable.isVar()) {
            return;
        }
        variableDescriptor.setCompileTimeInitializer(this.storageManager.createRecursionTolerantNullableLazyValue((Function0)new Function0<ConstantValue<? extends Object>>(this, variableDescriptor, variableType, variable, scope, dataFlowInfo, trace){
            final /* synthetic */ VariableTypeAndInitializerResolver this$0;
            final /* synthetic */ VariableDescriptorWithInitializerImpl $variableDescriptor;
            final /* synthetic */ KotlinType $variableType;
            final /* synthetic */ KtVariableDeclaration $variable;
            final /* synthetic */ LexicalScope $scope;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ BindingTrace $trace;

            @Nullable
            public final ConstantValue<Object> invoke() {
                if (!DescriptorUtils.shouldRecordInitializerForProperty(this.$variableDescriptor, this.$variableType)) {
                    return null;
                }
                KtExpression initializer2 = this.$variable.getInitializer();
                ExpressionTypingServices expressionTypingServices = VariableTypeAndInitializerResolver.access$getExpressionTypingServices$p(this.this$0);
                KtExpression ktExpression = initializer2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType initializerType = expressionTypingServices.safeGetType(this.$scope, ktExpression, this.$variableType, this.$dataFlowInfo, this.$trace);
                CompileTimeConstant<?> compileTimeConstant = VariableTypeAndInitializerResolver.access$getConstantExpressionEvaluator$p(this.this$0).evaluateExpression(initializer2, this.$trace, initializerType);
                if (compileTimeConstant == null) {
                    return null;
                }
                CompileTimeConstant<?> constant = compileTimeConstant;
                if (constant.getUsesNonConstValAsConstant() && this.$variableDescriptor.isConst()) {
                    this.$trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)initializer2)));
                }
                KotlinType kotlinType = initializerType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "initializerType");
                return constant.toConstantValue(kotlinType);
            }
            {
                this.this$0 = variableTypeAndInitializerResolver;
                this.$variableDescriptor = variableDescriptorWithInitializerImpl;
                this.$variableType = kotlinType;
                this.$variable = ktVariableDeclaration;
                this.$scope = lexicalScope;
                this.$dataFlowInfo = dataFlowInfo;
                this.$trace = bindingTrace;
                super(0);
            }
        }, null));
    }

    private final KotlinType resolveDelegatedPropertyType(KtProperty property, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForInitializer, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        return this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, (Function0<? extends KotlinType>)new Function0<KotlinType>(this, property, variableDescriptor, scopeForInitializer, trace, dataFlowInfo){
            final /* synthetic */ VariableTypeAndInitializerResolver this$0;
            final /* synthetic */ KtProperty $property;
            final /* synthetic */ VariableDescriptorWithAccessors $variableDescriptor;
            final /* synthetic */ LexicalScope $scopeForInitializer;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;

            @NotNull
            public final KotlinType invoke() {
                KtExpression ktExpression = this.$property.getDelegateExpression();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtExpression delegateExpression = ktExpression;
                DelegatedPropertyResolver delegatedPropertyResolver = VariableTypeAndInitializerResolver.access$getDelegatedPropertyResolver$p(this.this$0);
                KtExpression ktExpression2 = delegateExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "delegateExpression");
                KotlinType type2 = delegatedPropertyResolver.resolveDelegateExpression(ktExpression2, this.$property, this.$variableDescriptor, this.$scopeForInitializer, this.$trace, this.$dataFlowInfo);
                DelegatedPropertyResolver delegatedPropertyResolver2 = VariableTypeAndInitializerResolver.access$getDelegatedPropertyResolver$p(this.this$0);
                KtExpression ktExpression3 = delegateExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "delegateExpression");
                KotlinType getterReturnType = delegatedPropertyResolver2.getGetValueMethodReturnType(this.$variableDescriptor, ktExpression3, type2, this.$trace, this.$scopeForInitializer, this.$dataFlowInfo);
                KotlinType kotlinType = getterReturnType;
                if (kotlinType == null) {
                    SimpleType simpleType2 = ErrorUtils.createErrorType("Type from delegate");
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorType(\"Type from delegate\")");
                    kotlinType = simpleType2;
                }
                return kotlinType;
            }
            {
                this.this$0 = variableTypeAndInitializerResolver;
                this.$property = ktProperty;
                this.$variableDescriptor = variableDescriptorWithAccessors;
                this.$scopeForInitializer = lexicalScope;
                this.$trace = bindingTrace;
                this.$dataFlowInfo = dataFlowInfo;
                super(0);
            }
        });
    }

    private final KotlinType resolveInitializerType(LexicalScope scope, KtExpression initializer2, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        KotlinType kotlinType = this.expressionTypingServices.safeGetType(scope, initializer2, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "expressionTypingServices\u2026YPE, dataFlowInfo, trace)");
        return kotlinType;
    }

    public VariableTypeAndInitializerResolver(@NotNull StorageManager storageManager, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull TypeResolver typeResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull WrappedTypeFactory wrappedTypeFactory) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(delegatedPropertyResolver, "delegatedPropertyResolver");
        Intrinsics.checkParameterIsNotNull(wrappedTypeFactory, "wrappedTypeFactory");
        this.storageManager = storageManager;
        this.expressionTypingServices = expressionTypingServices;
        this.typeResolver = typeResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.wrappedTypeFactory = wrappedTypeFactory;
    }

    static {
        Companion = new Companion(null);
        STUB_FOR_PROPERTY_WITHOUT_TYPE = ErrorUtils.createErrorType("No type, no body");
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveInitializerType(VariableTypeAndInitializerResolver $this, @NotNull LexicalScope scope, @NotNull KtExpression initializer2, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        return $this.resolveInitializerType(scope, initializer2, dataFlowInfo, trace);
    }

    @NotNull
    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$p(VariableTypeAndInitializerResolver $this) {
        return $this.expressionTypingServices;
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$getConstantExpressionEvaluator$p(VariableTypeAndInitializerResolver $this) {
        return $this.constantExpressionEvaluator;
    }

    @NotNull
    public static final /* synthetic */ DelegatedPropertyResolver access$getDelegatedPropertyResolver$p(VariableTypeAndInitializerResolver $this) {
        return $this.delegatedPropertyResolver;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver$Companion;", "", "()V", "STUB_FOR_PROPERTY_WITHOUT_TYPE", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/annotations/NotNull;", "kotlin-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

