/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.MarkerCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class SmartPointerTracker {
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized boolean addReference(@NotNull PointerReference reference, @NotNull SmartPsiElementPointerImpl pointer) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker", "addReference"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker", "addReference"));
        }
        if (!this.isActual(reference.file, reference.key)) {
            return false;
        }
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
            assert (this.isActual(reference.file, reference.key));
        }
        assert (this.references[this.nextAvailableIndex] == null) : this.references[this.nextAvailableIndex];
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
        return true;
    }

    boolean isActual(VirtualFile file2, Key<SmartPointerTracker> key) {
        return file2.getUserData(key) == this;
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index2 = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index2++, ref);
        }
        assert (index2 == this.size) : index2 + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index2;
    }

    synchronized void removeReference(@NotNull PointerReference reference, @NotNull Key<SmartPointerTracker> expectedKey) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker", "removeReference"));
        }
        if (expectedKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKey", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker", "removeReference"));
        }
        int index2 = reference.index;
        if (index2 < 0) {
            return;
        }
        this.assertActual(expectedKey, reference.file, reference.key);
        assert (this.references[index2] == reference) : "At " + index2 + " expected " + reference + ", found " + this.references[index2];
        this.references[index2].index = -1;
        this.references[index2] = null;
        if (--this.size == 0) {
            reference.file.replace(reference.key, this, null);
        }
    }

    private void assertActual(Key<SmartPointerTracker> expectedKey, VirtualFile file2, Key<SmartPointerTracker> refKey) {
        assert (this.isActual(file2, refKey)) : "Smart pointer list mismatch mismatch: ref.key=" + expectedKey + ", manager.key=" + refKey + (file2.getUserData(refKey) != null ? "; has another pointer list" : "");
    }

    private void processAlivePointers(@NotNull Processor<SmartPsiElementPointerImpl> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker", "processAlivePointers"));
        }
        for (int i = 0; i < this.nextAvailableIndex; ++i) {
            PointerReference ref = this.references[i];
            if (ref == null) continue;
            assert (this.isActual(ref.file, ref.key));
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref, ref.key);
                continue;
            }
            if (processor.process(pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers = new ArrayList();
            this.processAlivePointers(new CommonProcessors.CollectProcessor<SmartPsiElementPointerImpl>(pointers));
            assert (this.size == pointers.size());
            pointers.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerTracker.storePointerReference(this.references, i, ((SmartPsiElementPointerImpl)pointers.get((int)i)).pointerReference);
            }
            Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(FrozenDocument frozen, List<DocumentEvent> events) {
        boolean stillSorted = this.markerCache.updateMarkers(frozen, events);
        if (!stillSorted) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(SelfElementInfo info, FrozenDocument document, List<DocumentEvent> events) {
        return this.markerCache.getUpdatedRange(info, document, events);
    }

    synchronized void switchStubToAst(AnchorElementInfo info, PsiElement element) {
        info.switchToTreeRange(element);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts() {
        SmartPointerTracker.processQueue();
        this.processAlivePointers(pointer -> {
            pointer.getElementInfo().fastenBelt();
            return true;
        });
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers(pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        pointer.cacheElement(pointer.doRestoreElement());
    }

    private static void storePointerReference(PointerReference[] references, int index2, PointerReference ref) {
        references[index2] = ref;
        ref.index = index2;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList<SelfElementInfo> infos = ContainerUtil.newArrayListWithCapacity(this.size);
        this.processAlivePointers(pointer -> {
            SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
            if (!info.hasRange()) {
                return false;
            }
            infos.add(info);
            return true;
        });
        return infos;
    }

    synchronized int getSize() {
        return this.size;
    }

    static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            SmartPointerTracker pointers = (SmartPointerTracker)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.removeReference(reference, reference.key);
        }
    }

    static {
        LowMemoryWatcher.register(() -> SmartPointerTracker.processQueue(), ApplicationManager.getApplication());
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<SmartPointerTracker> key;
        private int index;

        PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Key<SmartPointerTracker> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference", "<init>"));
            }
            super(pointer, ourQueue);
            this.index = -2;
            this.file = containingFile;
            this.key = key;
            pointer.pointerReference = this;
        }
    }
}

