/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

public class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final LightClassGenerationSupport lightClassGenerationSupport;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        if (project == null) {
            JavaElementFinder.$$$reportNull$$$0(0);
        }
        for (PsiElementFinder extension : extensions = Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            JavaElementFinder javaElementFinder = (JavaElementFinder)extension;
            if (javaElementFinder == null) {
                JavaElementFinder.$$$reportNull$$$0(1);
            }
            return javaElementFinder;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        if (project == null) {
            JavaElementFinder.$$$reportNull$$$0(2);
        }
        if (lightClassGenerationSupport == null) {
            JavaElementFinder.$$$reportNull$$$0(3);
        }
        this.project = project;
        this.psiManager = PsiManager.getInstance(project);
        this.lightClassGenerationSupport = lightClassGenerationSupport;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        PsiClass[] allClasses;
        if (qualifiedName2 == null) {
            JavaElementFinder.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(5);
        }
        return (allClasses = this.findClasses(qualifiedName2, scope)).length > 0 ? allClasses[0] : null;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        if (qualifiedNameString == null) {
            JavaElementFinder.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(7);
        }
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaElementFinder.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName2 = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName2, scope, answer);
        answer.addAll(this.lightClassGenerationSupport.getFacadeClasses(qualifiedName2, scope));
        answer.addAll(this.lightClassGenerationSupport.getKotlinInternalClasses(qualifiedName2, scope));
        PsiClass[] psiClassArray = JavaElementFinder.sortByClasspath(answer, scope).toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            JavaElementFinder.$$$reportNull$$$0(9);
        }
        return psiClassArray;
    }

    private void findClassesAndObjects(FqName qualifiedName2, GlobalSearchScope scope, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName2, scope, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName2, scope);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = LightClassUtilsKt.toLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private void findInterfaceDefaultImpls(FqName qualifiedName2, GlobalSearchScope scope, List<PsiClass> answer) {
        if (qualifiedName2.isRoot()) {
            return;
        }
        if (!qualifiedName2.shortName().asString().equals("DefaultImpls")) {
            return;
        }
        for (KtClassOrObject classOrObject : this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName2.parent(), scope)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            if (!(classOrObject instanceof KtClass) || !((KtClass)classOrObject).isInterface() || (interfaceClass = LightClassUtilsKt.toLightClass(classOrObject)) == null || (implsClass = interfaceClass.findInnerClassByName("DefaultImpls", false)) == null) continue;
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaElementFinder.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(11);
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        HashSet<String> answer = Sets.newHashSet();
        answer.addAll(this.lightClassGenerationSupport.getFacadeNames(packageFQN, scope));
        for (KtClassOrObject declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            answer.add(name);
        }
        HashSet<String> hashSet = answer;
        if (hashSet == null) {
            JavaElementFinder.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (qualifiedNameString == null) {
            JavaElementFinder.$$$reportNull$$$0(13);
        }
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope(this.project);
        if (this.lightClassGenerationSupport.packageExists(fqName2, allScope)) {
            return new KtLightPackage(this.psiManager, fqName2, allScope);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaElementFinder.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(15);
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.lightClassGenerationSupport.getSubPackages(packageFQN, scope);
        Collection<PsiPackage> answer = Collections2.transform(subpackages, input -> {
            if (scope == null) {
                JavaElementFinder.$$$reportNull$$$0(31);
            }
            return new KtLightPackage(this.psiManager, (FqName)input, scope);
        });
        PsiPackage[] psiPackageArray = answer.toArray(new PsiPackage[answer.size()]);
        if (psiPackageArray == null) {
            JavaElementFinder.$$$reportNull$$$0(16);
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaElementFinder.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(18);
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.lightClassGenerationSupport.getFacadeClassesInPackage(packageFQN, scope));
        Collection<KtClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        for (KtClassOrObject declaration : declarations) {
            KtLightClass aClass2 = LightClassUtilsKt.toLightClass(declaration);
            if (aClass2 == null) continue;
            answer.add(aClass2);
        }
        PsiClass[] psiClassArray = JavaElementFinder.sortByClasspath(answer, scope).toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            JavaElementFinder.$$$reportNull$$$0(19);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaElementFinder.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(21);
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtFile> result2 = this.lightClassGenerationSupport.findFilesForPackage(packageFQN, scope);
        PsiFile[] psiFileArray = result2.toArray(new PsiFile[result2.size()]);
        if (psiFileArray == null) {
            JavaElementFinder.$$$reportNull$$$0(22);
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaElementFinder.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            JavaElementFinder.$$$reportNull$$$0(24);
        }
        return input -> {
            if (psiPackage == null) {
                JavaElementFinder.$$$reportNull$$$0(30);
            }
            if (!(input instanceof KtFile)) {
                return true;
            }
            return psiPackage.getQualifiedName().equals(((KtFile)input).getPackageFqName().asString());
        };
    }

    @NotNull
    public static Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            JavaElementFinder.$$$reportNull$$$0(25);
        }
        Comparator comparator = (o1, o2) -> {
            VirtualFile f2;
            VirtualFile f1;
            if (searchScope == null) {
                JavaElementFinder.$$$reportNull$$$0(29);
            }
            if ((f1 = PsiUtilCore.getVirtualFile(o1)) == (f2 = PsiUtilCore.getVirtualFile(o2))) {
                return 0;
            }
            if (f1 == null) {
                return -1;
            }
            if (f2 == null) {
                return 1;
            }
            return searchScope.compare(f2, f1);
        };
        if (comparator == null) {
            JavaElementFinder.$$$reportNull$$$0(26);
        }
        return comparator;
    }

    private static Collection<PsiClass> sortByClasspath(@NotNull List<PsiClass> classes2, @NotNull GlobalSearchScope searchScope) {
        if (classes2 == null) {
            JavaElementFinder.$$$reportNull$$$0(27);
        }
        if (searchScope == null) {
            JavaElementFinder.$$$reportNull$$$0(28);
        }
        if (classes2.size() > 1) {
            ContainerUtil.quickSort(classes2, JavaElementFinder.byClasspathComparator(searchScope));
        }
        return classes2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/asJava/finder/JavaElementFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lightClassGenerationSupport";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNameString";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/asJava/finder/JavaElementFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "byClasspathComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFilesFilter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "byClasspathComparator";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sortByClasspath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byClasspathComparator$169";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPackageFilesFilter$168";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSubPackages$167";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

