/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;

public class JetTestFunctionDetector {
    private JetTestFunctionDetector() {
    }

    private static boolean isTest(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(0);
        }
        Annotations annotations2 = functionDescriptor.getAnnotations();
        for (AnnotationDescriptor annotation2 : annotations2) {
            KotlinType type2 = annotation2.getType();
            String name = type2.toString();
            if (!name.equals("Test")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<FunctionDescriptor> getTestFunctionDescriptors(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(1);
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        JetTestFunctionDetector.getTestFunctions(FqName.ROOT, moduleDescriptor, answer);
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void getTestFunctions(@NotNull FqName packageName, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<FunctionDescriptor> foundFunctions) {
        if (packageName == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(3);
        }
        if (moduleDescriptor == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(4);
        }
        if (foundFunctions == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(5);
        }
        for (PackageFragmentDescriptor packageDescriptor : moduleDescriptor.getPackage(packageName).getFragments()) {
            if (DescriptorUtils.getContainingModule(packageDescriptor) != moduleDescriptor) continue;
            Collection<DeclarationDescriptor> descriptors = packageDescriptor.getMemberScope().getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER());
            for (DeclarationDescriptor descriptor2 : descriptors) {
                if (!(descriptor2 instanceof ClassDescriptor)) continue;
                JetTestFunctionDetector.getTestFunctions((ClassDescriptor)descriptor2, foundFunctions);
            }
        }
        for (FqName subpackageName : moduleDescriptor.getSubPackagesOf(packageName, MemberScope.Companion.getALL_NAME_FILTER())) {
            JetTestFunctionDetector.getTestFunctions(subpackageName, moduleDescriptor, foundFunctions);
        }
    }

    private static void getTestFunctions(@NotNull ClassDescriptor classDescriptor, @NotNull List<FunctionDescriptor> foundFunctions) {
        if (classDescriptor == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(6);
        }
        if (foundFunctions == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(7);
        }
        if (classDescriptor.getModality() == Modality.ABSTRACT) {
            return;
        }
        Collection<DeclarationDescriptor> allDescriptors2 = classDescriptor.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.FUNCTIONS, MemberScope.Companion.getALL_NAME_FILTER());
        List<FunctionDescriptor> testFunctions = ContainerUtil.mapNotNull(allDescriptors2, descriptor2 -> {
            FunctionDescriptor functionDescriptor;
            if (descriptor2 instanceof FunctionDescriptor && JetTestFunctionDetector.isTest(functionDescriptor = (FunctionDescriptor)descriptor2)) {
                return functionDescriptor;
            }
            return null;
        });
        foundFunctions.addAll(testFunctions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundFunctions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFunctionDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunctionDescriptors";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunctions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

