/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.IntervalTreeImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RedBlackTree;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T> {
    private final PrioritizedDocumentListener myListener;
    private final Document myDocument;

    protected RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "<init>"));
        }
        this.myDocument = document;
        this.myListener = new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 40;
            }

            @Override
            public void beforeDocumentChange(DocumentEvent event) {
            }

            @Override
            public void documentChanged(DocumentEvent e) {
                RangeMarkerTree.this.updateMarkersOnChange(e);
            }
        };
        document.addDocumentListener(this.myListener);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i1", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        if (i2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i2", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose() {
        this.myDocument.removeDocumentListener(this.myListener);
    }

    @Override
    protected void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "checkBelongsToTheTree"));
        }
        assert (interval.getDocument() == this.myDocument);
        super.checkBelongsToTheTree(interval, assertInvalid);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "lookupNode"));
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "setNode"));
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "updateMarkersOnChange"));
        }
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            ++this.modCount;
            SmartList<IntervalTreeImpl.IntervalNode<T>> affected = new SmartList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (int i = affected.size() - 1; i >= 0; --i) {
                    IntervalTreeImpl.IntervalNode intervalNode = (IntervalTreeImpl.IntervalNode)affected.get(i);
                    int startOffset = intervalNode.intervalStart();
                    int endOffset = intervalNode.intervalEnd();
                    this.removeNode(intervalNode);
                    this.checkMax(false);
                    intervalNode.clearDelta();
                    intervalNode.setParent(null);
                    intervalNode.setLeft(null);
                    intervalNode.setRight(null);
                    intervalNode.setValid(true);
                    assert (intervalNode.intervalStart() == startOffset);
                    assert (intervalNode.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                    List keys2 = intervalNode.intervals;
                    if (keys2.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i = keys2.size() - 1; i >= 0; --i) {
                        Getter key = keys2.get(i);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        intervalNode.removeIntervalInternal(i);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        this.findOrInsertWithIntervals(intervalNode);
                        assert (marker.isValid());
                        continue;
                    }
                    intervalNode.setValid(false);
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root = this.getRoot();
            assert (root == null || root.maxEnd + root.delta <= this.myDocument.getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            for (Getter key : node.intervals) {
                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                if (interval == null) continue;
                insertedNode.addInterval(interval);
            }
        }
    }

    private boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root, @NotNull DocumentEvent e, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        int offset2 = e.getOffset();
        int affectedEndOffset = offset2 + e.getOldLength();
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (offset2 <= maxEnd) {
            if (affectedEndOffset < root.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, affected);
                this.correctMax(root, 0);
            } else {
                if (offset2 <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), e, affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), e, affected);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

