/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.DefaultValues;
import org.jetbrains.kotlin.cli.common.arguments.GradleOption;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public abstract class CommonCompilerArguments
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final String PLUGIN_OPTION_FORMAT = "plugin:<pluginId>:<optionName>=<value>";
    @GradleOption(value=DefaultValues.LanguageVersions.class)
    @Argument(value="-language-version", valueDescription="<version>", description="Provide source compatibility with specified language version")
    public String languageVersion;
    @GradleOption(value=DefaultValues.LanguageVersions.class)
    @Argument(value="-api-version", valueDescription="<version>", description="Allow to use declarations only from the specified version of bundled libraries")
    public String apiVersion;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-nowarn", description="Generate no warnings")
    public boolean suppressWarnings;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-verbose", description="Enable verbose logging output")
    public boolean verbose;
    @Argument(value="-version", description="Display compiler version")
    public boolean version;
    @Argument(value="-help", shortName="-h", description="Print a synopsis of standard options")
    public boolean help;
    @Argument(value="-X", description="Print a synopsis of advanced options")
    public boolean extraHelp;
    @Argument(value="-P", valueDescription="plugin:<pluginId>:<optionName>=<value>", description="Pass an option to a plugin")
    public String[] pluginOptions;
    @Argument(value="-Xno-inline", description="Disable method inlining")
    public boolean noInline;
    @Argument(value="-Xrepeat", valueDescription="<count>", description="Repeat compilation (for performance analysis)")
    public String repeat;
    @Argument(value="-Xskip-metadata-version-check", description="Load classes with bad metadata version anyway (incl. pre-release classes)")
    public boolean skipMetadataVersionCheck;
    @Argument(value="-Xallow-kotlin-package", description="Allow compiling code in package 'kotlin'")
    public boolean allowKotlinPackage;
    @Argument(value="-Xreport-output-files", description="Report source to output files mapping")
    public boolean reportOutputFiles;
    @Argument(value="-Xplugin", valueDescription="<path>", description="Load plugins from the given classpath")
    public String[] pluginClasspaths;
    @Argument(value="-Xmulti-platform", description="Enable experimental language support for multi-platform projects")
    public boolean multiPlatform;
    @Argument(value="-Xno-check-impl", description="Do not check presence of 'impl' modifier in multi-platform projects")
    public boolean noCheckImpl;
    @Argument(value="-Xintellij-plugin-root", valueDescription="<path>", description="Path to the kotlin-compiler.jar or directory where IntelliJ configuration files can be found")
    public String intellijPluginRoot;
    @Argument(value="-Xcoroutines", valueDescription="{enable|warn|error}", description="Enable coroutines or report warnings or errors on declarations and use sites of 'suspend' modifier")
    public String coroutinesState = "warn";
    public List<String> freeArgs = new SmartList<String>();
    public transient ArgumentParseErrors errors = new ArgumentParseErrors();
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    public static final String ENABLE = "enable";

    @NotNull
    public static CommonCompilerArguments createDefaultInstance() {
        DummyImpl dummyImpl = new DummyImpl();
        if (dummyImpl == null) {
            CommonCompilerArguments.$$$reportNull$$$0(0);
        }
        return dummyImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments", "createDefaultInstance"));
    }

    public static final class DummyImpl
    extends CommonCompilerArguments {
    }
}

