/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.utils.Printer;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static LexicalScope makeScopeForPropertyHeader(@NotNull LexicalScope parent2, final @NotNull PropertyDescriptor propertyDescriptor) {
        if (parent2 == null) {
            ScopeUtils.$$$reportNull$$$0(0);
        }
        if (propertyDescriptor == null) {
            ScopeUtils.$$$reportNull$$$0(1);
        }
        return new LexicalScopeImpl(parent2, propertyDescriptor, false, null, LexicalScopeKind.PROPERTY_HEADER, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            @Override
            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (TypeParameterDescriptor typeParameterDescriptor : propertyDescriptor.getTypeParameters()) {
                    handler2.addClassifierDescriptor(typeParameterDescriptor);
                }
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public static LexicalScope makeScopeForPropertyInitializer(@NotNull LexicalScope propertyHeader, @NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyHeader == null) {
            ScopeUtils.$$$reportNull$$$0(2);
        }
        if (propertyDescriptor == null) {
            ScopeUtils.$$$reportNull$$$0(3);
        }
        LexicalScopeImpl lexicalScopeImpl = new LexicalScopeImpl(propertyHeader, propertyDescriptor, false, null, LexicalScopeKind.PROPERTY_INITIALIZER_OR_DELEGATE);
        if (lexicalScopeImpl == null) {
            ScopeUtils.$$$reportNull$$$0(4);
        }
        return lexicalScopeImpl;
    }

    @NotNull
    public static LexicalScope makeScopeForDelegateConventionFunctions(@NotNull LexicalScope parent2, @NotNull VariableDescriptorWithAccessors variableDescriptor) {
        if (parent2 == null) {
            ScopeUtils.$$$reportNull$$$0(5);
        }
        if (variableDescriptor == null) {
            ScopeUtils.$$$reportNull$$$0(6);
        }
        LexicalScopeImpl lexicalScopeImpl = new LexicalScopeImpl(parent2, variableDescriptor, true, variableDescriptor.getExtensionReceiverParameter(), LexicalScopeKind.PROPERTY_DELEGATE_METHOD);
        if (lexicalScopeImpl == null) {
            ScopeUtils.$$$reportNull$$$0(7);
        }
        return lexicalScopeImpl;
    }

    @NotNull
    public static String printStructure(@Nullable MemberScope scope) {
        StringBuilder out = new StringBuilder();
        Printer p = new Printer(out);
        if (scope == null) {
            p.println("null");
        } else {
            scope.printScopeStructure(p);
        }
        String string = out.toString();
        if (string == null) {
            ScopeUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyHeader";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/scopes/ScopeUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/scopes/ScopeUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeScopeForPropertyInitializer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "makeScopeForDelegateConventionFunctions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "printStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForPropertyHeader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForPropertyInitializer";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForDelegateConventionFunctions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

