/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class JavaNameValuePairType
extends JavaStubElementType<PsiNameValuePairStub, PsiNameValuePair> {
    protected JavaNameValuePairType() {
        super("NAME_VALUE_PAIR", true);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "createPsi"));
        }
        return new PsiNameValuePairImpl(node);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        NameValuePairElement nameValuePairElement = new NameValuePairElement();
        if (nameValuePairElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "createCompositeNode"));
        }
        return nameValuePairElement;
    }

    @Override
    public PsiNameValuePairStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        String value = null;
        List<LighterASTNode> children = tree.getChildren(node);
        for (LighterASTNode child : children) {
            if (child.getTokenType() == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getTokenType())) continue;
            value = LightTreeUtil.toFilteredString(tree, child, null);
        }
        return new PsiNameValuePairStubImpl(parentStub, name, value);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "createPsi"));
        }
        return this.getPsiFactory(stub).createNameValuePair(stub);
    }

    @Override
    public void serialize(@NotNull PsiNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        String value = stub.getValue();
        boolean hasValue = value != null;
        dataStream.writeBoolean(hasValue);
        if (hasValue) {
            dataStream.writeUTFFast(value);
        }
    }

    @Override
    @NotNull
    public PsiNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "deserialize"));
        }
        String name = StringRef.toString(dataStream.readName());
        boolean hasValue = dataStream.readBoolean();
        PsiNameValuePairStubImpl psiNameValuePairStubImpl = new PsiNameValuePairStubImpl(parentStub, name, hasValue ? dataStream.readUTFFast() : null);
        if (psiNameValuePairStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "deserialize"));
        }
        return psiNameValuePairStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiNameValuePairStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaNameValuePairType", "indexStub"));
        }
    }
}

