/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;

class PluginXmlPathResolver
implements JDOMXIncluder.PathResolver {
    private final List<File> myPluginJarFiles;

    public PluginXmlPathResolver(File[] filesInLib) {
        this.myPluginJarFiles = ContainerUtil.filter(filesInLib, file2 -> FileUtil.isJarOrZip(file2));
    }

    @Override
    @NotNull
    public URL resolvePath(@NotNull String relativePath, @Nullable String base) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginXmlPathResolver", "resolvePath"));
        }
        URL url = JDOMXIncluder.DEFAULT_PATH_RESOLVER.resolvePath(relativePath, base);
        if (URLUtil.resourceExists(url) == ThreeState.NO) {
            for (File jarFile : this.myPluginJarFiles) {
                URL uRL;
                try {
                    URL entryURL = URLUtil.getJarEntryURL(jarFile, relativePath);
                    if (URLUtil.resourceExists(entryURL) != ThreeState.YES) continue;
                    uRL = entryURL;
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
                if (uRL == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginXmlPathResolver", "resolvePath"));
                }
                return uRL;
            }
        }
        URL uRL = url;
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginXmlPathResolver", "resolvePath"));
        }
        return uRL;
    }
}

