/* The following code was generated by JFlex 1.7.0-SNAPSHOT tweaked for IntelliJ platform */

package org.jetbrains.kotlin.kdoc.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.lang.Character;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0-SNAPSHOT
 * from the specification file <tt>/home/user/Workspace/Kotlin/kotlin/compiler/frontend/src/org/jetbrains/kotlin/kdoc/lexer/KDoc.flex</tt>
 */
class _KDocLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int LINE_BEGINNING = 2;
  public static final int CONTENTS_BEGINNING = 4;
  public static final int TAG_BEGINNING = 6;
  public static final int TAG_TEXT_BEGINNING = 8;
  public static final int CONTENTS = 10;
  public static final int CODE_BLOCK = 12;
  public static final int CODE_BLOCK_LINE_BEGINNING = 14;
  public static final int CODE_BLOCK_CONTENTS_BEGINNING = 16;
  public static final int INDENTED_CODE_BLOCK = 18;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  6, 6
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [11, 6, 4]
   * Total runtime size is 9472 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>10]<<6)|((ch>>4)&0x3f)]<<4)|(ch&0xf)];
  }

  /* The ZZ_CMAP_Z table has 1088 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\3\11\1\12\6\13\1\14\23\13\1\15\1\13"+
    "\1\16\1\11\12\13\1\17\10\11\1\20\1\21\1\22\1\23\1\24\62\11\1\25\12\11\51\13"+
    "\1\26\24\11\1\27\u0381\11");

  /* The ZZ_CMAP_Y table has 1536 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\1\1\11\1\12\1\13\1\14\1\13\1\14\23"+
    "\13\1\15\1\1\7\13\1\16\1\17\1\20\10\1\1\21\1\22\1\13\1\23\1\13\1\24\2\13\1"+
    "\25\10\13\1\26\3\13\1\24\2\13\1\27\1\13\2\1\1\30\1\13\1\31\1\30\1\13\1\32"+
    "\4\1\1\13\1\33\1\34\2\1\1\30\2\33\1\1\1\35\1\30\5\13\1\36\1\37\1\40\1\1\1"+
    "\41\1\13\1\1\1\42\3\1\2\13\1\43\1\44\24\1\1\45\2\13\1\46\1\1\1\47\1\17\1\1"+
    "\1\50\1\51\1\52\1\53\1\1\1\54\1\17\1\55\1\56\1\51\1\52\1\57\1\1\1\60\1\1\1"+
    "\61\1\62\1\23\1\52\1\63\1\1\1\64\1\17\1\44\1\50\1\51\1\52\1\63\1\1\1\54\1"+
    "\17\1\44\1\65\1\66\1\67\1\70\3\1\1\71\1\72\1\41\1\52\1\73\2\1\1\17\1\1\1\72"+
    "\1\41\1\52\1\74\1\1\1\75\1\17\1\1\1\72\1\41\1\52\1\76\2\1\1\17\1\1\1\77\1"+
    "\100\1\13\1\101\1\15\3\1\1\30\2\13\1\102\1\15\3\1\1\103\1\104\1\105\1\106"+
    "\1\107\1\110\2\1\1\64\3\1\1\111\1\13\1\33\1\1\1\112\7\1\2\13\1\113\2\1\1\43"+
    "\4\1\2\13\1\43\2\13\1\114\5\13\1\115\4\13\1\116\4\13\1\76\1\14\3\13\2\117"+
    "\2\13\1\117\1\13\1\24\2\120\1\14\1\24\1\13\1\24\1\120\2\13\1\14\1\33\4\1\5"+
    "\13\1\121\1\30\45\13\1\122\1\15\1\30\1\33\4\13\1\123\1\64\1\124\1\17\1\13"+
    "\1\17\1\13\1\17\1\124\1\64\3\13\1\55\1\1\1\125\4\1\5\13\1\32\2\13\1\114\5"+
    "\1\1\13\1\126\3\1\1\13\1\127\1\121\70\1\6\13\1\130\11\1\11\13\1\130\5\13\1"+
    "\76\1\13\1\131\2\13\1\131\1\132\1\13\1\127\3\13\1\133\1\134\1\135\1\126\1"+
    "\134\2\1\1\136\1\137\1\64\1\140\1\1\1\141\2\1\1\13\1\17\4\1\1\142\1\143\1"+
    "\144\1\145\1\146\1\1\2\13\1\55\147\1\1\147\1\1\1\150\1\151\1\30\4\13\1\152"+
    "\1\30\5\13\1\77\1\13\1\126\1\30\4\13\1\24\1\1\1\13\1\32\3\1\1\13\40\1\133"+
    "\13\1\43\4\1\132\13\1\43\5\1\10\13\1\126\67\1\72\13\1\55\25\1\22\13\1\127"+
    "\3\13\1\33\11\1\1\15\1\153\1\52\1\154\1\155\6\13\1\17\1\1\1\156\25\13\1\127"+
    "\1\1\4\13\1\157\2\13\1\32\2\1\1\126\3\1\1\160\1\42\1\1\1\71\1\161\7\13\1\126"+
    "\1\140\1\1\1\30\1\162\1\30\1\33\1\77\4\13\1\24\1\163\1\164\1\165\1\1\1\166"+
    "\1\13\1\14\1\167\2\127\2\1\7\13\1\33\40\1\1\13\1\24\1\1\1\13\1\33\3\1\1\13"+
    "\1\127\6\1\11\13\1\127\66\1\1\170\2\13\1\171\74\1\5\13\1\161\3\13\1\124\1"+
    "\172\1\173\1\174\3\13\1\175\1\176\1\13\1\177\1\200\1\41\24\13\1\201\1\13\1"+
    "\41\1\202\1\13\1\202\1\13\1\161\1\13\1\161\1\24\1\13\1\24\1\13\1\52\1\13\1"+
    "\52\1\13\1\203\3\1\55\13\1\15\22\1\41\13\1\127\36\1");

  /* The ZZ_CMAP_A table has 2112 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\1\1\11\1\12\1\13\1\12\22\0\1\17\3\0\1\3\3\0\1\21\1\22\1\15\3\0\1\4"+
    "\1\14\12\2\6\0\1\16\32\3\1\5\1\20\1\6\1\0\1\3\1\7\32\3\3\0\1\10\6\0\1\12\14"+
    "\0\4\3\4\0\1\3\12\0\1\3\4\0\1\3\5\0\27\3\1\0\17\3\11\0\2\3\4\0\14\3\16\0\5"+
    "\3\11\0\1\3\13\0\1\3\13\0\1\3\1\0\3\3\1\0\1\3\1\0\4\3\1\0\34\3\1\0\6\3\1\0"+
    "\5\3\4\0\2\3\10\0\14\3\2\0\2\3\7\0\26\3\2\0\1\3\6\0\10\3\10\0\13\3\5\0\3\3"+
    "\33\0\6\3\1\0\1\3\17\0\2\3\7\0\2\3\12\0\3\3\2\0\2\3\1\0\16\3\15\0\11\3\13"+
    "\0\1\3\22\0\26\3\3\0\1\3\2\0\1\3\7\0\10\3\5\0\10\3\2\0\2\3\2\0\26\3\1\0\7"+
    "\3\1\0\1\3\3\0\4\3\3\0\1\3\16\0\2\3\1\0\5\3\21\0\6\3\4\0\2\3\1\0\2\3\1\0\2"+
    "\3\1\0\2\3\17\0\4\3\1\0\1\3\3\0\3\3\20\0\11\3\1\0\2\3\1\0\2\3\1\0\5\3\3\0"+
    "\1\3\2\0\1\3\22\0\1\3\1\0\6\3\3\0\3\3\1\0\4\3\3\0\2\3\1\0\1\3\1\0\2\3\3\0"+
    "\2\3\3\0\3\3\3\0\10\3\1\0\3\3\17\0\1\3\13\0\10\3\1\0\6\3\1\0\5\3\6\0\4\3\1"+
    "\0\5\3\3\0\1\3\20\0\1\3\1\0\12\3\13\0\22\3\3\0\10\3\1\0\11\3\1\0\1\3\2\0\1"+
    "\3\1\0\2\3\13\0\1\3\1\0\2\3\1\0\1\3\2\0\2\3\1\0\1\3\2\0\1\3\6\0\4\3\1\0\7"+
    "\3\1\0\3\3\1\0\1\3\1\0\1\3\2\0\2\3\1\0\4\3\1\0\2\3\11\0\1\3\2\0\5\3\1\0\1"+
    "\3\25\0\2\3\2\0\10\3\1\0\7\3\10\0\4\3\4\0\2\3\1\0\5\3\1\0\2\3\5\0\11\3\7\0"+
    "\12\3\5\0\4\3\5\0\17\3\1\0\1\3\1\0\4\3\2\0\1\3\1\0\4\3\2\0\7\3\1\0\5\3\13"+
    "\0\15\3\2\0\14\3\3\0\17\3\1\0\2\3\7\0\1\3\3\0\2\3\3\0\15\3\3\0\16\3\2\0\14"+
    "\3\4\0\6\3\2\0\6\3\2\0\10\3\1\0\1\3\1\0\1\3\1\0\1\3\1\0\6\3\1\0\7\3\1\0\1"+
    "\3\3\0\3\3\1\0\7\3\3\0\4\3\2\0\6\3\14\0\2\12\25\0\1\3\4\0\1\3\14\0\1\3\15"+
    "\0\1\3\2\0\1\3\4\0\1\3\2\0\12\3\1\0\1\3\3\0\5\3\6\0\1\3\1\0\1\3\1\0\1\3\1"+
    "\0\4\3\1\0\3\3\1\0\7\3\3\0\3\3\5\0\5\3\13\0\3\3\11\0\11\3\7\0\5\3\2\0\5\3"+
    "\3\0\7\3\6\0\3\3\3\0\5\3\5\0\1\3\1\0\10\3\1\0\5\3\1\0\1\3\1\0\2\3\1\0\2\3"+
    "\1\0\12\3\3\0\15\3\2\0\16\3\3\0\2\3\13\0\5\3\1\0\25\3\4\0\1\3\2\0\6\3\2\0"+
    "\6\3\2\0\6\3\2\0\3\3\3\0\2\3\3\0\2\3\11\0\14\3\1\0\16\3\1\0\2\3\1\0\7\3\2"+
    "\0\1\3\1\0\14\3\1\0\2\3\3\0\1\3\2\0\1\3\2\0\1\3\2\0\2\3\2\0\4\3\1\0\14\3\1"+
    "\0\1\3\1\0\7\3\1\0\21\3\1\0\4\3\2\0\10\3\1\0\7\3\1\0\14\3\1\0\4\3\1\0\5\3"+
    "\1\0\1\3\3\0\12\3\4\0\23\3\1\0\7\3\1\0\6\3\6\0");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\11\0\3\1\1\2\1\3\3\2\1\4\1\5\1\4"+
    "\3\2\1\6\1\7\2\2\1\10\1\11\3\10\1\12"+
    "\1\0\1\13\6\0\1\4\1\14\1\15\4\0\1\16"+
    "\2\0\1\17\1\4\1\20\1\21\1\0\2\22\1\0"+
    "\1\23\1\3\1\24\1\23";

  private static int [] zzUnpackAction() {
    int [] result = new int[63];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\23\0\46\0\71\0\114\0\137\0\162\0\205"+
    "\0\230\0\253\0\276\0\321\0\253\0\344\0\367\0\u010a"+
    "\0\u011d\0\u0130\0\u0143\0\u0156\0\u0169\0\321\0\u017c\0\u018f"+
    "\0\u01a2\0\u01b5\0\u01c8\0\253\0\u01db\0\321\0\u01ee\0\u0201"+
    "\0\u0214\0\u0227\0\253\0\321\0\u023a\0\u024d\0\u0260\0\u0273"+
    "\0\u0286\0\u0299\0\253\0\u02ac\0\u02bf\0\u02d2\0\u02e5\0\u02f8"+
    "\0\253\0\u030b\0\u031e\0\u0331\0\u0344\0\253\0\253\0\u0357"+
    "\0\u023a\0\u0260\0\u036a\0\u023a\0\u0344\0\u037d\0\253";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[63];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\11\12\3\0\1\13\1\14\5\12\1\15\1\16\3\15"+
    "\1\17\1\15\1\20\1\21\1\22\1\0\1\22\1\15"+
    "\1\23\1\15\1\24\1\25\3\15\1\16\3\15\1\17"+
    "\1\15\1\20\1\21\1\22\1\0\1\22\1\15\1\26"+
    "\1\27\1\24\1\25\3\15\1\30\1\15\1\31\1\15"+
    "\1\32\3\15\1\30\1\0\1\30\1\15\1\26\1\15"+
    "\1\30\4\15\1\30\3\15\1\33\3\15\1\30\1\0"+
    "\1\30\1\15\1\26\1\15\1\30\4\15\1\16\3\15"+
    "\1\17\1\15\1\20\1\21\1\22\1\0\1\22\1\15"+
    "\1\26\1\15\1\24\1\25\2\15\1\34\1\35\7\34"+
    "\1\35\1\0\1\35\1\34\1\36\1\34\1\35\4\34"+
    "\1\35\5\34\1\37\1\40\1\35\1\0\1\35\1\34"+
    "\1\41\1\34\1\35\4\34\1\35\5\34\1\37\1\40"+
    "\1\35\1\0\1\35\1\34\1\36\1\34\1\35\3\34"+
    "\40\0\1\42\21\0\1\43\1\44\6\0\1\16\7\0"+
    "\1\22\1\0\1\22\3\0\1\22\3\0\3\45\1\46"+
    "\1\45\1\0\1\47\14\45\7\0\1\50\23\0\1\51"+
    "\13\0\1\22\7\0\1\22\1\0\1\22\3\0\1\22"+
    "\17\0\1\43\1\23\6\0\1\22\7\0\1\22\1\0"+
    "\1\22\3\0\1\52\10\0\2\53\17\0\1\54\20\0"+
    "\1\30\7\0\1\30\1\0\1\30\3\0\1\30\5\0"+
    "\3\31\21\0\1\55\22\0\1\56\20\0\1\35\7\0"+
    "\1\35\1\0\1\35\3\0\1\35\12\0\1\57\23\0"+
    "\1\60\26\0\1\43\1\41\22\0\1\61\5\0\5\45"+
    "\1\0\1\47\16\45\3\46\1\0\1\62\21\45\1\0"+
    "\1\47\12\45\1\63\1\45\7\0\1\64\23\0\1\64"+
    "\13\0\1\22\7\0\1\22\1\0\1\22\3\0\1\65"+
    "\5\0\2\54\21\0\3\55\1\0\1\66\16\0\3\56"+
    "\1\0\1\67\23\0\1\70\23\0\1\70\12\0\5\71"+
    "\1\0\1\72\12\71\1\63\1\71\5\63\1\73\14\63"+
    "\1\74\11\64\3\0\7\64\1\0\1\22\7\0\1\22"+
    "\1\0\1\22\3\0\1\75\4\0\1\70\7\0\1\76"+
    "\1\0\1\70\3\0\1\70\3\0\22\73\1\77\1\0"+
    "\1\76\11\0\1\76\3\0\1\76\3\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[912];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\11\0\1\11\2\1\1\11\16\1\1\11\5\1\1\0"+
    "\1\11\6\0\1\1\1\11\1\1\4\0\1\11\2\0"+
    "\2\1\2\11\1\0\2\1\1\0\3\1\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[63];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  public _KDocLexer() {
    this((java.io.Reader)null);
  }

  private boolean isLastToken() {
    return zzMarkedPos == zzBuffer.length();
  }

  private boolean yytextContainLineBreaks() {
    return CharArrayUtil.containLineBreaks(zzBuffer, zzStartRead, zzMarkedPos);
  }

  private boolean nextIsNotWhitespace() {
    return zzMarkedPos <= zzBuffer.length() && !Character.isWhitespace(zzBuffer.charAt(zzMarkedPos + 1));
  }

  private boolean prevIsNotWhitespace() {
    return zzMarkedPos != 0 && !Character.isWhitespace(zzBuffer.charAt(zzMarkedPos - 1));
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _KDocLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
      return;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        zzDoEOF();
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return TokenType.BAD_CHARACTER;
            }
          case 21: break;
          case 2: 
            { yybegin(CONTENTS);
        return KDocTokens.TEXT;
            }
          case 22: break;
          case 3: 
            { if(yystate() == CONTENTS_BEGINNING) {
            yybegin(INDENTED_CODE_BLOCK);
            return KDocTokens.CODE_BLOCK_TEXT;
        }
            }
          case 23: break;
          case 4: 
            { if (yytextContainLineBreaks()) {
            yybegin(LINE_BEGINNING);
            return TokenType.WHITE_SPACE;
        }  else {
            yybegin(yystate() == CONTENTS_BEGINNING ? CONTENTS_BEGINNING : CONTENTS);
            return KDocTokens.TEXT;  // internal white space
        }
            }
          case 24: break;
          case 5: 
            { yybegin(CONTENTS_BEGINNING);
                                            return KDocTokens.LEADING_ASTERISK;
            }
          case 25: break;
          case 6: 
            { if (yytextContainLineBreaks()) {
            yybegin(LINE_BEGINNING);
        }
        return TokenType.WHITE_SPACE;
            }
          case 26: break;
          case 7: 
            { yybegin(TAG_TEXT_BEGINNING);
        return KDocTokens.MARKDOWN_LINK;
            }
          case 27: break;
          case 8: 
            { yybegin(yystate() == INDENTED_CODE_BLOCK ? INDENTED_CODE_BLOCK : CODE_BLOCK);
        return KDocTokens.CODE_BLOCK_TEXT;
            }
          case 28: break;
          case 9: 
            { if (yytextContainLineBreaks()) {
            yybegin(yystate() == INDENTED_CODE_BLOCK ? LINE_BEGINNING : CODE_BLOCK_LINE_BEGINNING);
            return TokenType.WHITE_SPACE;
        }
        return KDocTokens.CODE_BLOCK_TEXT;
            }
          case 29: break;
          case 10: 
            { yybegin(CODE_BLOCK_CONTENTS_BEGINNING);
        return KDocTokens.LEADING_ASTERISK;
            }
          case 30: break;
          case 11: 
            { if (isLastToken()) return KDocTokens.END;
                                            else return KDocTokens.TEXT;
            }
          case 31: break;
          case 12: 
            { yybegin(CONTENTS);
        return KDocTokens.MARKDOWN_ESCAPED_CHAR;
            }
          case 32: break;
          case 13: 
            { KDocKnownTag tag = KDocKnownTag.Companion.findByTagName(zzBuffer.subSequence(zzStartRead, zzMarkedPos));
    yybegin(tag != null && tag.isReferenceRequired() ? TAG_BEGINNING : TAG_TEXT_BEGINNING);
    return KDocTokens.TAG_NAME;
            }
          case 33: break;
          case 14: 
            { yybegin(CONTENTS_BEGINNING);
                                            return KDocTokens.START;
            }
          case 34: break;
          case 15: 
            { yybegin(CODE_BLOCK_LINE_BEGINNING);
        return KDocTokens.TEXT;
            }
          case 35: break;
          case 16: 
            { yybegin(TAG_TEXT_BEGINNING);
                  return KDocTokens.MARKDOWN_LINK;
            }
          case 36: break;
          case 17: 
            { yybegin(CONTENTS);
                  return KDocTokens.MARKDOWN_LINK;
            }
          case 37: break;
          case 18: 
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzMarkedPos, -1);
            { yybegin(CONTENTS);
        return KDocTokens.MARKDOWN_LINK;
            }
          case 38: break;
          case 19: 
            { yybegin(CONTENTS);
        return KDocTokens.MARKDOWN_INLINE_LINK;
            }
          case 39: break;
          case 20: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 3);
            { // Code fence end
        yybegin(CONTENTS);
        return KDocTokens.TEXT;
            }
          case 40: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
