/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.resolve.ShadowedExtensionChecker;
import org.jetbrains.kotlin.resolve.TypeAliasExpander;
import org.jetbrains.kotlin.resolve.TypeAliasExpansion;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a6\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 w2\u00020\u0001:\u0002wxB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020'H\u0002J\u0018\u00101\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0016\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u001c\u0010=\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J\u0010\u0010>\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0002J\u0018\u0010?\u001a\u00020\u00182\u0006\u0010-\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\u00182\u0006\u0010-\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0002J\u0016\u0010G\u001a\u00020\u00182\u0006\u0010-\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ \u0010H\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u000207H\u0002J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00020LH\u0002J\u0018\u0010M\u001a\u00020\u00182\u0006\u0010-\u001a\u00020N2\u0006\u0010(\u001a\u00020)H\u0002J \u0010O\u001a\u00020\u00182\u0006\u0010E\u001a\u00020P2\u0006\u0010-\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010U\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u000207H\u0002J\u0018\u0010V\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010W\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010X\u001a\u00020\u00182\u0006\u0010 \u001a\u00020D2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010Y\u001a\u00020\u00182\u0006\u0010E\u001a\u00020\u001aH\u0002J\u0018\u0010Z\u001a\u00020\u00182\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0002J\u0018\u0010_\u001a\u00020\u00182\u0006\u0010-\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010`\u001a\u00020\u00182\u0006\u0010-\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010a\u001a\u00020\u00182\u0006\u0010b\u001a\u00020SH\u0002J\u0010\u0010c\u001a\u00020\u00182\u0006\u0010b\u001a\u00020SH\u0002J\u0010\u0010d\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010e\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010f\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010g\u001a\u00020FH\u0002J\u001e\u0010h\u001a\b\u0012\u0004\u0012\u00020P0i2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020BH\u0002J\u0010\u0010m\u001a\u00020n2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010o\u001a\u00020\u00182\u0006\u0010p\u001a\u00020qJ$\u0010r\u001a\u00020\u00182\f\u0010s\u001a\b\u0012\u0004\u0012\u00020^0t2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020^0vH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\u000b0\u0013R\u00020\u0005\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;)V", "exposedChecker", "Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "Lorg/jetbrains/annotations/NotNull;", "shadowedExtensionChecker", "Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkAnnotationClassWithBody", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "checkConstructorInInterface", "klass", "checkConstructorVisibility", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkHeaderClassConstructor", "checkHeaderFunction", "checkImplTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkLocalTypeAliasDeclaration", "checkMemberProperty", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkProperty", "checkPropertyInitializer", "checkPropertyLateInit", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkTypeAliasDeclaration", "checkTypeAliasExpansion", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "getUsedTypeAliasParameters", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeAlias", "noExplicitTypeOrGetterType", "", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Companion", "TypeAliasDeclarationCheckingReportStrategy", "kotlin-compiler"})
public final class DeclarationsChecker {
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final ExposedVisibilityChecker exposedChecker;
    private final ShadowedExtensionChecker shadowedExtensionChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    private final LanguageVersionSettings languageVersionSettings;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    public static final Companion Companion;

    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        KtDeclarationStub declaration;
        Object object;
        Intrinsics.checkParameterIsNotNull(bodiesResolveContext, "bodiesResolveContext");
        Iterator<Object> iterator2 = bodiesResolveContext.getFiles().iterator();
        while (iterator2.hasNext()) {
            KtFile entry;
            KtFile ktFile = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktFile, "file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            KtFile ktFile2 = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktFile2, "file");
            this.annotationChecker.check(ktFile2, this.trace, null);
        }
        for (Map.Entry entry : bodiesResolveContext.getDeclaredClasses().entrySet()) {
            ClassDescriptorWithResolutionScopes classDescriptor;
            object = entry;
            KtClassOrObject classOrObject = (KtClassOrObject)object.getKey();
            object = entry;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = (ClassDescriptorWithResolutionScopes)object.getValue();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes, "classDescriptor");
            ClassifierDescriptor classifierDescriptor = classDescriptorWithResolutionScopes;
            KtClassOrObject ktClassOrObject = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject, "classOrObject");
            this.checkSupertypesForConsistency(classifierDescriptor, ktClassOrObject);
            KtClassOrObject ktClassOrObject2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject2, "classOrObject");
            this.checkTypesInClassHeader(ktClassOrObject2);
            object = classOrObject;
            if (object instanceof KtClass) {
                KtClass ktClass = (KtClass)classOrObject;
                ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes2, "classDescriptor");
                this.checkClassButNotObject(ktClass, classDescriptorWithResolutionScopes2);
                this.descriptorResolver.checkNamesInConstraints(classOrObject, classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
            } else if (object instanceof KtObjectDeclaration) {
                KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)classOrObject;
                ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes3 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes3, "classDescriptor");
                this.checkObject(ktObjectDeclaration, classDescriptorWithResolutionScopes3);
            }
            KtClassOrObject ktClassOrObject3 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject3, "classOrObject");
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes4 = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes4, "classDescriptor");
            this.checkPrimaryConstructor(ktClassOrObject3, classDescriptorWithResolutionScopes4);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptor);
            KtClassOrObject ktClassOrObject4 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject4, "classOrObject");
            this.identifierChecker.checkDeclaration(ktClassOrObject4, this.trace);
            KtClassOrObject ktClassOrObject5 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject5, "classOrObject");
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes5 = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes5, "classDescriptor");
            this.exposedChecker.checkClassHeader(ktClassOrObject5, classDescriptorWithResolutionScopes5);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            object = entry;
            KtNamedFunction function2 = (KtNamedFunction)object.getKey();
            object = entry;
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)object.getValue();
            KtNamedFunction ktNamedFunction = function2;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedFunction, "function");
            SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor, "functionDescriptor");
            this.checkFunction(ktNamedFunction, simpleFunctionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(function2, functionDescriptor);
            KtNamedFunction ktNamedFunction2 = function2;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedFunction2, "function");
            this.identifierChecker.checkDeclaration(ktNamedFunction2, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            object = entry;
            KtProperty property = (KtProperty)object.getKey();
            object = entry;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object.getValue();
            KtProperty ktProperty = property;
            Intrinsics.checkExpressionValueIsNotNull(ktProperty, "property");
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "propertyDescriptor");
            this.checkProperty(ktProperty, propertyDescriptor2);
            this.modifiersChecker.checkModifiersForDeclaration(property, propertyDescriptor);
            KtProperty ktProperty2 = property;
            Intrinsics.checkExpressionValueIsNotNull(ktProperty2, "property");
            this.identifierChecker.checkDeclaration(ktProperty2, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ClassConstructorDescriptor constructorDescriptor;
            object = entry;
            declaration = (KtSecondaryConstructor)object.getKey();
            object = entry;
            ClassConstructorDescriptor classConstructorDescriptor = constructorDescriptor = (ClassConstructorDescriptor)object.getValue();
            Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor, "constructorDescriptor");
            KtDeclarationStub ktDeclarationStub = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclarationStub, "declaration");
            this.checkConstructorDeclaration(classConstructorDescriptor, (KtConstructor<?>)ktDeclarationStub);
            KtDeclarationStub ktDeclarationStub2 = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclarationStub2, "declaration");
            KtFunction ktFunction = ktDeclarationStub2;
            ClassConstructorDescriptor classConstructorDescriptor2 = constructorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor2, "constructorDescriptor");
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, ktFunction, classConstructorDescriptor2, null, 4, null);
        }
        for (Map.Entry entry : bodiesResolveContext.getTypeAliases().entrySet()) {
            object = entry;
            declaration = (KtTypeAlias)object.getKey();
            object = entry;
            TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)object.getValue();
            KtDeclarationStub ktDeclarationStub = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclarationStub, "declaration");
            TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(typeAliasDescriptor2, "typeAliasDescriptor");
            this.checkTypeAliasDeclaration((KtTypeAlias)ktDeclarationStub, typeAliasDescriptor2);
            this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
            KtDeclarationStub ktDeclarationStub3 = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclarationStub3, "declaration");
            TypeAliasDescriptor typeAliasDescriptor3 = typeAliasDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(typeAliasDescriptor3, "typeAliasDescriptor");
            this.exposedChecker.checkTypeAlias((KtTypeAlias)ktDeclarationStub3, typeAliasDescriptor3);
        }
    }

    public final void checkLocalTypeAliasDeclaration(@NotNull KtTypeAlias declaration, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(typeAliasDescriptor, "typeAliasDescriptor");
        this.checkTypeAliasDeclaration(declaration, typeAliasDescriptor);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
        this.exposedChecker.checkTypeAlias(declaration, typeAliasDescriptor);
    }

    private final void checkTypeAliasDeclaration(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        KtTypeReference ktTypeReference = declaration.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        this.checkTypeAliasExpansion(declaration, typeAliasDescriptor);
        SimpleType expandedType = typeAliasDescriptor.getExpandedType();
        if (expandedType.isError()) {
            return;
        }
        ClassifierDescriptor expandedClassifier = expandedType.getConstructor().getDeclarationDescriptor();
        if (DynamicTypesKt.isDynamic(expandedType) || expandedClassifier instanceof TypeParameterDescriptor) {
            this.trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), expandedType));
        }
        if (TypeUtils.contains((KotlinType)expandedType, checkTypeAliasDeclaration.1.INSTANCE)) {
            this.trace.report(Errors.TYPEALIAS_EXPANDED_TO_MALFORMED_TYPE.on((KtTypeReference)((PsiElement)typeReference), expandedType, "Array<Nothing> is illegal"));
        }
        Set<TypeParameterDescriptor> usedTypeAliasParameters = this.getUsedTypeAliasParameters(expandedType, typeAliasDescriptor);
        for (TypeParameterDescriptor typeParameter : typeAliasDescriptor.getDeclaredTypeParameters()) {
            KtTypeParameter source;
            if (!(usedTypeAliasParameters.contains(typeParameter) ^ true)) continue;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameterDescriptor);
            if (!(psiElement instanceof KtTypeParameter)) {
                psiElement = null;
            }
            if ((KtTypeParameter)psiElement == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No source element for type parameter " + typeParameter + " of " + typeAliasDescriptor)));
            }
            this.trace.report(Errors.UNUSED_TYPEALIAS_PARAMETER.on((KtTypeParameter)((PsiElement)source), typeParameter, expandedType));
        }
        if (declaration.hasModifier(KtTokens.IMPL_KEYWORD)) {
            this.checkImplTypeAlias(declaration, typeAliasDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkImplTypeAlias(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        void $receiver$iv$iv;
        boolean bl;
        Iterable $receiver$iv;
        SimpleType rhs;
        block9: {
            boolean bl2;
            Object it;
            block8: {
                rhs = typeAliasDescriptor.getUnderlyingType();
                ClassifierDescriptor classDescriptor = rhs.getConstructor().getDeclarationDescriptor();
                if (!(classDescriptor instanceof ClassDescriptor)) {
                    this.trace.report(Errors.IMPL_TYPE_ALIAS_NOT_TO_CLASS.on((KtTypeAlias)((PsiElement)declaration)));
                    return;
                }
                $receiver$iv = ((ClassDescriptor)classDescriptor).getDeclaredTypeParameters();
                for (Object element$iv : $receiver$iv) {
                    it = (TypeParameterDescriptor)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getVariance(), (Object)Variance.INVARIANT) ^ true)) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            if (bl2) {
                this.trace.report(Errors.IMPL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
                return;
            }
            $receiver$iv = rhs.getArguments();
            for (Object element$iv : $receiver$iv) {
                it = (TypeProjection)element$iv;
                if (!(Intrinsics.areEqual((Object)it.getProjectionKind(), (Object)Variance.INVARIANT) ^ true || it.isStarProjection())) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            this.trace.report(Errors.IMPL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
        $receiver$iv = rhs.getArguments();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection $i$f$any = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            collection.add(typeParameterDescriptor);
        }
        if (Intrinsics.areEqual((List)destination$iv$iv, typeAliasDescriptor.getDeclaredTypeParameters()) ^ true) {
            this.trace.report(Errors.IMPL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TypeParameterDescriptor> getUsedTypeAliasParameters(KotlinType type2, TypeAliasDescriptor typeAlias) {
        void $receiver$iv;
        Iterable iterable = TypeUtilsKt.constituentTypes(type2);
        Collection destination$iv = new HashSet();
        void $receiver$iv$iv = $receiver$iv;
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2;
            TypeParameterDescriptor it;
            TypeParameterDescriptor descriptor2;
            Object element$iv = element$iv$iv;
            KotlinType it2 = (KotlinType)element$iv;
            ClassifierDescriptor classifierDescriptor = it2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor3 = (descriptor2 = (TypeParameterDescriptor)classifierDescriptor) != null ? (Intrinsics.areEqual((it = typeParameterDescriptor2).getContainingDeclaration(), typeAlias) ? typeParameterDescriptor2 : null) : null;
            if (typeParameterDescriptor3 == null) continue;
            TypeParameterDescriptor it$iv = typeParameterDescriptor = typeParameterDescriptor3;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final void checkTypeAliasExpansion(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        TypeAliasDeclarationCheckingReportStrategy reportStrategy = new TypeAliasDeclarationCheckingReportStrategy(this.trace, typeAliasDescriptor, declaration);
        new TypeAliasExpander(reportStrategy).expandWithoutAbbreviation(typeAliasExpansion, Annotations.Companion.getEMPTY());
    }

    private final void checkConstructorDeclaration(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration);
        this.checkHeaderClassConstructor(constructorDescriptor, declaration);
    }

    private final void checkHeaderClassConstructor(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        KtConstructorDelegationCall delegationCall;
        if (!constructorDescriptor.isHeader()) {
            return;
        }
        if (declaration.hasBody()) {
            this.trace.report(Errors.HEADER_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (Intrinsics.areEqual((Object)constructorDescriptor.getContainingDeclaration().getKind(), (Object)ClassKind.ENUM_CLASS)) {
            this.trace.report(Errors.HEADER_ENUM_CONSTRUCTOR.on((KtConstructor<?>)((PsiElement)declaration)));
        }
        if (declaration instanceof KtPrimaryConstructor && !DescriptorUtils.isAnnotationClass(constructorDescriptor.getConstructedClass())) {
            for (KtParameter parameter : ((KtPrimaryConstructor)declaration).getValueParameters()) {
                if (!parameter.hasValOrVar()) continue;
                this.trace.report(Errors.HEADER_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        if (declaration instanceof KtSecondaryConstructor && !(delegationCall = ((KtSecondaryConstructor)declaration).getDelegationCall()).isImplicit()) {
            this.trace.report(Errors.HEADER_CLASS_CONSTRUCTOR_DELEGATION_CALL.on((KtConstructorDelegationCall)((PsiElement)delegationCall)));
        }
    }

    private final void checkConstructorVisibility(ClassConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration);
        if (visibilityModifier != null) {
            ASTNode aSTNode = visibilityModifier.getNode();
            if (Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KtTokens.PRIVATE_KEYWORD) ^ true) {
                ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
                if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ENUM_CLASS)) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
                } else if (Intrinsics.areEqual((Object)classDescriptor.getModality(), (Object)Modality.SEALED)) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED.on(visibilityModifier));
                }
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file2) {
        KtPackageDirective ktPackageDirective = file2.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        KtPackageDirective ktPackageDirective2 = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktPackageDirective2, "packageDirective");
        this.annotationChecker.check(ktPackageDirective2, this.trace, null);
        KtPackageDirective ktPackageDirective3 = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktPackageDirective3, "packageDirective");
        ModifierCheckerCore.INSTANCE.check(ktPackageDirective3, this.trace, null, this.languageVersionSettings);
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        Function1<KtTypeReference, KotlinType> type$ = new Function1<KtTypeReference, KotlinType>(this){
            final /* synthetic */ DeclarationsChecker this$0;

            @Nullable
            public final KotlinType invoke(@NotNull KtTypeReference $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                return (KotlinType)DeclarationsChecker.access$getTrace$p(this.this$0).getBindingContext().get(BindingContext.TYPE, $receiver);
            }
            {
                this.this$0 = declarationsChecker;
                super(1);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KotlinType kotlinType;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference2) == null) continue;
            KotlinType it = kotlinType;
            DescriptorResolver.checkBounds(typeReference2, it, this.trace);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter.getExtendsBound() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            if (constraint.getBoundTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            Object object = constraint.getSubjectTypeParameterName();
            if (object == null || (object = object.getReferencedNameAsName()) == null) {
                continue;
            }
            Object name = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            DescriptorResolver.checkBounds(request.upperBound, request.upperBoundType, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        void otherBounds;
        void boundsWhichAreTypeParameters;
        Object object;
        Collection collection;
        void $receiver$iv$iv;
        Object $receiver$iv;
        List<KotlinType> upperBounds2 = descriptor2.getUpperBounds();
        Iterable iterable = upperBounds2;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            object = ((KotlinType)receiver).getConstructor();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            TypeConstructor constructor = (TypeConstructor)element$iv;
            if (constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Object pair = $receiver$iv = new Pair(first$iv, second$iv);
        Object object2 = TuplesKt.to(CollectionsKt.toSet((Iterable)((Pair)pair).getFirst()), CollectionsKt.toSet((Iterable)((Pair)pair).getSecond()));
        Set set = ((Pair)object2).component1();
        Set set2 = ((Pair)object2).component2();
        object2 = null;
        if (boundsWhichAreTypeParameters.size() > 1 || boundsWhichAreTypeParameters.size() == 1 && !(object2 = (Collection)otherBounds).isEmpty()) {
            KtModifierListOwnerStub ktModifierListOwnerStub;
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object3;
                Object v2;
                block10: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2;
                    Iterable $receiver$iv$iv2;
                    Iterable $receiver$iv2;
                    pair = owner.getTypeConstraints();
                    void $i$a$3$let = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv2;
                        KtSimpleNameExpression ktSimpleNameExpression = constraint.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null, declaration.getNameAsName())) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $receiver$iv2 = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = $receiver$iv2;
                    destination$iv$iv2 = new ArrayList();
                    Iterable $receiver$iv$iv$iv = $receiver$iv$iv2;
                    element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        KtTypeReference ktTypeReference;
                        element$iv$iv$iv = element$iv$iv2.next();
                        Object element$iv$iv3 = element$iv$iv$iv;
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv3;
                        if (constraint.getBoundTypeReference() == null) continue;
                        KtTypeReference it$iv$iv = ktTypeReference;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $receiver$iv2 = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = $receiver$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        void typeReference;
                        element$iv$iv$iv = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        object = TuplesKt.to(typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                        collection.add(object);
                    }
                    List allBounds = (List)destination$iv$iv2;
                    Iterable $receiver$iv3 = allBounds;
                    for (Object element$iv : $receiver$iv3) {
                        Pair bound = (Pair)element$iv;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(Intrinsics.areEqual(kotlinType != null ? kotlinType.getConstructor() : null, (TypeConstructor)CollectionsKt.first((Iterable)boundsWhichAreTypeParameters)) ^ true)) continue;
                        v2 = element$iv;
                        break block10;
                    }
                    v2 = null;
                }
                ktModifierListOwnerStub = (object3 = (problematicBound = (Pair)v2)) != null && (object3 = (KtTypeReference)((Pair)object3).getFirst()) != null ? (KtModifierListOwnerStub)object3 : (KtModifierListOwnerStub)declaration;
            } else {
                ktModifierListOwnerStub = declaration;
            }
            KtModifierListOwnerStub reportOn = ktModifierListOwnerStub;
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        Object object;
        Object object2;
        Object destination$iv$iv;
        if (classifier2 instanceof TypeParameterDescriptor) {
            void $receiver$iv$iv;
            Iterable entry = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            Iterable iterable = entry;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(entry, 10));
            for (Map.Entry item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)((Object)item$iv$iv);
                object2 = destination$iv$iv;
                object = it.getConstructor();
                object2.add(object);
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet(immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        destination$iv$iv = multiMap.asMap();
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            ClassDescriptor containingDeclaration;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Map.Entry item$iv$iv;
            item$iv$iv = entry;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv.getKey();
            item$iv$iv = entry;
            Collection projections = (Collection)item$iv$iv.getValue();
            if (projections.size() <= 1) continue;
            Iterable $i$a$1$map = $receiver$iv = (Iterable)projections;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv2;
                object2 = destination$iv$iv2;
                object = it.getType();
                object2.add(object);
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((List)destination$iv$iv2);
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor declarationDescriptor = typeParameterDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClassButNotObject(KtClass aClass2, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass2);
        this.checkTypeParameterConstraints(aClass2);
        FiniteBoundRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        if (aClass2.isInterface()) {
            this.checkConstructorInInterface(aClass2);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass2.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass2), classDescriptor));
            }
        } else if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ANNOTATION_CLASS)) {
            this.checkAnnotationClassWithBody(aClass2);
            this.checkValOnAnnotationParameter(aClass2);
        } else if (aClass2 instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass2, classDescriptor);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor primaryConstructor2 = classConstructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor propertyDescriptor;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) == null) continue;
            PropertyDescriptor it = propertyDescriptor;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, it);
            KtParameter ktParameter = parameter;
            Intrinsics.checkExpressionValueIsNotNull(ktParameter, "parameter");
            KtCallableDeclaration ktCallableDeclaration = ktParameter;
            PropertyDescriptor propertyDescriptor2 = it;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "it");
            this.checkPropertyLateInit(ktCallableDeclaration, propertyDescriptor2);
        }
        if (!declaration.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                KtModifierList ktModifierList2;
                KtModifierList it = ktModifierList2 = ktModifierList;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)((PsiElement)it)));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = primaryConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor2, "primaryConstructor");
        this.checkConstructorDeclaration(classConstructorDescriptor2, declaration);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            AnnotationResolverImpl.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) == null) continue;
            TypeParameterDescriptor it = typeParameterDescriptor;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, jetTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter.getExtendsBound() != null) {
                KtTypeParameter ktTypeParameter = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
                List<KtTypeConstraint> list2 = constraints;
                Intrinsics.checkExpressionValueIsNotNull(list2, "constraints");
                if (DeclarationsChecker.Companion.hasConstraints(ktTypeParameter, list2)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) {
                continue;
            }
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "typeParameterDescriptor");
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor2;
            KtTypeParameter ktTypeParameter = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
            this.checkSupertypesForConsistency(classifierDescriptor, ktTypeParameter);
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor3, "typeParameterDescriptor");
            KtTypeParameter ktTypeParameter2 = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter2, "typeParameter");
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor3, ktTypeParameter2, typeParameterListOwner);
        }
    }

    private final void checkConstructorInInterface(KtClass klass2) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor;
            KtPrimaryConstructor ktPrimaryConstructor2 = klass2.getPrimaryConstructor();
            if (ktPrimaryConstructor2 == null) break block0;
            KtPrimaryConstructor it = ktPrimaryConstructor = ktPrimaryConstructor2;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassWithBody(KtClassOrObject classOrObject) {
        block0: {
            KtClassBody ktClassBody;
            KtClassBody ktClassBody2 = classOrObject.getBody();
            if (ktClassBody2 == null) break block0;
            KtClassBody it = ktClassBody = ktClassBody2;
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(it));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass2) {
        for (KtParameter parameter : aClass2.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                continue;
            }
            if (!parameter.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (Intrinsics.areEqual((Object)memberDescriptor.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) continue;
            CallableMemberDescriptor callableMemberDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "memberDescriptor");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(callableMemberDescriptor);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            if ((member = (KtNamedDeclaration)psiElement) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.OBJECT)) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor = containingDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "containingDeclaration");
            this.checkMemberProperty(property, propertyDescriptor, (ClassDescriptor)declarationDescriptor);
        }
        this.checkPropertyLateInit(property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property, propertyDescriptor, null, 4, null);
        this.shadowedExtensionChecker.checkDeclaration(property, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property, propertyDescriptor);
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        Set allTypeParameters = CollectionsKt.toSet((Iterable)descriptor2.getTypeParameters());
        HashSet allAccessibleTypeParameters = new HashSet();
        Function1<KotlinType, Unit> addAccessibleTypeParametersFromType$ = new Function1<KotlinType, Unit>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set $allTypeParameters;
            final /* synthetic */ HashSet $allAccessibleTypeParameters;

            public final void invoke(@Nullable KotlinType type2) {
                TypeUtils.contains(type2, new Function1<UnwrappedType, Boolean>(this){
                    final /* synthetic */ checkPropertyTypeParametersAreUsedInReceiverType.1 this$0;

                    public final boolean invoke(UnwrappedType it) {
                        ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                        if (declarationDescriptor instanceof TypeParameterDescriptor && this.this$0.$allTypeParameters.contains(declarationDescriptor) && this.this$0.$allAccessibleTypeParameters.add(declarationDescriptor)) {
                            Iterable $receiver$iv = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                            for (T element$iv : $receiver$iv) {
                                KotlinType p1 = (KotlinType)element$iv;
                                this.this$0.invoke(p1);
                            }
                        }
                        return false;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$allTypeParameters = set;
                this.$allAccessibleTypeParameters = hashSet;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        addAccessibleTypeParametersFromType$.invoke(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        Set typeParametersInaccessibleFromReceiver = SetsKt.minus(allTypeParameters, allAccessibleTypeParameters);
        Iterator iterator2 = typeParametersInaccessibleFromReceiver.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameterDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkPropertyLateInit(KtCallableDeclaration property, PropertyDescriptor propertyDescriptor) {
        Boolean hasBackingField;
        Boolean bl;
        boolean isAbstract;
        KtModifierList ktModifierList = property.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        PsiElement psiElement = modifierList.getModifier(KtTokens.LATEINIT_KEYWORD);
        if (psiElement == null) {
            return;
        }
        PsiElement modifier = psiElement;
        if (!propertyDescriptor.isVar()) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable properties"));
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        KotlinType returnType = propertyDescriptor.getReturnType();
        if (returnType != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType);
        }
        if (returnTypeIsNullable) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on nullable properties"));
        }
        if (returnTypeIsPrimitive) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primitive type properties"));
        }
        if (isAbstract = Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
        }
        if (property instanceof KtParameter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
        }
        boolean hasDelegateExpressionOrInitializer = false;
        if (property instanceof KtProperty && ((KtProperty)property).hasDelegateExpressionOrInitializer()) {
            hasDelegateExpressionOrInitializer = true;
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with initializer or on delegated properties"));
        }
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        if (!hasDelegateExpressionOrInitializer && hasAccessorImplementation) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
        }
        if ((bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor)) == null) {
            bl = hasBackingField = Boolean.valueOf(false);
        }
        if (!(isAbstract || hasAccessorImplementation || hasDelegateExpressionOrInitializer || hasBackingField.booleanValue())) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
        }
        if (propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
        }
    }

    private final void checkMemberProperty(KtProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList = property.getModifierList();
        if (modifierList != null) {
            if (modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                    PsiElement psiElement = property;
                    String string = property.getName();
                    if (string == null) {
                        string = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string, classDescriptor));
                    return;
                }
            } else if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE) && modifierList.hasModifier(KtTokens.OPEN_KEYWORD) && Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property)));
            }
        }
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            KtPropertyAccessor setter2;
            KtExpression it;
            KtElement ktElement;
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression != null) {
                it = ktElement = ktExpression;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)((PsiElement)it)));
            }
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate != null) {
                it = ktElement = ktPropertyDelegate;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)((Object)it)));
            }
            KtPropertyAccessor getter2 = property.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
            if ((setter2 = property.getSetter()) != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        block24: {
            block25: {
                block23: {
                    hasAccessorImplementation = org.jetbrains.kotlin.resolve.DeclarationsChecker$Companion.access$hasAccessorImplementation(DeclarationsChecker.Companion, propertyDescriptor);
                    containingDeclaration = propertyDescriptor.getContainingDeclaration();
                    v0 = inTrait = containingDeclaration instanceof ClassDescriptor != false && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.INTERFACE) != false;
                    if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                        if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                            this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
                        }
                        if (inTrait && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                            this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                        }
                        return;
                    }
                    v1 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                    if (v1 == null) {
                        v1 = backingFieldRequired = Boolean.valueOf(false);
                    }
                    if (inTrait) {
                        v2 = backingFieldRequired;
                        Intrinsics.checkExpressionValueIsNotNull(v2, "backingFieldRequired");
                        if (v2.booleanValue() && hasAccessorImplementation) {
                            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                        }
                    }
                    initializer = property.getInitializer();
                    delegate = property.getDelegate();
                    isHeader = propertyDescriptor.isHeader();
                    if (initializer == null) break block23;
                    if (inTrait) {
                        this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer)));
                    } else if (isHeader) {
                        this.trace.report(Errors.HEADER_PROPERTY_INITIALIZER.on((KtExpression)((PsiElement)initializer)));
                    } else if (!backingFieldRequired.booleanValue()) {
                        this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                    } else if (property.getReceiverTypeReference() != null) {
                        this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                    }
                    break block24;
                }
                if (delegate == null) break block25;
                if (inTrait) {
                    this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate)));
                }
                break block24;
            }
            v3 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            if (v3 == null) {
                v3 = false;
            }
            isUninitialized = v3;
            isExternal = DescriptorUtils.isEffectivelyExternal(propertyDescriptor);
            v4 = backingFieldRequired;
            Intrinsics.checkExpressionValueIsNotNull(v4, "backingFieldRequired");
            if (!v4.booleanValue() || inTrait || propertyDescriptor.isLateInit() || isHeader) ** GOTO lbl-1000
            v5 = isUninitialized;
            Intrinsics.checkExpressionValueIsNotNull(v5, "isUninitialized");
            if (v5.booleanValue() && !isExternal) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property)));
                } else {
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                }
            } else if (property.getTypeReference() == null && !this.languageVersionSettings.supportsFeature(LanguageFeature.ShortSyntaxForPropertyGetters)) {
                this.trace.report(Errors.UNSUPPORTED_FEATURE.on(property, TuplesKt.to(LanguageFeature.ShortSyntaxForPropertyGetters, this.languageVersionSettings)));
            } else if (this.noExplicitTypeOrGetterType(property)) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            v6 = backingFieldRequired;
            Intrinsics.checkExpressionValueIsNotNull(v6, "backingFieldRequired");
            if (v6.booleanValue() && !inTrait && propertyDescriptor.isLateInit() && !isUninitialized.booleanValue() && Intrinsics.areEqual((Boolean)this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor), true) ^ true) {
                this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property)));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean noExplicitTypeOrGetterType(KtProperty property) {
        if (property.getTypeReference() != null) return false;
        if (property.getGetter() == null) return true;
        KtPropertyAccessor ktPropertyAccessor = property.getGetter();
        if (ktPropertyAccessor == null) {
            Intrinsics.throwNpe();
        }
        if (!ktPropertyAccessor.hasBlockBody()) return false;
        KtPropertyAccessor ktPropertyAccessor2 = property.getGetter();
        if (ktPropertyAccessor2 == null) {
            Intrinsics.throwNpe();
        }
        if (ktPropertyAccessor2.getReturnTypeReference() != null) return false;
        return true;
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function2);
        this.checkImplicitCallableType(function2, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function2, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = DescriptorUtils.isEffectivelyExternal(functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = Intrinsics.areEqual((Object)((ClassDescriptor)containingDescriptor).getKind(), (Object)ClassKind.INTERFACE);
            boolean isHeaderClass = ((ClassDescriptor)containingDescriptor).isHeader();
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
                }
                if (!hasAbstractModifier && function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface || isHeaderClass)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
        } else if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier || functionDescriptor.isHeader())) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        if (functionDescriptor.isHeader()) {
            this.checkHeaderFunction(function2);
        }
        this.shadowedExtensionChecker.checkDeclaration(function2, functionDescriptor);
    }

    private final void checkHeaderFunction(KtNamedFunction function2) {
        if (function2.hasBody()) {
            this.trace.report(Errors.HEADER_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)function2)));
        }
        for (KtParameter parameter : function2.getValueParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            this.trace.report(Errors.HEADER_DECLARATION_WITH_DEFAULT_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        block2: {
            PsiElement target;
            KotlinType it;
            block3: {
                KotlinType kotlinType;
                KotlinType kotlinType2 = descriptor2.getReturnType();
                if (kotlinType2 == null || (kotlinType2 = kotlinType2.unwrap()) == null) break block2;
                it = kotlinType = kotlinType2;
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = target = (PsiElement)declaration;
                }
                if (declaration.getTypeReference() != null) break block3;
                if (TypeUtilsKt.isNothing(it) && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (!TypeUtilsKt.contains(it, checkImplicitCallableType.1.1.INSTANCE)) break block2;
                this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                break block2;
            }
            if (!TypeUtilsKt.isNothing(it) || !(it instanceof AbbreviatedType)) break block2;
            this.trace.report((declaration instanceof KtProperty ? Errors.ABBREVIATED_NOTHING_PROPERTY_TYPE : Errors.ABBREVIATED_NOTHING_RETURN_TYPE).on(target));
        }
    }

    private final void checkAccessors(KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property.getGetter() : property.getSetter();
            if (accessor != null) {
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        if (propertyDescriptor.isHeader() && accessor.hasBody()) {
            this.trace.report(Errors.HEADER_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)accessor)));
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, (Collection<KtModifierKeywordToken>)SetsKt.setOf(new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD}));
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual(accessorDescriptor.getVisibility(), Visibilities.PRIVATE) && Intrinsics.areEqual(propertyDescriptor.getVisibility(), Visibilities.PRIVATE) ^ true) {
            if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = Visibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || Intrinsics.compare(compare, 0) > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.SETTER_VISIBILITY\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor enumEntryClass) {
        DeclarationDescriptor declarationDescriptor = enumEntryClass.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor enumClass = (ClassDescriptor)declarationDescriptor;
        if (DescriptorUtils.isEnumClass(enumClass)) {
            if (enumClass.isHeader() && enumEntry.getBody() != null) {
                this.trace.report(Errors.HEADER_ENUM_ENTRY_WITH_BODY.on((KtEnumEntry)((PsiElement)enumEntry)));
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(enumClass);
            if (_Assertions.ENABLED && !bl) {
                String string = "Enum entry should be declared in enum class: " + enumEntryClass;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)callableDescriptor.getValueParameters();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!(it.getVarargElementType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            $receiver$iv$iv = varargParameters.iterator();
            while ($receiver$iv$iv.hasNext()) {
                KtParameter parameterDeclaration;
                ValueParameterDescriptor parameter;
                ValueParameterDescriptor valueParameterDescriptor = parameter = (ValueParameterDescriptor)$receiver$iv$iv.next();
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
                if (!(psiElement instanceof KtParameter)) {
                    psiElement = null;
                }
                if ((KtParameter)psiElement == null) {
                    continue;
                }
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)((PsiElement)parameterDeclaration)));
            }
        }
        SimpleType nullableNothing = DescriptorUtilsKt.getBuiltIns(callableDescriptor).getNullableNothingType();
        for (ValueParameterDescriptor parameter : varargParameters) {
            KtParameter parameterDeclaration;
            SimpleType varargElementType;
            KotlinType kotlinType = parameter.getVarargElementType();
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(varargElementType = FlexibleTypesKt.upperIfFlexible(kotlinType), nullableNothing)) continue;
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if ((KtParameter)psiElement == null) {
                continue;
            }
            trace.report(Errors.FORBIDDEN_VARARG_PARAMETER_TYPE.on((KtParameter)((PsiElement)parameterDeclaration), varargElementType));
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull TypeSpecificityComparator typeSpecificityComparator) {
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(annotationChecker, "annotationChecker");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(typeSpecificityComparator, "typeSpecificityComparator");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.modifiersChecker = modifiersChecker.withTrace(this.trace);
        this.exposedChecker = new ExposedVisibilityChecker(this.trace);
        this.shadowedExtensionChecker = new ShadowedExtensionChecker(typeSpecificityComparator, this.trace);
    }

    static {
        Companion = new Companion(null);
        METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(DeclarationsChecker $this) {
        return $this.trace;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$TypeAliasDeclarationCheckingReportStrategy;", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/psi/KtTypeAlias;)V", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "boundsViolationInSubstitution", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "unsubstitutedArgument", "argument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "kotlin-compiler"})
    private static final class TypeAliasDeclarationCheckingReportStrategy
    implements TypeAliasExpansionReportStrategy {
        private final KtTypeReference typeReference;
        private final BindingTrace trace;

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
            Intrinsics.checkParameterIsNotNull(substitutedArgument, "substitutedArgument");
            this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), substitutedArgument));
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
            this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), typeAlias));
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull KotlinType bound, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument, @NotNull TypeParameterDescriptor typeParameter) {
            Intrinsics.checkParameterIsNotNull(bound, "bound");
            Intrinsics.checkParameterIsNotNull(unsubstitutedArgument, "unsubstitutedArgument");
            Intrinsics.checkParameterIsNotNull(argument, "argument");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            if (!TypeUtilsKt.containsTypeAliasParameters(argument) && !TypeUtilsKt.containsTypeAliasParameters(bound)) {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), bound, argument, typeParameter));
            }
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
            SourceElement sourceElement = annotation2.getSource();
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            if (!(ktElement instanceof KtAnnotationEntry)) {
                ktElement = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }

        public TypeAliasDeclarationCheckingReportStrategy(@NotNull BindingTrace trace, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull KtTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(typeAliasDescriptor, "typeAliasDescriptor");
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            this.trace = trace;
            KtTypeReference ktTypeReference = declaration.getTypeReference();
            if (ktTypeReference == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Incorrect type alias declaration for " + typeAliasDescriptor)));
            }
            this.typeReference = ktTypeReference;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016H\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u001dH\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "getMETHOD_OF_ANY_NAMES", "()Lcom/google/common/collect/ImmutableSet;", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "kotlin-compiler"})
    public static final class Companion {
        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block2: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $receiver$iv = constraints;
                for (Object element$iv : $receiver$iv) {
                    KtTypeConstraint it = (KtTypeConstraint)element$iv;
                    KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                    if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null, typeParameter.getName())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private final ImmutableSet<String> getMETHOD_OF_ANY_NAMES() {
            return METHOD_OF_ANY_NAMES;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!this.getMETHOD_OF_ANY_NAMES().contains(member.getName().asString())) {
                return false;
            }
            if (Intrinsics.areEqual((Object)member.getModality(), (Object)Modality.ABSTRACT)) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual(DescriptorUtils.getFqName(containingDeclaration), KotlinBuiltIns.FQ_NAMES.any)) {
                    return true;
                }
                CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "overridden");
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor2)) continue;
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "containingDeclaration");
                visitedClasses.add((ClassDescriptor)declarationDescriptor);
                CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor3, "overridden");
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor3, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList = ktModifierList;
            return !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean hasAccessorImplementation(@NotNull PropertyDescriptor $receiver) {
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            PropertyGetterDescriptor it;
            PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
            if (propertyGetterDescriptor != null && DescriptorPsiUtilsKt.hasBody(it = (propertyAccessorDescriptor = propertyGetterDescriptor))) {
                return true;
            }
            PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
            return propertySetterDescriptor != null && DescriptorPsiUtilsKt.hasBody(it = (propertyAccessorDescriptor = propertySetterDescriptor));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

