/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.Set;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.DelegatingGlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

public class JavaClassFinderImpl
implements JavaClassFinder {
    private Project project;
    private GlobalSearchScope baseScope;
    private GlobalSearchScope javaSearchScope;
    private KotlinJavaPsiFacade javaFacade;

    @Inject
    public void setProject(@NotNull Project project) {
        if (project == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    @Inject
    public void setScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(1);
        }
        this.baseScope = scope;
    }

    @PostConstruct
    public void initialize(@NotNull BindingTrace trace, @NotNull KotlinCodeAnalyzer codeAnalyzer) {
        if (trace == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(2);
        }
        if (codeAnalyzer == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(3);
        }
        this.javaSearchScope = new FilterOutKotlinSourceFilesScope(this.baseScope);
        this.javaFacade = KotlinJavaPsiFacade.getInstance(this.project);
        CodeAnalyzerInitializer.Companion.getInstance(this.project).initialize(trace, codeAnalyzer.getModuleDescriptor(), codeAnalyzer);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull ClassId classId) {
        PsiClass psiClass;
        if (classId == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(4);
        }
        if ((psiClass = this.javaFacade.findClass(classId, this.javaSearchScope)) == null) {
            return null;
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        FqName fqName2 = classId.asSingleFqName();
        if (!fqName2.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName2 + ", got " + javaClass.getFqName());
        }
        if (psiClass instanceof KtLightClassMarker) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName2);
        }
        return javaClass;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2) {
        PsiPackage psiPackage;
        if (fqName2 == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(5);
        }
        return (psiPackage = this.javaFacade.findPackage(fqName2.asString(), this.javaSearchScope)) == null ? null : new JavaPackageImpl(psiPackage, this.javaSearchScope);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            JavaClassFinderImpl.$$$reportNull$$$0(6);
        }
        return this.javaFacade.knownClassNamesInPackage(packageFqName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeAnalyzer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/load/java/JavaClassFinderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "knownClassNamesInPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class FilterOutKotlinSourceFilesScope
    extends DelegatingGlobalSearchScope {
        public FilterOutKotlinSourceFilesScope(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                FilterOutKotlinSourceFilesScope.$$$reportNull$$$0(0);
            }
            super(baseScope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilterOutKotlinSourceFilesScope.$$$reportNull$$$0(1);
            }
            return this.myBaseScope.contains(file2) && (file2.isDirectory() || file2.getFileType() != KotlinFileType.INSTANCE);
        }

        @NotNull
        public GlobalSearchScope getBase() {
            GlobalSearchScope globalSearchScope = this.myBaseScope;
            if (globalSearchScope == null) {
                FilterOutKotlinSourceFilesScope.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = JavaClassFinderImpl.this.project;
            if (project == null) {
                FilterOutKotlinSourceFilesScope.$$$reportNull$$$0(3);
            }
            return project;
        }

        @Override
        public String toString() {
            return "JCFI: " + this.myBaseScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/load/java/JavaClassFinderImpl$FilterOutKotlinSourceFilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/load/java/JavaClassFinderImpl$FilterOutKotlinSourceFilesScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

