/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtBinaryExpression expression;
    protected final boolean isVariableReassignment;

    public static boolean isAssignmentOperator(KtToken operationToken) {
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            AssignmentTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AssignmentTranslator.$$$reportNull$$$0(1);
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression)) {
            JsExpression jsExpression = IntrinsicAssignmentTranslator.doTranslate(expression, context);
            if (jsExpression == null) {
                AssignmentTranslator.$$$reportNull$$$0(2);
            }
            return jsExpression;
        }
        JsExpression jsExpression = OverloadedAssignmentTranslator.doTranslate(expression, context);
        if (jsExpression == null) {
            AssignmentTranslator.$$$reportNull$$$0(3);
        }
        return jsExpression;
    }

    protected AssignmentTranslator(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            AssignmentTranslator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AssignmentTranslator.$$$reportNull$$$0(5);
        }
        super(context);
        this.expression = expression;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context.bindingContext(), expression);
        assert (expression.getLeft() != null) : "No left-hand side: " + expression.getText();
    }

    protected final AccessTranslator createAccessTranslator(@NotNull KtExpression left, boolean forceOrderOfEvaluation) {
        if (left == null) {
            AssignmentTranslator.$$$reportNull$$$0(6);
        }
        if (AssignmentTranslator.isReferenceToBackingFieldFromConstructor(left, this.context())) {
            KtSimpleNameExpression simpleName2 = PsiUtils.getSimpleName(left);
            assert (simpleName2 != null);
            return BackingFieldAccessTranslator.newInstance(simpleName2, this.context());
        }
        return AccessTranslationUtils.getAccessTranslator(left, this.context(), forceOrderOfEvaluation);
    }

    private static boolean isReferenceToBackingFieldFromConstructor(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        KtDotQualifiedExpression qualifiedExpression;
        if (expression == null) {
            AssignmentTranslator.$$$reportNull$$$0(7);
        }
        if (context == null) {
            AssignmentTranslator.$$$reportNull$$$0(8);
        }
        if (expression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)expression;
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), nameExpression);
            return AssignmentTranslator.isReferenceToBackingFieldFromConstructor(descriptor2, context);
        }
        if (expression instanceof KtDotQualifiedExpression && (qualifiedExpression = (KtDotQualifiedExpression)expression).getReceiverExpression() instanceof KtThisExpression && qualifiedExpression.getSelectorExpression() instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)qualifiedExpression.getSelectorExpression();
            DeclarationDescriptor descriptor3 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), nameExpression);
            return AssignmentTranslator.isReferenceToBackingFieldFromConstructor(descriptor3, context);
        }
        return false;
    }

    private static boolean isReferenceToBackingFieldFromConstructor(@Nullable DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (context == null) {
            AssignmentTranslator.$$$reportNull$$$0(9);
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        if (!(context.getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)context.getDeclarationDescriptor();
        if (classDescriptor != propertyDescriptor.getContainingDeclaration()) {
            return false;
        }
        return !propertyDescriptor.isVar();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAccessTranslator";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToBackingFieldFromConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

