/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.types.KotlinType;

public final class StringTemplateTranslator
extends AbstractTranslator {
    private final KtStringTemplateEntry[] expressionEntries;

    @NotNull
    public static JsExpression translate(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            StringTemplateTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            StringTemplateTranslator.$$$reportNull$$$0(1);
        }
        JsExpression jsExpression = new StringTemplateTranslator(expression, context).translate();
        if (jsExpression == null) {
            StringTemplateTranslator.$$$reportNull$$$0(2);
        }
        return jsExpression;
    }

    private StringTemplateTranslator(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            StringTemplateTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            StringTemplateTranslator.$$$reportNull$$$0(4);
        }
        super(context);
        this.expressionEntries = expression.getEntries();
        assert (this.expressionEntries.length != 0) : ErrorReportingUtils.message(expression, "String template must have one or more entries.");
    }

    @NotNull
    private JsExpression translate() {
        EntryVisitor entryVisitor = new EntryVisitor();
        for (KtStringTemplateEntry entry : this.expressionEntries) {
            entry.accept(entryVisitor);
        }
        JsExpression jsExpression = entryVisitor.getResultingExpression();
        if (jsExpression == null) {
            StringTemplateTranslator.$$$reportNull$$$0(5);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntryVisitor
    extends KtVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression) {
            if (expression == null) {
                EntryVisitor.$$$reportNull$$$0(0);
            }
            this.resultingExpression = this.resultingExpression == null ? expression : JsAstUtils.sum(this.resultingExpression, expression);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
            if (entry == null) {
                EntryVisitor.$$$reportNull$$$0(1);
            }
            KtExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "JetStringTemplateEntryWithExpression must have not null entry expression.";
            JsExpression translatedExpression = Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context());
            KotlinType type2 = StringTemplateTranslator.this.context().bindingContext().getType(entryExpression);
            if (translatedExpression instanceof JsNumberLiteral) {
                this.append(StringTemplateTranslator.this.context().program().getStringLiteral(translatedExpression.toString()));
                return;
            }
            if (type2 == null || type2.isMarkedNullable()) {
                this.append(TopLevelFIF.TO_STRING.apply((JsExpression)null, new SmartList<JsExpression>(translatedExpression), StringTemplateTranslator.this.context()));
            } else if (KotlinBuiltIns.isChar(type2)) {
                this.append(JsAstUtils.charToString(translatedExpression));
            } else if (this.mustCallToString(type2)) {
                this.append(new JsInvocation((JsExpression)new JsNameRef("toString", translatedExpression), new JsExpression[0]));
            } else {
                this.append(translatedExpression);
            }
        }

        private boolean mustCallToString(@NotNull KotlinType type2) {
            Name typeName;
            if (type2 == null) {
                EntryVisitor.$$$reportNull$$$0(2);
            }
            if ((typeName = DescriptorUtilsKt.getNameIfStandardType(type2)) != null) {
                if (NamePredicate.STRING.apply(typeName)) {
                    return false;
                }
                if (NamePredicate.PRIMITIVE_NUMBERS.apply(typeName)) {
                    return this.resultingExpression == null;
                }
            }
            return StringTemplateTranslator.this.expressionEntries.length == 1;
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry) {
            if (entry == null) {
                EntryVisitor.$$$reportNull$$$0(3);
            }
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
            if (entry == null) {
                EntryVisitor.$$$reportNull$$$0(4);
            }
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text2) {
            if (text2 == null) {
                EntryVisitor.$$$reportNull$$$0(5);
            }
            this.append(StringTemplateTranslator.this.program().getStringLiteral(text2));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            JsExpression jsExpression = this.resultingExpression;
            if (jsExpression == null) {
                EntryVisitor.$$$reportNull$$$0(6);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultingExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitStringTemplateEntryWithExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "mustCallToString";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLiteralStringTemplateEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitEscapeStringTemplateEntry";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

