/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.concurrency.BoundedTaskExecutor;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SchedulingWrapper;
import sun.awt.AWTAutoShutdown;

class AppDelayQueue
extends DelayQueue<SchedulingWrapper.MyScheduledFutureTask> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.concurrency.AppDelayQueue");
    private final Thread scheduledToPooledTransferer;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    AppDelayQueue() {
        this.scheduledToPooledTransferer = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!AppDelayQueue.this.shutdown.get()) {
                    try {
                        SchedulingWrapper.MyScheduledFutureTask task = (SchedulingWrapper.MyScheduledFutureTask)AppDelayQueue.this.take();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Took " + BoundedTaskExecutor.info(task));
                        }
                        if (task.isDone()) continue;
                        task.getBackendExecutorService().execute(task);
                    }
                    catch (InterruptedException e) {
                        if (AppDelayQueue.this.shutdown.get()) continue;
                        LOG.error(e);
                    }
                }
                LOG.debug("scheduledToPooledTransferer Stopped");
            }
        }, "Periodic tasks thread");
        this.scheduledToPooledTransferer.start();
        AWTAutoShutdown.getInstance().notifyThreadBusy(this.scheduledToPooledTransferer);
    }
}

