/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectoryContainer;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.AnyPsiChangeListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.EmptyFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;

public class PsiManagerImpl
extends PsiManagerEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiManagerImpl");
    private final Project myProject;
    private final FileIndexFacade myFileIndex;
    private final MessageBus myMessageBus;
    private final PsiModificationTracker myModificationTracker;
    private final FileManager myFileManager;
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<PsiTreeChangeListener> myTreeChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myTreeChangeEventIsFiring;
    private boolean myIsDisposed;
    private VirtualFileFilter myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
    private final AtomicInteger myBatchFilesProcessingModeCount = new AtomicInteger(0);
    public static final Topic<AnyPsiChangeListener> ANY_PSI_CHANGE_TOPIC = Topic.create("ANY_PSI_CHANGE_TOPIC", AnyPsiChangeListener.class, Topic.BroadcastDirection.TO_PARENT);

    public PsiManagerImpl(Project project, FileDocumentManager fileDocumentManager, PsiBuilderFactory psiBuilderFactory, FileIndexFacade fileIndex, MessageBus messageBus, PsiModificationTracker modificationTracker2) {
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myMessageBus = messageBus;
        this.myModificationTracker = modificationTracker2;
        PsiBuilderFactory used = psiBuilderFactory;
        boolean isProjectDefault = project.isDefault();
        this.myFileManager = isProjectDefault ? new EmptyFileManager(this) : new FileManagerImpl(this, fileDocumentManager, fileIndex);
        this.myTreeChangePreprocessors.add((PsiTreeChangePreprocessor)((Object)modificationTracker2));
        Disposer.register(project, new Disposable(){

            @Override
            public void dispose() {
                PsiManagerImpl.this.myIsDisposed = true;
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void dropResolveCaches() {
        FileManager fileManager = this.myFileManager;
        if (fileManager instanceof FileManagerImpl) {
            ((FileManagerImpl)fileManager).processQueue();
        }
        this.beforeChange(true);
        this.beforeChange(false);
    }

    @Override
    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "isInProject"));
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)element).getDirectories()) {
                if (this.isInProject(dir)) continue;
                return false;
            }
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile = null;
        if (file2 != null) {
            virtualFile = file2.getViewProvider().getVirtualFile();
        } else if (element instanceof PsiFileSystemItem) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        }
        if (file2 != null && file2.isPhysical() && virtualFile.getFileSystem() instanceof NonPhysicalFileSystem) {
            return true;
        }
        return virtualFile != null && this.myFileIndex.isInContent(virtualFile);
    }

    @Override
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter2, @NotNull Disposable parentDisposable) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "setAssertOnFileLoadingFilter"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "setAssertOnFileLoadingFilter"));
        }
        this.myAssertOnFileLoadingFilter = filter2;
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                PsiManagerImpl.this.myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
            }
        });
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "isAssertOnFileLoading"));
        }
        return this.myAssertOnFileLoadingFilter.accept(file2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        FileManager fileManager = this.myFileManager;
        if (fileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "getFileManager"));
        }
        return fileManager;
    }

    @Override
    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        ProgressIndicatorProvider.checkCanceled();
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        return element1.equals(element2) || element1.isEquivalentTo(element2) || element2.isEquivalentTo(element1);
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "findFile"));
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findFile(file2);
    }

    @Override
    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "findViewProvider"));
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findViewProvider(file2);
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "findDirectory"));
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findDirectory(file2);
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "reloadFromDisk"));
        }
        this.myFileManager.reloadFromDisk(file2);
    }

    @Override
    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "addPsiTreeChangeListener"));
        }
        this.myTreeChangeListeners.add(listener);
    }

    @Override
    public void addPsiTreeChangeListener(final @NotNull PsiTreeChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "addPsiTreeChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "addPsiTreeChangeListener"));
        }
        this.addPsiTreeChangeListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                PsiManagerImpl.this.removePsiTreeChangeListener(listener);
            }
        });
    }

    @Override
    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "removePsiTreeChangeListener"));
        }
        this.myTreeChangeListeners.remove(listener);
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "beforeChildAddition"));
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildAddition: event = " + event);
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "beforeChildRemoval"));
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildRemoval: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "beforeChildReplacement"));
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildReplacement: oldChild = " + event.getOldChild());
        }
        this.fireEvent(event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "beforeChildrenChange"));
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildrenChange: parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "beforeChildMovement"));
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildMovement: child = " + event.getChild() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent());
        }
        this.fireEvent(event);
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "beforePropertyChange"));
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforePropertyChange: element = " + event.getElement() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue());
        }
        this.fireEvent(event);
    }

    public void childAdded(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "childAdded"));
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childAdded: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childRemoved(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "childRemoved"));
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childRemoved: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childReplaced(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "childReplaced"));
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childReplaced: oldChild = " + event.getOldChild() + ", newChild = " + event.getNewChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childMoved(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "childMoved"));
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childMoved: child = " + event.getChild() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "childrenChanged"));
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childrenChanged: parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "propertyChanged"));
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertyChanged: element = " + event.getElement() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void addTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        if (preprocessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preprocessor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "addTreeChangePreprocessor"));
        }
        this.myTreeChangePreprocessors.add(preprocessor);
    }

    public void removeTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        if (preprocessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preprocessor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "removeTreeChangePreprocessor"));
        }
        this.myTreeChangePreprocessors.remove(preprocessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "fireEvent"));
        }
        boolean isRealTreeChange = event.getCode() != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && event.getCode() != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE;
        PsiFile file2 = event.getFile();
        if (file2 == null || file2.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (isRealTreeChange) {
            LOG.assertTrue(!this.myTreeChangeEventIsFiring, "Changes to PSI are not allowed inside event processing");
            this.myTreeChangeEventIsFiring = true;
        }
        try {
            for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessors) {
                preprocessor.treeChanged(event);
            }
            for (PsiTreeChangePreprocessor preprocessor : Extensions.getExtensions(PsiTreeChangePreprocessor.EP_NAME, (AreaInstance)this.myProject)) {
                preprocessor.treeChanged(event);
            }
            for (PsiTreeChangeListener listener : this.myTreeChangeListeners) {
                try {
                    switch (event.getCode()) {
                        case BEFORE_CHILD_ADDITION: {
                            listener.beforeChildAddition(event);
                            break;
                        }
                        case BEFORE_CHILD_REMOVAL: {
                            listener.beforeChildRemoval(event);
                            break;
                        }
                        case BEFORE_CHILD_REPLACEMENT: {
                            listener.beforeChildReplacement(event);
                            break;
                        }
                        case BEFORE_CHILD_MOVEMENT: {
                            listener.beforeChildMovement(event);
                            break;
                        }
                        case BEFORE_CHILDREN_CHANGE: {
                            listener.beforeChildrenChange(event);
                            break;
                        }
                        case BEFORE_PROPERTY_CHANGE: {
                            listener.beforePropertyChange(event);
                            break;
                        }
                        case CHILD_ADDED: {
                            listener.childAdded(event);
                            break;
                        }
                        case CHILD_REMOVED: {
                            listener.childRemoved(event);
                            break;
                        }
                        case CHILD_REPLACED: {
                            listener.childReplaced(event);
                            break;
                        }
                        case CHILD_MOVED: {
                            listener.childMoved(event);
                            break;
                        }
                        case CHILDREN_CHANGED: {
                            listener.childrenChanged(event);
                            break;
                        }
                        case PROPERTY_CHANGED: {
                            listener.propertyChanged(event);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            if (isRealTreeChange) {
                this.myTreeChangeEventIsFiring = false;
            }
        }
    }

    @Override
    public void registerRunnableToRunOnChange(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "registerRunnableToRunOnChange"));
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    runnable.run();
                }
            }
        });
    }

    @Override
    public void registerRunnableToRunOnAnyChange(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "registerRunnableToRunOnAnyChange"));
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                runnable.run();
            }
        });
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "registerRunnableToRunAfterAnyChange"));
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

            @Override
            public void afterPsiChanged(boolean isPhysical) {
                runnable.run();
            }
        });
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC).beforePsiChanged(isPhysical);
    }

    @Override
    public void afterChange(boolean isPhysical) {
        this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC).afterPsiChanged(isPhysical);
    }

    @Override
    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = this.myModificationTracker;
        if (psiModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiManagerImpl", "getModificationTracker"));
        }
        return psiModificationTracker;
    }

    @Override
    public void startBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.incrementAndGet();
    }

    @Override
    public void finishBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.decrementAndGet();
        LOG.assertTrue(this.myBatchFilesProcessingModeCount.get() >= 0);
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return this.myBatchFilesProcessingModeCount.get() > 0;
    }

    public void cleanupForNextTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileManager.cleanupForNextTest();
        this.dropResolveCaches();
    }
}

