/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayOutputStream;

public class StreamUtil {
    private static final Logger LOG = Logger.getInstance(StreamUtil.class);

    private StreamUtil() {
    }

    public static int copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream2) throws IOException {
        int count;
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "copyStreamContent"));
        }
        if (outputStream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "copyStreamContent"));
        }
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream2.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    @NotNull
    public static byte[] loadFromStream(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "loadFromStream"));
        }
        UnsyncByteArrayOutputStream outputStream2 = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copyStreamContent(inputStream, outputStream2);
        }
        finally {
            inputStream.close();
        }
        byte[] byArray = outputStream2.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "loadFromStream"));
        }
        return byArray;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        byte[] data2 = StreamUtil.loadFromStream(inputStream);
        String string = new String(data2, encoding);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        return string;
    }

    public static void closeStream(@Nullable Closeable stream2) {
        if (stream2 != null) {
            try {
                stream2.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }
}

